/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.server.BinExchange;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.ConsoleReadCmdItem;
import org.eclipse.statet.rj.server.CtrlCmdItem;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.DbgCmdItem;
import org.eclipse.statet.rj.server.ExtClientCmdItem;
import org.eclipse.statet.rj.server.GDCmdItem;
import org.eclipse.statet.rj.server.GraOpCmdItem;
import org.eclipse.statet.rj.server.MainCmdC2SList;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.MainCtrlCmdItem;
import org.eclipse.statet.rj.server.REngine;
import org.eclipse.statet.rj.server.RjsComObject;
import org.eclipse.statet.rj.server.RjsPing;
import org.eclipse.statet.rj.server.RjsStatus;
import org.eclipse.statet.rj.server.client.DaemonThreadFactory;
import org.eclipse.statet.rj.server.client.RClientGraphic;
import org.eclipse.statet.rj.server.client.RClientGraphicActions;
import org.eclipse.statet.rj.server.client.RClientGraphicDummy;
import org.eclipse.statet.rj.server.client.RClientGraphicDummyFactory;
import org.eclipse.statet.rj.server.client.RClientGraphicFactory;
import org.eclipse.statet.rj.server.dbg.CtrlReport;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;

public abstract class AbstractRJComClient
implements ComHandler {
    public static final @NonNull String RJ_CLIENT_ID = "org.eclipse.statet.rj.client";
    public static final int EXTRA_BEFORE = 1;
    public static final int EXTRA_NESTED = 2;
    private static final ScheduledExecutorService RJHelper_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("RJHelper"));
    private static final Random RAND = new Random();
    private RService rService;
    private Object rHandle;
    private ProgressMonitor progressMonitor;
    private final RJIO mainIO = new RJIO();
    private MainCmdItem mainC2SFirst;
    private final MainCmdC2SList mainC2SList = new MainCmdC2SList(this.mainIO);
    private final RunnableList mainDeferredCmds = new RunnableList();
    private boolean mainRunGC;
    private boolean consoleReadCallbackRequired;
    private ConsoleReadCmdItem consoleReadCallback;
    private final Object platformLock = new Object();
    private Map<String, Object> platformData;
    private RPlatform platformObj;
    private final byte randomId = (byte)(0xFF & RAND.nextInt(255));
    private int dataLevelRequest = 0;
    private int dataLevelAnswer = 0;
    private int dataLevelIgnore = 0;
    private byte dataRequestCounter = (byte)(0xFF & RAND.nextInt(255));
    private final int[] dataRequestId = new int[32];
    private final MainCmdItem[] dataAnswer = new MainCmdItem[32];
    private boolean runFinishTask;
    private boolean dbgOpRequest;
    private DbgCmdItem dbgOpAnswer;
    private int hotModeState;
    private ConsoleReadCmdItem hotModeReadCallbackBackup;
    private MainCmdItem hotModeC2SFirstBackup;
    private final AtomicBoolean hotModeRequested = new AtomicBoolean();
    private final Runnable hotModeRunnable = new HotModeRequestRunnable();
    private int extraModeRequested;
    private RClientGraphicFactory graphicFactory;
    private @Nullable RClientGraphicActions graphicActions;
    private final RClientGraphic graphicDummy = new RClientGraphicDummy(1, 0.0, 0.0);
    private RClientGraphic[] graphics = new RClientGraphic[16];
    private int currentGraphicOptions;
    private RClientGraphic lastGraphic;
    private REngine rjConsoleEngine;
    private List<Runnable> defferedRunnables;
    private boolean closed;
    private ScheduledFuture<?> periodicCheckJob;
    private String closedMessage = "Connection to R engine is closed.";
    private final Lock clientWaitLock = new ReentrantLock();
    private final Condition clientWaitCondition = this.clientWaitLock.newCondition();
    private final List<Callable<Boolean>> cancelHandler = new ArrayList<Callable<Boolean>>();

    public static int[] version() {
        int[] nArray = new int[3];
        nArray[0] = 4;
        return nArray;
    }

    protected AbstractRJComClient() {
    }

    public void initClient(Object rHandle, RService r, Map<String, Object> properties, int id) {
        this.rHandle = rHandle;
        this.rService = r;
        properties.put("rj.com.init", Boolean.TRUE);
        properties.put("rj.com.s2c.id", id);
        try {
            this.initGraphicFactory();
        }
        catch (Exception e) {
            this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when initializing R client graphic factory.", (Throwable)e));
        }
        if (this.graphicFactory != null) {
            Map<String, ? extends Object> additional = this.graphicFactory.getInitServerProperties();
            if (additional != null) {
                properties.putAll(additional);
            }
        } else {
            this.graphicFactory = new RClientGraphicDummyFactory();
            this.log((Status)new WarningStatus(RJ_CLIENT_ID, "No R client graphic factory configured."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setServer(REngine rjServer, int client) {
        List<Runnable> runnables;
        AbstractRJComClient abstractRJComClient = this;
        synchronized (abstractRJComClient) {
            this.rjConsoleEngine = rjServer;
            if (client == 0) {
                int intervalMillis = 45000;
                try {
                    String p = System.getProperty("org.eclipse.statet.rj.client.keepaliveInterval");
                    if (p != null && p.length() > 0) {
                        intervalMillis = Integer.parseInt(p);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.initPeriodicCheck(new KeepAliveRunnable(), intervalMillis);
            }
            runnables = this.defferedRunnables;
            this.defferedRunnables = null;
        }
        if (runnables != null) {
            int i = 0;
            while (i < runnables.size()) {
                RJHelper_EXECUTOR.execute(runnables.get(i));
                ++i;
            }
        }
    }

    public void initPeriodicCheck(Runnable runnable, long intervalMillis) {
        this.periodicCheckJob = RJHelper_EXECUTOR.scheduleWithFixedDelay(runnable, 1000L, intervalMillis, TimeUnit.MILLISECONDS);
    }

    public Object getRHandle() {
        return this.rHandle;
    }

    public RService getRService() {
        return this.rService;
    }

    public final REngine getConsoleEngine() {
        return this.rjConsoleEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execAsync(Runnable runnable) {
        AbstractRJComClient abstractRJComClient = this;
        synchronized (abstractRJComClient) {
            if (this.rjConsoleEngine == null) {
                if (this.defferedRunnables == null) {
                    this.defferedRunnables = new ArrayList<Runnable>(8);
                }
                this.defferedRunnables.add(runnable);
                return;
            }
        }
        RJHelper_EXECUTOR.execute(runnable);
    }

    protected void initGraphicFactory() {
    }

    public final void setGraphicFactory(RClientGraphicFactory factory, @Nullable RClientGraphicActions actions) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.graphicFactory = factory;
        this.graphicActions = actions;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (this.closed != closed) {
            ScheduledFuture<?> job;
            this.closed = closed;
            if (closed && (job = this.periodicCheckJob) != null) {
                this.periodicCheckJob = null;
                job.cancel(true);
            }
        }
    }

    public void setRjsProperties(Map<String, ? extends Object> properties) throws StatusException {
        try {
            this.rjConsoleEngine.setProperties(properties);
        }
        catch (RemoteException e) {
            throw new StatusException((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when setting server properties.", (Throwable)e));
        }
    }

    public final void processMainCmd(ObjectInput in) throws IOException {
        byte type;
        boolean runGC = false;
        this.updateBusy(in.readBoolean());
        if (this.hotModeState == 4) {
            this.hotModeState = 0;
            this.consoleReadCallback = this.hotModeReadCallbackBackup;
            this.hotModeReadCallbackBackup = null;
            if (this.hotModeC2SFirstBackup != null) {
                this.addC2SCmd(this.hotModeC2SFirstBackup);
                this.hotModeC2SFirstBackup = null;
            }
        }
        this.mainIO.connect(in);
        int check = this.mainIO.readCheck1();
        block12: while (true) {
            type = in.readByte();
            switch (type) {
                case 0: {
                    this.mainIO.readCheck2(check);
                    this.mainIO.disconnect(in);
                    this.mainRunGC = runGC;
                    return;
                }
                case 1: {
                    this.processPrompt(new ConsoleReadCmdItem(this.mainIO));
                    continue block12;
                }
                case 2: {
                    runGC = true;
                    this.writeConsoleOutput(this.mainIO.readByte(), this.mainIO.readString());
                    continue block12;
                }
                case 4: {
                    runGC = true;
                    this.showMessage(this.mainIO.readString());
                    continue block12;
                }
                case 5: {
                    runGC = true;
                    this.processUICallback(this.mainIO);
                    continue block12;
                }
                case 7: {
                    runGC = true;
                    this.processGDCmd(this.mainIO);
                    continue block12;
                }
                case 16: {
                    runGC = true;
                    this.processMainCtrlCmd(this.mainIO);
                    continue block12;
                }
                case 17: {
                    runGC = true;
                    this.processDataCmd(this.mainIO);
                    continue block12;
                }
                case 18: {
                    runGC = true;
                    this.processGraphicsOpCmd(this.mainIO);
                    continue block12;
                }
                case 20: {
                    runGC = true;
                    this.processDbgCmd(this.mainIO);
                    continue block12;
                }
            }
            break;
        }
        this.mainIO.disconnect(in);
        throw new IOException("Unknown cmdtype id: " + type);
    }

    private final void processCmdDeferred(Runnable runnable) {
        this.mainDeferredCmds.add(runnable);
    }

    public final boolean processUICallback(RJIO io) throws IOException {
        ExtClientCmdItem item;
        block4: {
            item = new ExtClientCmdItem(io);
            try {
                RList answer = this.handleUICallback(item.getDataText(), item.getDataArgs(), item.waitForClient(), this.progressMonitor);
                item.setAnswer(answer);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when exec RJ UI command '" + item.getDataText() + "'.", (Throwable)e));
                if (!item.waitForClient()) break block4;
                item.setAnswer(new RjsStatus(4, 0, "Client error processing current command."));
            }
        }
        if (item.waitForClient()) {
            this.addC2SCmd((MainCmdItem)item);
            return true;
        }
        return false;
    }

    protected RList handleUICallback(String commandId, @Nullable RList args, boolean acceptsAnswer, ProgressMonitor m) throws Exception {
        throw new StatusException((Status)new WarningStatus(RJ_CLIENT_ID, String.format("Unhandled RJ UI command '%1$s'.", commandId)));
    }

    public final void processGDCmd(RJIO io) throws IOException {
        int i = io.readInt();
        int options = i & Integer.MIN_VALUE;
        final int devId = i & Integer.MAX_VALUE;
        byte requestId = -1;
        try {
            switch (io.readByte()) {
                case 33: {
                    this.addGraphic(devId, io.readDouble(), io.readDouble(), io.readInt(), io.readBoolean());
                    return;
                }
                case 34: {
                    this.removeGraphic(devId);
                    return;
                }
                case 35: {
                    byte by = io.readByte();
                    requestId = by;
                    this.addC2SCmd((MainCmdItem)new GDCmdItem.DoubleAnswer(by, devId, this.getGraphic(devId).computeSize()));
                    return;
                }
                case 36: {
                    this.getGraphic(devId).setActive(false);
                    return;
                }
                case 37: {
                    this.getGraphic(devId).setActive(true);
                    return;
                }
                case 38: {
                    this.getGraphic(devId).setMode(io.readByte());
                    return;
                }
                case 39: {
                    byte by = io.readByte();
                    requestId = by;
                    this.addC2SCmd((MainCmdItem)new GDCmdItem.DoubleAnswer(by, devId, this.getGraphic(devId).computeFontMetric(io.readInt())));
                    return;
                }
                case 40: {
                    byte by = io.readByte();
                    requestId = by;
                    this.addC2SCmd((MainCmdItem)new GDCmdItem.DoubleAnswer(by, devId, this.getGraphic(devId).computeStringWidth(io.readString())));
                    return;
                }
                case 1: {
                    this.getGraphic(devId).addSetClip(io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble());
                    return;
                }
                case 2: {
                    this.getGraphic(devId).addSetColor(io.readInt());
                    return;
                }
                case 3: {
                    this.getGraphic(devId).addSetFill(io.readInt());
                    return;
                }
                case 4: {
                    this.getGraphic(devId).addSetLine(io.readInt(), io.readFloat(), io.readByte(), io.readByte(), io.readFloat());
                    return;
                }
                case 5: {
                    this.getGraphic(devId).addSetFont(io.readString(), io.readInt(), io.readFloat(), io.readFloat());
                    return;
                }
                case 17: {
                    this.getGraphic(devId).addDrawLine(io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble());
                    return;
                }
                case 18: {
                    this.getGraphic(devId).addDrawRect(io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble());
                    return;
                }
                case 19: {
                    this.getGraphic(devId).addDrawPolyline(io.readDoubleArray(), io.readDoubleArray2());
                    return;
                }
                case 20: {
                    this.getGraphic(devId).addDrawPolygon(io.readDoubleArray(), io.readDoubleArray2());
                    return;
                }
                case 21: {
                    this.getGraphic(devId).addDrawPath(io.readIntArray(), io.readDoubleArray(), io.readDoubleArray2(), io.readInt());
                    return;
                }
                case 22: {
                    this.getGraphic(devId).addDrawCircle(io.readDouble(), io.readDouble(), io.readDouble());
                    return;
                }
                case 23: {
                    this.getGraphic(devId).addDrawText(io.readString(), io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble());
                    return;
                }
                case 24: {
                    this.getGraphic(devId).addDrawRaster(io.readByteArray(), io.readBoolean(), io.readInt(), io.readInt(), io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble(), io.readDouble(), io.readBoolean());
                    return;
                }
                case 28: {
                    byte by = io.readByte();
                    requestId = by;
                    this.addC2SCmd((MainCmdItem)new GDCmdItem.Answer(by, devId, this.getGraphic(devId).capture(io.readInt(), io.readInt())));
                    return;
                }
                case 49: {
                    byte by = io.readByte();
                    requestId = by;
                    final byte fid = by;
                    this.processCmdDeferred(new Runnable(){

                        @Override
                        public void run() {
                            AbstractRJComClient.this.addC2SCmd((MainCmdItem)new GDCmdItem.DoubleAnswer(fid, devId, AbstractRJComClient.this.getGraphic(devId).runRLocator(AbstractRJComClient.this.rService, AbstractRJComClient.this.progressMonitor)));
                        }
                    });
                    return;
                }
            }
            if ((options & Integer.MIN_VALUE) != 0) {
                requestId = io.readByte();
            }
            throw new UnsupportedOperationException("Unknown GD command.");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when processing graphic command.", e));
            if (requestId >= 0) {
                this.addC2SCmd((MainCmdItem)new GDCmdItem.Answer(requestId, devId, new RjsStatus(4, 0)));
            }
            return;
        }
    }

    private final void processMainCtrlCmd(RJIO io) throws IOException {
        try {
            MainCtrlCmdItem item = new MainCtrlCmdItem(io);
            this.addDataAnswer((MainCmdItem)item);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when processing control command answer.", (Throwable)e));
        }
    }

    private final void processDataCmd(RJIO io) throws IOException {
        try {
            DataCmdItem item = new DataCmdItem(io);
            this.addDataAnswer((MainCmdItem)item);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when processing data command answer.", (Throwable)e));
        }
    }

    private final void processGraphicsOpCmd(RJIO io) throws IOException {
        try {
            GraOpCmdItem item = new GraOpCmdItem(io);
            this.addDataAnswer((MainCmdItem)item);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when processing graphic operation answer.", (Throwable)e));
        }
    }

    private final int newDataLevel() {
        int level;
        ++this.dataLevelRequest;
        if ((level = this.dataLevelRequest--) >= this.dataAnswer.length) {
            throw new UnsupportedOperationException("too much nested operations");
        }
        this.dataLevelAnswer = 0;
        return level;
    }

    private final MainCmdItem createDataRequestId(int level, MainCmdItem item) {
        this.dataRequestCounter = (byte)(this.dataRequestCounter + 1);
        this.dataRequestId[level] = (0xFF & item.getCmdType()) << 24 | (0xFF & item.getOp()) << 16 | 0xFF & this.randomId << 8 | 0xFF & this.dataRequestCounter;
        item.requestId = (0xFF & level) << 24 | 0xFFFFFF & this.dataRequestId[level];
        return item;
    }

    private final void addDataAnswer(MainCmdItem item) throws RjException {
        int level = (0xFF000000 & item.requestId) >>> 24;
        if (level > 0 && level <= this.dataLevelRequest && this.dataRequestId[level] == ((0xFF & item.getCmdType()) << 24 | 0xFFFFFF & item.requestId)) {
            this.dataAnswer[level] = item;
            this.dataLevelAnswer = level;
            return;
        }
        if ((item.requestId & 0xFF) != (this.randomId & 0xFF)) {
            return;
        }
        throw new RjException("Unexpected server answer: " + String.valueOf(item));
    }

    private final void finalizeDataLevel() {
        int level = this.dataLevelRequest--;
        this.dataAnswer[level] = null;
        this.dataLevelAnswer = this.dataAnswer[this.dataLevelRequest] != null ? this.dataLevelRequest : 0;
        this.runFinishTask = true;
    }

    public final int getDataLevel() {
        return this.dataLevelRequest;
    }

    protected final void processDbgCmd(RJIO io) throws IOException {
        DbgCmdItem item = new DbgCmdItem(io);
        if (item.getOp() > 32) {
            this.handleDbgEvents(item.getOp(), item.getData());
        } else if (this.dbgOpRequest) {
            this.dbgOpAnswer = item;
        }
    }

    protected void handleDbgEvents(byte dbgOp, Object events) {
    }

    protected abstract void log(Status var1);

    protected abstract void handleServerStatus(RjsStatus var1, ProgressMonitor var2) throws StatusException;

    protected abstract void handleStatus(Status var1, ProgressMonitor var2);

    protected void scheduleConnectionCheck() {
    }

    public final boolean runAsyncPing() {
        block5: {
            block6: {
                RjsComObject answer = this.rjConsoleEngine.runAsync((RjsComObject)RjsPing.INSTANCE);
                if (!(answer instanceof RjsStatus)) break block5;
                RjsStatus status = (RjsStatus)answer;
                if (status.getSeverity() != 0) break block6;
                return true;
            }
            try {
                this.scheduleConnectionCheck();
            }
            catch (ConnectException e) {
                this.scheduleConnectionCheck();
            }
            catch (RemoteException remoteException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final boolean runAsyncInterrupt() {
        Callable<Boolean>[] handlers = this.getCancelHandlers();
        int i = handlers.length - 1;
        while (i >= 0) {
            try {
                Boolean done = handlers[i].call();
                if (done != null && done.booleanValue()) {
                    return false;
                }
            }
            catch (Exception done) {
                // empty catch block
            }
            --i;
        }
        ProgressMonitor monitor = this.progressMonitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        try {
            this.runAsyncCtrl(1);
            return true;
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() != 8) {
                this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when trying to interrupt R.", (Throwable)e));
            }
            return false;
        }
    }

    public final void runAsyncCtrl(int id) throws StatusException {
        RjsStatus status = (RjsStatus)this.runAsync((RjsComObject)new CtrlCmdItem(id));
        if (status.getSeverity() != 0) {
            throw new StatusException(Status.newStatus((int)status.getSeverity(), (String)RJ_CLIENT_ID, (String)String.format("Executing CTRL command failed with code= 0x%1$08X.", status.getCode())));
        }
    }

    public final RjsComObject runAsync(RjsComObject com) throws StatusException {
        if (this.closed) {
            throw new StatusException((Status)new ErrorStatus(RJ_CLIENT_ID, this.closedMessage));
        }
        try {
            return this.rjConsoleEngine.runAsync(com);
        }
        catch (Exception e) {
            throw new StatusException((Status)new ErrorStatus(RJ_CLIENT_ID, "Communication error.", (Throwable)e));
        }
    }

    public final void runMainLoopPing(ProgressMonitor m) throws StatusException {
        try {
            this.mainRunGC = false;
            RjsStatus status = (RjsStatus)this.rjConsoleEngine.runMainLoop((RjsComObject)RjsPing.INSTANCE);
            if (status.getSeverity() == 0) {
                return;
            }
            this.handleServerStatus(status, m);
        }
        catch (ConnectException e) {
            this.handleServerStatus(new RjsStatus(1, 24), m);
        }
        catch (Exception e) {
            this.handleServerStatus(new RjsStatus(1, 25), m);
        }
    }

    /*
     * Exception decompiling
     */
    public final void runMainLoop(RjsComObject sendCom, MainCmdItem sendItem, ProgressMonitor m) throws StatusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 30[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void addC2SCmd(MainCmdItem item) {
        if (this.mainC2SFirst == null) {
            this.mainC2SFirst = item;
        } else {
            item.next = this.mainC2SFirst;
            this.mainC2SFirst = item;
            this.log((Status)new InfoStatus(RJ_CLIENT_ID, "Multiple C2S items:\\" + this.mainC2SFirst.toString() + "\n" + this.mainC2SFirst.next.toString()));
        }
    }

    private final MainCmdItem getC2SCmds() {
        MainCmdItem item = this.mainC2SFirst;
        this.mainC2SFirst = null;
        return item;
    }

    private final void processStatus(RjsStatus status, ProgressMonitor m) throws StatusException {
        if ((status.getCode() & 0xFFFFFF00) == 0) {
            this.handleServerStatus(status, m);
            return;
        }
        status.getSeverity();
    }

    private final void processPrompt(ConsoleReadCmdItem item) {
        switch (item.getOp()) {
            case 2: {
                if (this.hotModeState < 2) {
                    this.hotModeState = 2;
                    this.hotModeReadCallbackBackup = this.consoleReadCallback;
                    this.hotModeC2SFirstBackup = this.mainC2SFirst;
                    this.mainC2SFirst = null;
                }
                this.consoleReadCallback = item;
                return;
            }
            case 1: {
                this.consoleReadCallback = item;
                this.updatePrompt(item.getDataText(), true);
                return;
            }
        }
        this.consoleReadCallback = item;
        this.updatePrompt(item.getDataText(), false);
    }

    public void requestHotMode(boolean async) {
        this.hotModeRequested.set(true);
        if (async) {
            RJHelper_EXECUTOR.schedule(this.hotModeRunnable, 100L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean startHotMode() {
        if (this.hotModeState == 0) {
            this.hotModeRequested.set(false);
            boolean savedCallbackRequired = this.consoleReadCallbackRequired;
            this.consoleReadCallbackRequired = false;
            try {
                this.hotModeState = 1;
                this.runMainLoop((RjsComObject)new CtrlCmdItem(2), null, (ProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (Throwable e) {
                this.hotModeState = 0;
                this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when running hot mode.", e));
            }
            finally {
                this.consoleReadCallbackRequired = savedCallbackRequired;
            }
        }
        return false;
    }

    public void requestExtraMode(int positions) {
        this.extraModeRequested = positions;
    }

    protected void updateBusy(boolean isBusy) {
    }

    protected void updatePrompt(String text, boolean addToHistory) {
    }

    protected void writeConsoleOutput(byte streamId, String text) {
    }

    protected void showMessage(String text) {
    }

    protected void processHotMode() {
    }

    protected void processExtraMode(int i) {
    }

    private void addGraphic(int devId, double w, double h, int canvasColor, boolean activate) throws RjException {
        if (devId >= 0) {
            if (devId >= this.graphics.length) {
                RClientGraphic[] newArray = new RClientGraphic[devId + 10];
                System.arraycopy(this.graphics, 0, newArray, 0, this.graphics.length);
                this.graphics = newArray;
            }
            RClientGraphic.InitConfig config = new RClientGraphic.InitConfig();
            config.canvasColor = canvasColor;
            if (this.graphics[devId] != null) {
                this.graphics[devId].reset(w, h, config);
                this.graphics[devId].setActive(activate);
            } else {
                this.graphics[devId] = this.lastGraphic = this.graphicFactory.newGraphic(devId, w, h, config, activate, this.graphicActions, this.currentGraphicOptions);
            }
            return;
        }
        throw new RjException("Invalid GD devId: " + devId);
    }

    private void removeGraphic(int devId) {
        if (devId >= 0 && devId < this.graphics.length && this.graphics[devId] != null) {
            try {
                this.graphicFactory.closeGraphic(this.graphics[devId]);
            }
            catch (Exception e) {
                this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occurred when closing R graphic (Device " + (devId + 1) + ").", (Throwable)e));
            }
            this.graphics[devId] = null;
        }
    }

    protected RClientGraphic getGraphic(int devId) {
        RClientGraphic graphic;
        if (devId >= 0 && devId < this.graphics.length && (graphic = this.graphics[devId]) != null) {
            return graphic;
        }
        return this.graphicDummy;
    }

    public void disposeAllGraphics() {
        int devId = 0;
        while (devId < this.graphics.length) {
            this.removeGraphic(devId);
            ++devId;
        }
    }

    public final void activateConsole() {
        if (this.rjConsoleEngine == null) {
            throw new IllegalStateException("Missing REngine");
        }
        this.consoleReadCallbackRequired = true;
    }

    public final void answerConsole(String input, ProgressMonitor m) throws StatusException {
        this.consoleReadCallback.setAnswer(input);
        this.runMainLoop(null, (MainCmdItem)this.consoleReadCallback, m);
        this.runFinishTask = false;
    }

    public final boolean isConsoleReady() {
        return this.consoleReadCallback != null;
    }

    private Map<String, Object> getServerData() throws RemoteException {
        if (this.platformData != null) {
            return this.platformData;
        }
        Map data = this.rjConsoleEngine.getPlatformData();
        if (data != null && data.containsKey("version.string")) {
            this.platformData = data;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RPlatform getRPlatform() {
        Object object = this.platformLock;
        synchronized (object) {
            if (this.platformObj == null) {
                try {
                    Map<String, Object> data = this.getServerData();
                    if (data != null && data.containsKey("version.string")) {
                        this.platformObj = new RPlatform((String)this.platformData.get("os.type"), (String)this.platformData.get("file.sep"), (String)this.platformData.get("path.sep"), (String)this.platformData.get("version.string"), (String)this.platformData.get("os.name"), (String)this.platformData.get("os.arch"), (String)this.platformData.get("os.version"));
                    }
                }
                catch (RemoteException e) {
                    this.log((Status)new ErrorStatus(RJ_CLIENT_ID, "An error occured when loading data for RPlatform information.", (Throwable)e));
                }
            }
            return this.platformObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getProperty(String key) {
        Object object = this.platformLock;
        synchronized (object) {
            try {
                Map<String, Object> data = this.getServerData();
                if (data != null) {
                    Object value = data.get(key);
                    String string = value instanceof String ? (String)value : null;
                    return string;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return null;
        }
    }

    public final void finishTask(ProgressMonitor m) throws StatusException {
        if (!this.runFinishTask) {
            return;
        }
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new MainCtrlCmdItem(2, 0)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            return;
        }
        finally {
            this.finalizeDataLevel();
            this.runFinishTask = false;
        }
    }

    public boolean isValidEnvRef(RObject envir) {
        switch (envir.getRObjectType()) {
            case 14: {
                return ((RReference)envir).getReferencedRObjectType() == 8;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    public final void evalVoid(String expression, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.EVAL_EXPR_VOID, 0, expression, null, null, envir)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            return;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public final void evalVoid(String name, RList args, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.EVAL_FCALL_VOID, 0, name, (RObject)args, null, envir)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            return;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public RObject evalData(String expression, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int checkedDepth = depth < 127 ? (int)depth : 127;
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.EVAL_EXPR_DATA, options, (byte)checkedDepth, expression, null, null, envir, factoryId)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            RObject rObject = ((DataCmdItem)this.dataAnswer[level]).getData();
            return rObject;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public RObject evalData(String name, RObject args, @Nullable RObject envir, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int checkedDepth = depth < 127 ? (int)depth : 127;
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.EVAL_FCALL_DATA, options, (byte)checkedDepth, name, args, null, envir, factoryId)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            RObject rObject = ((DataCmdItem)this.dataAnswer[level]).getData();
            return rObject;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public final RObject evalData(RReference reference, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        int checkedDepth = depth < 127 ? (int)depth : 127;
        int level = this.newDataLevel();
        try {
            long handle = reference.getHandle();
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.RESOLVE_DATA, options, (byte)checkedDepth, Long.toString(handle), null, null, null, factoryId)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            RObject rObject = ((DataCmdItem)this.dataAnswer[level]).getData();
            return rObject;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    private StatusException toStatusException(RjsStatus status, String message) {
        return new StatusException(status.getSeverity() == 8 ? Status.CANCEL_STATUS : Status.newStatus((int)status.getSeverity(), (String)RJ_CLIENT_ID, (int)status.getCode(), (String)String.format(message, status.getMessage()), null));
    }

    public RObject evalData(byte envType, String name, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        DataCmdItem.Operation operation = switch (envType) {
            case 11 -> DataCmdItem.EVAL_NAMESPACE_DATA;
            case 12 -> DataCmdItem.EVAL_NAMESPACE_EXPORTS_DATA;
            default -> throw new IllegalArgumentException("envType= " + envType);
        };
        int checkedDepth = depth < 127 ? (int)depth : 127;
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(operation, options, (byte)checkedDepth, name, null, null, null, factoryId)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            RObject rObject = ((DataCmdItem)this.dataAnswer[level]).getData();
            return rObject;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public final void assignData(String expression, RObject data, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.ASSIGN_DATA, 0, null, data, expression, envir)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Assignment failed: %1$s");
            }
            return;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public final void assignData(String name, RObject args, String expression, @Nullable RObject envir, ProgressMonitor m) throws StatusException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (envir != null && !this.isValidEnvRef(envir)) {
            throw new IllegalArgumentException("envir");
        }
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.ASSIGN_FCALL, 0, name, args, expression, envir)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Assignment failed: %1$s");
            }
            return;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public RObject[] findData(String symbol, RObject env, boolean inherits, @Nullable String factoryId, int options, int depth, ProgressMonitor m) throws StatusException {
        if (symbol == null) {
            throw new NullPointerException("symbol");
        }
        int checkedDepth = depth < 127 ? (int)depth : 127;
        int level = this.newDataLevel();
        try {
            RObject[] rObjectArray;
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new DataCmdItem(DataCmdItem.FIND_DATA, inherits ? options | 0x1000 : options, (byte)checkedDepth, symbol, null, null, env, factoryId)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Evaluation failed: %1$s");
            }
            DataCmdItem dataItem = (DataCmdItem)this.dataAnswer[level];
            if (dataItem.getRho() != null) {
                RObject[] rObjectArray2 = new RObject[2];
                rObjectArray2[0] = dataItem.getData();
                rObjectArray = rObjectArray2;
                rObjectArray2[1] = dataItem.getRho();
            } else {
                rObjectArray = null;
            }
            RObject[] rObjectArray3 = rObjectArray;
            return rObjectArray3;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public void downloadFile(OutputStream out, String fileName, int options, ProgressMonitor m) throws StatusException {
        BinExchange answer;
        BinExchange request = new BinExchange(out, fileName, (Remote)this.rjConsoleEngine, options);
        try {
            answer = (BinExchange)this.runAsync((RjsComObject)request);
        }
        finally {
            request.clear();
        }
        if (answer == null || !answer.isOK()) {
            RjsStatus status = answer != null ? answer.getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
            throw this.toStatusException(status, "Downloading file failed: %1$s");
        }
    }

    public byte[] downloadFile(String fileName, int options, ProgressMonitor m) throws StatusException {
        BinExchange answer;
        BinExchange request = new BinExchange(fileName, (Remote)this.rjConsoleEngine, options);
        try {
            answer = (BinExchange)this.runAsync((RjsComObject)request);
        }
        finally {
            request.clear();
        }
        if (answer == null || !answer.isOK()) {
            RjsStatus status = answer != null ? answer.getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
            throw this.toStatusException(status, "Downloading file failed: %1$s");
        }
        return answer.getBytes();
    }

    public void uploadFile(InputStream in, long length, String fileName, int options, ProgressMonitor m) throws StatusException {
        BinExchange answer;
        BinExchange request = new BinExchange(in, length, fileName, (Remote)this.rjConsoleEngine, options);
        try {
            answer = (BinExchange)this.runAsync((RjsComObject)request);
        }
        finally {
            request.clear();
        }
        if (answer == null || !answer.isOK()) {
            RjsStatus status = answer != null ? answer.getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
            throw this.toStatusException(status, "Uploading file failed: %1$s");
        }
    }

    public Object execSyncDbgOp(byte dbgOp, RJIOExternalizable request, ProgressMonitor m) throws StatusException {
        if (this.dbgOpRequest) {
            throw new IllegalStateException();
        }
        this.dbgOpRequest = true;
        try {
            CtrlReport report;
            this.runMainLoop(null, (MainCmdItem)new DbgCmdItem(dbgOp, 0, request), m);
            if (this.dbgOpAnswer == null || !this.dbgOpAnswer.isOK()) {
                RjsStatus status = this.dbgOpAnswer != null ? this.dbgOpAnswer.getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Dbg operation failed: %1$s");
            }
            Object data = this.dbgOpAnswer.getData();
            if (data instanceof CtrlReport && !(report = (CtrlReport)data).isEngineSuspended()) {
                this.consoleReadCallback = null;
            }
            Object object = data;
            return object;
        }
        finally {
            this.dbgOpRequest = false;
            this.dbgOpAnswer = null;
        }
    }

    public void execAsyncDbgOp(final byte op, final RJIOExternalizable request) throws StatusException {
        this.execAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractRJComClient.this.runAsync((RjsComObject)new DbgCmdItem(op, 0, request));
                }
                catch (StatusException e) {
                    AbstractRJComClient.this.log((Status)new ErrorStatus(AbstractRJComClient.RJ_CLIENT_ID, "An error occurred when executing background dbg operation.", (Throwable)e));
                }
            }
        });
    }

    public int getGraphicOptions() {
        return this.currentGraphicOptions;
    }

    public void setGraphicOptions(int options) {
        this.currentGraphicOptions = options;
        this.lastGraphic = null;
    }

    public RClientGraphic getLastGraphic() {
        return this.lastGraphic;
    }

    public Object execSyncGraphicOp(int devId, byte op, ProgressMonitor m) throws StatusException {
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new GraOpCmdItem(devId, op)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "Graphics operation failed: %1$s");
            }
            Object object = ((GraOpCmdItem)this.dataAnswer[level]).getData();
            return object;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    public Object execSyncGraphicOp(int devId, byte op, RJIOExternalizable data, ProgressMonitor m) throws StatusException {
        int level = this.newDataLevel();
        try {
            this.runMainLoop(null, this.createDataRequestId(level, (MainCmdItem)new GraOpCmdItem(devId, op, data)), m);
            if (this.dataAnswer[level] == null || !this.dataAnswer[level].isOK()) {
                RjsStatus status = this.dataAnswer[level] != null ? this.dataAnswer[level].getStatus() : ServerUtils.MISSING_ANSWER_STATUS;
                throw this.toStatusException(status, "\"Graphics operation failed: %1$s");
            }
            Object object = ((GraOpCmdItem)this.dataAnswer[level]).getData();
            return object;
        }
        finally {
            this.finalizeDataLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelHandler(Callable<Boolean> handler) {
        List<Callable<Boolean>> list = this.cancelHandler;
        synchronized (list) {
            this.cancelHandler.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancelHandler(Callable<Boolean> handler) {
        List<Callable<Boolean>> list = this.cancelHandler;
        synchronized (list) {
            int idx = this.cancelHandler.lastIndexOf(handler);
            if (idx >= 0) {
                this.cancelHandler.remove(idx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Callable<Boolean>[] getCancelHandlers() {
        List<Callable<Boolean>> list = this.cancelHandler;
        synchronized (list) {
            return this.cancelHandler.toArray(new Callable[this.cancelHandler.size()]);
        }
    }

    public Lock getWaitLock() {
        return this.clientWaitLock;
    }

    public void waitingForUser() {
        if (this.hotModeRequested.get()) {
            this.clientWaitLock.unlock();
            try {
                this.startHotMode();
            }
            finally {
                this.clientWaitLock.lock();
            }
            return;
        }
        try {
            this.clientWaitCondition.awaitNanos(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resume() {
        this.clientWaitCondition.signal();
    }

    private class HotModeRequestRunnable
    implements Runnable {
        private HotModeRequestRunnable() {
        }

        @Override
        public void run() {
            block3: {
                if (AbstractRJComClient.this.hotModeRequested.get()) {
                    try {
                        AbstractRJComClient.this.runAsyncCtrl(2);
                    }
                    catch (StatusException e) {
                        if (e.getStatus().getSeverity() == 8) break block3;
                        AbstractRJComClient.this.log((Status)new ErrorStatus(AbstractRJComClient.RJ_CLIENT_ID, "An error occurred when requesting hot mode.", (Throwable)e));
                    }
                }
            }
        }
    }

    private class KeepAliveRunnable
    implements Runnable {
        private KeepAliveRunnable() {
        }

        @Override
        public void run() {
            AbstractRJComClient.this.runAsyncPing();
        }
    }

    private static final class RunnableList {
        private Runnable[] array = new Runnable[4];
        private int size = 0;

        public void add(Runnable value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            int oldCapacity = this.array.length;
            if (this.size < oldCapacity) {
                this.array[this.size++] = value;
                return;
            }
            Runnable[] newArray = new Runnable[oldCapacity + 4];
            System.arraycopy(this.array, 0, newArray, 0, oldCapacity);
            newArray[this.size++] = value;
            this.array = newArray;
        }

        public boolean isNotEmpty() {
            return this.size != 0;
        }

        public Runnable[] consume() {
            Runnable[] oldListeners = this.array;
            this.size = 0;
            this.array = new Runnable[4];
            return oldListeners;
        }
    }
}

