/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.string.BasicStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.util.Version;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.r.core.source.RLexer;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.RSourceConstants;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CLoopCommand;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.Comment;
import org.eclipse.statet.r.core.source.ast.DocuComment;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.ExpressionList;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Group;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NullConst;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Placeholder;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RParserPostExprVisitor;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SingleValue;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
public final class RParser {
    private static final byte LINE_MODE_CONSOLE = 1;
    private static final byte LINE_MODE_BLOCK = 2;
    private static final byte LINE_MODE_EAT = 3;
    public static final int LEXER_CONFIG = 1;
    public static final int COLLECT_COMMENTS = 1;
    public static final int ROXYGEN_COMMENTS = 8;
    static final int LANG_VERSION_4_0 = 0;
    static final int LANG_VERSION_4_1 = 1;
    static final int LANG_VERSION_4_2 = 2;
    static final int LANG_VERSION_4_3 = 3;
    static final int LANG_VERSION_4_4 = 4;
    private final RLexer lexer;
    private final int level;
    private int rLangVersion;
    private TextParserInput parseInput;
    private final RParserPostExprVisitor postVisitor = new RParserPostExprVisitor(this);
    private RTerminal nextType;
    private boolean wasLinebreak;
    private int commentsLevel;
    private final List<RAstNode> comments = new ArrayList<RAstNode>();
    private @Nullable RoxygenCollector roxygen;
    private final boolean createText;
    private final StringFactory symbolTextFactory;
    private final List<ArgsBuilder<?>> argBuilders = new ArrayList(16);
    private int argBuildersIdx;

    private static int toRLangVersionInt(Version version) {
        if (version.compareTo(RSourceConstants.LANG_VERSION_4_4, 2) >= 0) {
            return 4;
        }
        if (version.compareTo(RSourceConstants.LANG_VERSION_4_3, 2) >= 0) {
            return 3;
        }
        if (version.compareTo(RSourceConstants.LANG_VERSION_4_2, 2) >= 0) {
            return 2;
        }
        if (version.compareTo(RSourceConstants.LANG_VERSION_4_1, 2) >= 0) {
            return 1;
        }
        return 0;
    }

    private static Version toRLangVersionObj(int version) {
        return switch (version) {
            case 0 -> RSourceConstants.LANG_VERSION_4_0;
            case 1 -> RSourceConstants.LANG_VERSION_4_1;
            case 2 -> RSourceConstants.LANG_VERSION_4_2;
            case 3 -> RSourceConstants.LANG_VERSION_4_3;
            case 4 -> RSourceConstants.LANG_VERSION_4_4;
            default -> throw new IllegalArgumentException();
        };
    }

    public RParser(RSourceConfig rSourceConfig, int level, RLexer lexer, @Nullable StringFactory symbolTextFactory) {
        this.level = level;
        this.lexer = (RLexer)ObjectUtils.nonNullAssert((Object)lexer);
        this.setRSourceConfig(rSourceConfig);
        this.createText = (level & 0xF) > 1;
        this.symbolTextFactory = symbolTextFactory != null ? symbolTextFactory : BasicStringFactory.INSTANCE;
    }

    public RParser(RSourceConfig rSourceConfig, int level, @Nullable StringFactory symbolTextFactory) {
        this(rSourceConfig, level, new RLexer(level == 1 ? 32785 : 32769), symbolTextFactory);
    }

    public RParser(int level) {
        this(RSourceConfig.DEFAULT_CONFIG, level, null);
    }

    public void setCommentLevel(int level) {
        if ((level & 1) == 0) {
            level = 0;
            this.comments.clear();
        } else {
            level &= 9;
        }
        this.commentsLevel = level;
        if ((this.commentsLevel & 8) != 0 && this.roxygen == null) {
            this.roxygen = new RoxygenCollector();
        }
    }

    int getLangVersion() {
        return this.rLangVersion;
    }

    public Version getRLangVersion() {
        return RParser.toRLangVersionObj(this.rLangVersion);
    }

    public void setRSourceConfig(RSourceConfig config) {
        this.rLangVersion = RParser.toRLangVersionInt(config.getLangVersion());
    }

    public int getAstLevel() {
        return this.level;
    }

    protected final TextParserInput getParseInput() {
        return this.parseInput;
    }

    protected void initInput(TextParserInput input, @Nullable AstNode parent) {
        this.parseInput = (TextParserInput)ObjectUtils.nonNullAssert((Object)input);
    }

    private void clearInput() {
        this.parseInput = null;
    }

    protected void clearData() {
        if (this.commentsLevel != 0) {
            this.comments.clear();
        }
    }

    private void handleParseError(Exception e) {
        CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occured while parsing R source code. Input:\n" + this.parseInput.toString(), (Throwable)e));
        this.clearData();
    }

    public SourceComponent parseSourceUnit(TextParserInput input) {
        this.initInput(input, null);
        try {
            SourceComponent sourceNode;
            this.init();
            SourceComponent sourceComponent = sourceNode = this.scanSourceUnit(null, false);
            return sourceComponent;
        }
        catch (Exception e) {
            this.handleParseError(e);
            SourceComponent sourceComponent = this.createErrorSourceComponent(null);
            return sourceComponent;
        }
        finally {
            this.clearInput();
        }
    }

    public SourceComponent parseSourceFragment(TextParserInput input, @Nullable AstNode parent, boolean expand) {
        this.initInput(input, parent);
        try {
            SourceComponent sourceNode;
            this.init();
            SourceComponent sourceComponent = sourceNode = this.scanSourceUnit(parent, expand);
            return sourceComponent;
        }
        catch (Exception e) {
            this.handleParseError(e);
            SourceComponent sourceComponent = this.createErrorSourceComponent(parent);
            return sourceComponent;
        }
        finally {
            this.clearInput();
        }
    }

    public SourceComponent parseSourceFragment(TextParserInput input, @Nullable AstNode parent) {
        return this.parseSourceFragment(input, parent, false);
    }

    private SourceComponent createErrorSourceComponent(@Nullable AstNode parent) {
        int startOffset = this.parseInput.getStartIndex();
        int endOffset = this.parseInput.getStopIndex();
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        SourceComponent dummy = new SourceComponent(3840, parent, startOffset, endOffset);
        if (this.commentsLevel != 0) {
            dummy.comments = ImCollections.emptyList();
        }
        return dummy;
    }

    public @Nullable RAstNode parseExpr(TextParserInput input) {
        this.initInput(input, null);
        try {
            this.init();
            SourceComponent sourceNode = this.scanSourceUnit(null, false);
            if (sourceNode.getChildCount() == 1) {
                RAstNode rAstNode = sourceNode.getChild(0);
                return rAstNode;
            }
            return null;
        }
        catch (Exception e) {
            this.handleParseError(e);
            return null;
        }
        finally {
            this.clearInput();
        }
    }

    public @Nullable FDef parseFDef(TextParserInput input) {
        this.initInput(input, null);
        try {
            this.init();
            FDef fDef = switch (this.nextType) {
                case RTerminal.FUNCTION, RTerminal.FUNCTION_B -> this.scanFDef(null);
                default -> null;
            };
            return fDef;
        }
        catch (Exception e) {
            this.handleParseError(e);
            return null;
        }
        finally {
            this.clearInput();
        }
    }

    public @Nullable FCall.Args parseFCallArgs(TextParserInput input, boolean expand) {
        this.initInput(input, null);
        try {
            this.init();
            FCall callNode = new FCall();
            callNode.setEndOffset(Integer.MIN_VALUE);
            this.scanInSpecArgs(callNode.args);
            if (expand) {
                callNode.args.setStartEndOffset(input.getStartIndex(), input.getIndex());
            }
            FCall.Args args = callNode.args;
            return args;
        }
        catch (Exception e) {
            this.handleParseError(e);
            return null;
        }
        finally {
            this.clearInput();
        }
    }

    private void init() {
        this.lexer.reset(this.parseInput);
        this.clearData();
        this.clearArgsBuilder();
        if (this.commentsLevel != 0 && (this.commentsLevel & 8) != 0) {
            this.roxygen.init();
        }
        this.nextType = RTerminal.LINEBREAK;
        this.consumeToken();
    }

    final SourceComponent scanSourceUnit(@Nullable AstNode parent, boolean expand) {
        SourceComponent node = new SourceComponent(parent);
        this.scanInExprList(node, true);
        if (this.commentsLevel != 0) {
            node.comments = ImCollections.toList(this.comments);
        }
        if (expand) {
            node.setStartEndOffset(this.lexer.getInput().getStartIndex(), this.lexer.getInput().getStopIndex());
        } else if (node.getChildCount() > 0) {
            node.setStartEndOffset(node.getChild(0).getStartOffset(), node.getChild(node.getChildCount() - 1).getEndOffset());
        } else {
            node.setStartEndOffset(this.lexer.getInput().getStartIndex());
        }
        return node;
    }

    final void scanInExprList(ExpressionList node, boolean script) {
        block9: while (true) {
            switch (this.nextType) {
                case EOF: {
                    break block9;
                }
                case LINEBREAK: {
                    this.consumeToken();
                    continue block9;
                }
                default: {
                    Expression expr = node.appendNewExpr();
                    ExprContext context = new ExprContext(node, expr, script ? (byte)1 : 2);
                    this.scanInExpression(context);
                    if (expr.node == null) {
                        node.expressions.remove(context.rootExpr);
                        expr = null;
                    } else {
                        this.checkExpression(context);
                    }
                    switch (this.nextType) {
                        case SEMICOLON: {
                            if (expr != null) {
                                node.setSeparator(this.lexer.getOffset());
                                this.consumeToken();
                                continue block9;
                            }
                        }
                        case COMMA: {
                            expr = node.appendNewExpr();
                            expr.node = this.errorFromNext(node);
                            continue block9;
                        }
                        case BLOCK_CLOSE: 
                        case GROUP_CLOSE: 
                        case SUB_INDEXED_CLOSE: {
                            if (!script) break block9;
                            expr = node.appendNewExpr();
                            expr.node = this.errorFromNext(node);
                        }
                        default: {
                            continue block9;
                        }
                    }
                }
            }
            break;
        }
    }

    final int scanInGroup(RAstNode node, Expression expr) {
        ExprContext context = new ExprContext(node, expr, 3);
        this.scanInExpression(context);
        return this.checkExpression(context);
    }

    final void scanInExpression(ExprContext context) {
        this.wasLinebreak = false;
        block37: while (!this.wasLinebreak || context.lineMode >= 3 || context.openExpr != null) {
            switch (this.nextType) {
                case LINEBREAK: {
                    if (context.lineMode < 3 && context.openExpr == null) break block37;
                    this.consumeToken();
                    continue block37;
                }
                case SYMBOL: 
                case SYMBOL_G: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createSymbol(null));
                    continue block37;
                }
                case PIPE_PLACEHOLDER: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    RAstNode node = new Placeholder.PipeIn();
                    this.setupFromSourceToken(node);
                    if (this.rLangVersion < 2) {
                        node.setStatus(4228880);
                    } else {
                        node.setStatus(4227488);
                    }
                    this.appendNonOp(context, node);
                    this.consumeToken();
                    continue block37;
                }
                case NUM_INT: 
                case NUM_NUM: 
                case NUM_CPLX: 
                case TRUE: 
                case FALSE: 
                case NA: 
                case NA_INT: 
                case NA_REAL: 
                case NA_CPLX: 
                case NA_CHAR: 
                case NAN: 
                case INF: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createNumberConst(null));
                    continue block37;
                }
                case NULL: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createNullConst(null));
                    continue block37;
                }
                case STRING_D: 
                case STRING_S: 
                case STRING_R: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createStringConst(null));
                    continue block37;
                }
                case ARROW_LEFT_S: 
                case ARROW_LEFT_D: 
                case ARROW_RIGHT_S: 
                case ARROW_RIGHT_D: 
                case EQUAL: 
                case COLON_EQUAL: {
                    this.appendOp(context, this.createAssignment());
                    continue block37;
                }
                case PIPE_RIGHT: {
                    RAstNode node = new Pipe.Forward();
                    this.setupFromSourceToken(node);
                    if (this.rLangVersion < 1) {
                        node.setStatus(4228880);
                    }
                    this.consumeToken();
                    this.appendOp(context, node);
                    continue block37;
                }
                case TILDE: {
                    if (context.openExpr != null) {
                        this.appendNonOp(context, this.createModel());
                        continue block37;
                    }
                    this.appendOp(context, this.createModel());
                    continue block37;
                }
                case PLUS: 
                case MINUS: {
                    if (context.openExpr != null) {
                        this.appendNonOp(context, this.createSign());
                        continue block37;
                    }
                    this.appendOp(context, this.createArithmetic());
                    continue block37;
                }
                case MULT: 
                case DIV: {
                    this.appendOp(context, this.createArithmetic());
                    continue block37;
                }
                case POWER: {
                    this.appendOp(context, this.createPower());
                    continue block37;
                }
                case SEQ: {
                    this.appendOp(context, this.createSeq());
                    continue block37;
                }
                case SPECIAL: {
                    this.appendOp(context, this.createSpecial());
                    continue block37;
                }
                case REL_NE: 
                case REL_EQ: 
                case REL_LT: 
                case REL_LE: 
                case REL_GT: 
                case REL_GE: {
                    this.appendOp(context, this.createRelational());
                    continue block37;
                }
                case OR: 
                case OR_D: 
                case AND: 
                case AND_D: {
                    this.appendOp(context, this.createLogical());
                    continue block37;
                }
                case NOT: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createSign());
                    continue block37;
                }
                case IF: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanCIf(context));
                    continue block37;
                }
                case ELSE: {
                    if (context.rootNode.getNodeType() == NodeType.C_IF || this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanCElse(context));
                    continue block37;
                }
                case FOR: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanCForLoop(context));
                    continue block37;
                }
                case REPEAT: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanCRepeatLoop(context));
                    continue block37;
                }
                case WHILE: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanCWhileLoop(context));
                    continue block37;
                }
                case BREAK: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createLoopCommand());
                    continue block37;
                }
                case NEXT: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.createLoopCommand());
                    continue block37;
                }
                case FUNCTION: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanFDef(context));
                    continue block37;
                }
                case FUNCTION_B: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanFDef(context));
                    continue block37;
                }
                case GROUP_OPEN: {
                    if (context.openExpr != null) {
                        this.appendNonOp(context, this.scanGroup());
                        continue block37;
                    }
                    this.appendOp(context, this.scanFCall());
                    continue block37;
                }
                case BLOCK_OPEN: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanBlock());
                    continue block37;
                }
                case EOF: {
                    break block37;
                }
                case NS_GET: 
                case NS_GET_INT: {
                    if (this.wasLinebreak && context.openExpr == null) break block37;
                    this.appendNonOp(context, this.scanNSGet(context));
                    continue block37;
                }
                case SUB_INDEXED_S_OPEN: 
                case SUB_INDEXED_D_OPEN: {
                    this.appendOp(context, this.scanSubIndexed(context));
                    continue block37;
                }
                case SUB_NAMED_PART: 
                case SUB_NAMED_SLOT: {
                    this.appendOp(context, this.scanSubNamed(context));
                    continue block37;
                }
                case QUESTIONMARK: {
                    if (context.openExpr != null) {
                        this.appendNonOp(context, this.createHelp());
                        continue block37;
                    }
                    this.appendOp(context, this.createHelp());
                    continue block37;
                }
                case UNKNOWN: 
                case IN: {
                    this.appendNonOp(context, this.errorFromNext(null));
                    continue block37;
                }
                case BLOCK_CLOSE: 
                case GROUP_CLOSE: 
                case SUB_INDEXED_CLOSE: 
                case COMMA: 
                case SEMICOLON: {
                    break block37;
                }
                default: {
                    throw new IllegalStateException("Unhandled token in expr-scanner: " + this.nextType.name());
                }
            }
        }
    }

    final Group scanGroup() {
        Group node = new Group();
        this.setupFromSourceToken(node);
        this.consumeToken();
        this.scanInGroup(node, node.expr);
        if (this.nextType == RTerminal.GROUP_CLOSE) {
            node.groupCloseOffset = this.lexer.getOffset();
            node.setEndOffset(node.groupCloseOffset + 1);
            this.consumeToken();
            return node;
        }
        node.setStatus(4195600);
        node.setEndOffset(this.lexer.getOffset());
        return node;
    }

    final Block scanBlock() {
        Block node = new Block();
        this.setupFromSourceToken(node);
        this.consumeToken();
        this.scanInExprList(node, false);
        if (this.nextType == RTerminal.BLOCK_CLOSE) {
            node.blockCloseOffset = this.lexer.getOffset();
            node.setEndOffset(node.blockCloseOffset + 1);
            this.consumeToken();
            return node;
        }
        node.setStatus(4195600);
        node.setEndOffset(this.lexer.getOffset());
        return node;
    }

    final NSGet scanNSGet(ExprContext context) {
        NSGet node = switch (this.nextType) {
            case RTerminal.NS_GET -> new NSGet.Std();
            case RTerminal.NS_GET_INT -> new NSGet.Internal();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        node.operatorOffset = this.lexer.getOffset();
        this.consumeToken();
        switch (context.lastNode.getNodeType()) {
            case SYMBOL: 
            case STRING_CONST: {
                node.namespace = (SingleValue)context.lastNode;
                RAstNode base = context.lastNode.rParent;
                node.namespace.rParent = node;
                Expression expr = base.getExpr(node.namespace);
                if (expr == null) {
                    throw new IllegalStateException();
                }
                expr.node = null;
                context.update(base, expr);
                node.setStartOffset(node.namespace.getStartOffset());
                break;
            }
            default: {
                node.namespace = this.errorNonExistingSymbol(node, node.getStartOffset(), 4195104);
            }
        }
        switch (this.nextType) {
            case STRING_D: 
            case STRING_S: 
            case STRING_R: {
                node.element = this.createStringConst(node);
                node.setEndOffset(node.element.getEndOffset());
                return node;
            }
            case SYMBOL: 
            case SYMBOL_G: {
                node.element = this.createSymbol(node);
                node.setEndOffset(node.element.getEndOffset());
                return node;
            }
        }
        node.element = this.errorNonExistingSymbol(node, node.getEndOffset(), 4195104);
        return node;
    }

    final SubNamed scanSubNamed(ExprContext context) {
        SubNamed node = switch (this.nextType) {
            case RTerminal.SUB_NAMED_PART -> new SubNamed.Named();
            case RTerminal.SUB_NAMED_SLOT -> new SubNamed.Slot();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        node.operatorOffset = this.lexer.getOffset();
        this.consumeToken();
        this.readLines();
        switch (this.nextType) {
            case STRING_D: 
            case STRING_S: 
            case STRING_R: {
                node.subname = this.createStringConst(node);
                node.setEndOffset(node.subname.getEndOffset());
                return node;
            }
            case SYMBOL: 
            case SYMBOL_G: {
                node.subname = this.createSymbol(node);
                node.setEndOffset(node.subname.getEndOffset());
                return node;
            }
        }
        node.subname = this.errorNonExistingSymbol(node, node.getEndOffset(), 4195104);
        return node;
    }

    final SubIndexed scanSubIndexed(ExprContext context) {
        SubIndexed node = switch (this.nextType) {
            case RTerminal.SUB_INDEXED_S_OPEN -> new SubIndexed.S();
            case RTerminal.SUB_INDEXED_D_OPEN -> new SubIndexed.D();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        node.openOffset = this.lexer.getOffset();
        this.consumeToken();
        this.readLines();
        this.scanInSpecArgs(node.sublist);
        RParserPostExprVisitor.updateParentStatus(node.sublist);
        if (this.nextType == RTerminal.SUB_INDEXED_CLOSE) {
            node.closeOffset = this.lexer.getOffset();
            this.consumeToken();
            if (node.getNodeType() == NodeType.SUB_INDEXED_D) {
                if (this.nextType == RTerminal.SUB_INDEXED_CLOSE) {
                    node.close2Offset = this.lexer.getOffset();
                    node.setEndOffset(node.close2Offset + 1);
                    this.consumeToken();
                    return node;
                }
                node.setStatus(0x400410);
                node.setEndOffset(node.closeOffset + 1);
                return node;
            }
            node.setEndOffset(node.closeOffset + 1);
            return node;
        }
        node.setStatus(0x400410);
        node.setEndOffset(node.sublist.getEndOffset());
        return node;
    }

    final CIfElse scanCIf(ExprContext context) {
        CIfElse node = new CIfElse();
        this.setupFromSourceToken(node);
        this.consumeToken();
        int ok = 0;
        this.readLines();
        if (this.nextType == RTerminal.GROUP_OPEN) {
            node.condOpenOffset = this.lexer.getOffset();
            node.setEndOffset(this.lexer.getOffset() + 1);
            this.consumeToken();
            this.readLines();
            ok += this.scanInGroup(node, node.condExpr);
            if (this.nextType == RTerminal.GROUP_CLOSE) {
                node.condCloseOffset = this.lexer.getOffset();
                node.setEndOffset(node.condCloseOffset + 1);
                this.consumeToken();
                ok = 1;
                this.readLines();
            } else {
                node.setStatus(4195680);
                node.setEndOffset(node.condExpr.node.getEndOffset());
            }
        } else {
            node.setStatus(0x400540);
            node.condExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12587796);
        }
        if (ok > 0 || this.recoverCCont()) {
            ExprContext thenContext = new ExprContext(node, node.thenExpr, context.lineMode);
            this.scanInExpression(thenContext);
            this.checkExpression(thenContext);
            node.setEndOffset(node.thenExpr.node.getEndOffset());
            if (context.lineMode >= 2) {
                this.readLines();
            }
        } else {
            node.thenExpr.node = this.errorNonExistExpression(node, node.condExpr.node.getEndOffset(), 12587798);
        }
        if (this.nextType == RTerminal.ELSE) {
            node.withElse = true;
            node.elseOffset = this.lexer.getOffset();
            this.consumeToken();
        }
        return node;
    }

    final CIfElse scanCElse(ExprContext context) {
        CIfElse node = new CIfElse();
        this.setupFromSourceToken(node);
        node.setStatus(4195632);
        node.condExpr.node = this.errorNonExistExpression(node, node.getStartOffset(), 12587796);
        node.thenExpr.node = this.errorNonExistExpression(node, node.getStartOffset(), 12587798);
        node.elseOffset = this.lexer.getOffset();
        node.withElse = true;
        this.consumeToken();
        return node;
    }

    final CForLoop scanCForLoop(ExprContext context) {
        CForLoop node = new CForLoop();
        this.setupFromSourceToken(node);
        this.consumeToken();
        int ok = 0;
        this.readLines();
        if (this.nextType == RTerminal.GROUP_OPEN) {
            node.condOpenOffset = this.lexer.getOffset();
            this.consumeToken();
            this.readLines();
            switch (this.nextType) {
                case SYMBOL: 
                case SYMBOL_G: {
                    node.varSymbol = this.createSymbol(node);
                    this.readLines();
                    break;
                }
                default: {
                    node.varSymbol = this.errorNonExistingSymbol(node, node.condOpenOffset + 1, 0x400330);
                    --ok;
                }
            }
            if (this.nextType == RTerminal.IN) {
                node.inOffset = this.lexer.getOffset();
                node.setEndOffset(node.inOffset + 2);
                this.consumeToken();
                this.readLines();
                ok += this.scanInGroup(node, node.condExpr);
            } else {
                node.setStatus(ok >= 0 ? 0x400550 : 0xC00550);
                node.setEndOffset(node.varSymbol.getEndOffset());
                node.condExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12583700);
            }
            if (this.nextType == RTerminal.GROUP_CLOSE) {
                node.condCloseOffset = this.lexer.getOffset();
                node.setEndOffset(node.condCloseOffset + 1);
                this.consumeToken();
                ok = 1;
                this.readLines();
            } else {
                if ((node.getStatusCode() & 0x400000) == 0) {
                    node.setStatus(ok >= 0 ? 4195680 : 12584288);
                }
                node.setEndOffset(node.condExpr.node.getEndOffset());
            }
        } else {
            node.setStatus(0x400540);
            node.varSymbol = this.errorNonExistingSymbol(node, node.getEndOffset(), 0xC00330);
            node.condExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12595988);
        }
        if (ok <= 0 && !this.recoverCCont()) {
            node.loopExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12595990);
        }
        return node;
    }

    final CWhileLoop scanCWhileLoop(ExprContext context) {
        CWhileLoop node = new CWhileLoop();
        this.setupFromSourceToken(node);
        this.consumeToken();
        int ok = 0;
        this.readLines();
        if (this.nextType == RTerminal.GROUP_OPEN) {
            node.condOpenOffset = this.lexer.getOffset();
            node.setEndOffset(node.condOpenOffset + 1);
            this.consumeToken();
            this.readLines();
            ok += this.scanInGroup(node, node.condExpr);
            if (this.nextType == RTerminal.GROUP_CLOSE) {
                node.condCloseOffset = this.lexer.getOffset();
                node.setEndOffset(node.condCloseOffset + 1);
                this.consumeToken();
                ok = 1;
                this.readLines();
            } else {
                node.setStatus(ok >= 0 ? 4195680 : 12584288);
                node.setEndOffset(node.condExpr.node.getEndOffset());
            }
        } else {
            node.setStatus(0x400540);
            node.condExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12600084);
        }
        if (ok <= 0 && !this.recoverCCont()) {
            node.loopExpr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12600086);
        }
        return node;
    }

    final CRepeatLoop scanCRepeatLoop(ExprContext context) {
        CRepeatLoop node = new CRepeatLoop();
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    final FDef scanFDef(@Nullable ExprContext context) {
        FDef node;
        switch (this.nextType) {
            case FUNCTION: {
                node = new FDef.Function();
                this.setupFromSourceToken(node);
                break;
            }
            case FUNCTION_B: {
                node = new FDef.B();
                this.setupFromSourceToken(node);
                if (this.rLangVersion >= 1) break;
                node.setStatus(4220688);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.consumeToken();
        int ok = 0;
        this.readLines();
        if (this.nextType == RTerminal.GROUP_OPEN) {
            node.argsOpenOffset = this.lexer.getOffset();
            node.setEndOffset(node.argsOpenOffset + 1);
            this.consumeToken();
            this.readLines();
            this.scanInFDefArgs(node.args);
            if (this.nextType == RTerminal.GROUP_CLOSE) {
                node.argsCloseOffset = this.lexer.getOffset();
                node.setEndOffset(node.argsCloseOffset + 1);
                this.consumeToken();
                ok = 1;
                this.readLines();
            } else {
                node.setEndOffset(node.args.getEndOffset());
                if ((node.getStatusCode() & 0x400000) == 0) {
                    node.setStatus(4195872);
                }
            }
        } else {
            node.args.finishMissing(node.getEndOffset());
            if ((node.getStatusCode() & 0x400000) == 0) {
                node.setStatus(4195856);
            }
        }
        if (ok <= 0 && !this.recoverCCont()) {
            node.expr.node = this.errorNonExistExpression(node, node.getEndOffset(), 12608278);
        }
        return node;
    }

    final FCall scanFCall() {
        FCall node = new FCall();
        this.setupFromSourceToken(node);
        node.argsOpenOffset = this.lexer.getOffset();
        this.consumeToken();
        this.readLines();
        this.scanInSpecArgs(node.args);
        RParserPostExprVisitor.updateParentStatus(node.args);
        if (this.nextType == RTerminal.GROUP_CLOSE) {
            node.argsCloseOffset = this.lexer.getOffset();
            node.setEndOffset(node.argsCloseOffset + 1);
            this.consumeToken();
        } else {
            node.setStatus(0x400410);
            node.setEndOffset(node.args.getEndOffset());
        }
        return node;
    }

    final void scanInFDefArgs(FDef.Args args) {
        ArgsBuilder<FDef.Arg> builder;
        block7: {
            FDef.Arg arg;
            builder = this.getArgsBuilder();
            args.setStartEndOffset(args.rParent.getEndOffset());
            while (true) {
                arg = new FDef.Arg(args);
                switch (this.nextType) {
                    case SYMBOL: 
                    case SYMBOL_G: {
                        arg.argName = this.createSymbol(arg);
                        arg.setStartEndOffset(arg.argName.getStartOffset(), arg.argName.getEndOffset());
                        this.readLines();
                        break;
                    }
                    case COMMA: 
                    case EQUAL: {
                        arg.setStartEndOffset(this.lexer.getOffset());
                        break;
                    }
                    default: {
                        if (builder.args.isEmpty()) break block7;
                        arg.setStartEndOffset(args.getEndOffset());
                    }
                }
                if (arg.argName == null) {
                    arg.argName = this.errorNonExistingSymbol(arg, arg.getEndOffset(), 0x400330);
                }
                if (this.nextType == RTerminal.EQUAL) {
                    arg.setEndOffset(this.lexer.getOffset() + 1);
                    this.consumeToken();
                    Expression expr = arg.addDefault();
                    this.scanInGroup(arg, expr);
                    arg.setEndOffset(arg.defaultExpr.node.getEndOffset());
                }
                builder.args.add(arg);
                RParserPostExprVisitor.updateParentStatus(arg);
                if (this.nextType != RTerminal.COMMA) break;
                args.setEndOffset(this.lexer.getOffset() + 1);
                this.consumeToken();
                this.readLines();
            }
            args.setStartEndOffset(((FDef.Arg)((Object)builder.args.get(0))).getStartOffset(), arg.getEndOffset());
        }
        args.finish(builder);
        this.returnArgsBuilder(builder);
    }

    final void scanInSpecArgs(FCall.Args args) {
        FCall.Arg arg;
        ArgsBuilder<FCall.Arg> builder = this.getArgsBuilder();
        args.setStartEndOffset(args.rParent.getEndOffset());
        while (true) {
            arg = new FCall.Arg(args);
            arg.setStartOffset(this.lexer.getOffset());
            switch (this.nextType) {
                case SYMBOL: {
                    arg.argName = this.createSymbol(arg);
                    this.readLines();
                    break;
                }
                case STRING_D: 
                case STRING_S: 
                case STRING_R: {
                    arg.argName = this.createStringConst(arg);
                    this.readLines();
                    break;
                }
                case NULL: {
                    arg.argName = this.createNullConst(arg);
                    this.readLines();
                    break;
                }
                case EQUAL: {
                    arg.argName = this.errorNonExistingSymbol(arg, this.lexer.getOffset(), 4195104);
                    break;
                }
            }
            if (arg.argName != null) {
                if (this.nextType == RTerminal.EQUAL) {
                    RParserPostExprVisitor.updateParentStatus(arg.argName);
                    arg.equalsOffset = this.lexer.getOffset();
                    arg.setEndOffset(arg.equalsOffset + 1);
                    this.consumeToken();
                    valueContext = new ExprContext(arg, arg.valueExpr, 3);
                    this.scanInExpression(valueContext);
                    if (arg.valueExpr.node != null) {
                        this.checkExpression(valueContext);
                        arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                    }
                } else {
                    arg.valueExpr.node = arg.argName;
                    arg.argName = null;
                    valueContext = new ExprContext(arg, arg.valueExpr, 3);
                    valueContext.update(arg.valueExpr.node, null);
                    this.scanInExpression(valueContext);
                    this.checkExpression(valueContext);
                    arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                }
            } else {
                valueContext = new ExprContext(arg, arg.valueExpr, 3);
                this.scanInExpression(valueContext);
                if (arg.valueExpr.node != null) {
                    this.checkExpression(valueContext);
                    arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                } else {
                    arg.setStartEndOffset(args.getEndOffset());
                }
            }
            if (this.nextType != RTerminal.COMMA) break;
            builder.args.add(arg);
            RParserPostExprVisitor.updateParentStatus(arg);
            builder.sepOffsets.add(this.lexer.getOffset());
            args.setEndOffset(this.lexer.getOffset() + 1);
            this.consumeToken();
            this.readLines();
        }
        if (arg.hasChildren() || !builder.args.isEmpty()) {
            builder.args.add(arg);
            RParserPostExprVisitor.updateParentStatus(arg);
            args.setStartEndOffset(((FCall.Arg)((Object)builder.args.get(0))).getStartOffset(), arg.getEndOffset());
        }
        args.finish(builder);
        this.returnArgsBuilder(builder);
    }

    final void scanInSpecArgs(SubIndexed.Args args) {
        SubIndexed.Arg arg;
        ArgsBuilder<SubIndexed.Arg> builder = this.getArgsBuilder();
        args.setStartEndOffset(args.rParent.getEndOffset());
        while (true) {
            arg = new SubIndexed.Arg(args);
            arg.setStartOffset(this.lexer.getOffset());
            switch (this.nextType) {
                case SYMBOL: {
                    arg.argName = this.createSymbol(arg);
                    this.readLines();
                    break;
                }
                case STRING_D: 
                case STRING_S: 
                case STRING_R: {
                    arg.argName = this.createStringConst(arg);
                    this.readLines();
                    break;
                }
                case NULL: {
                    arg.argName = this.createNullConst(arg);
                    this.readLines();
                    break;
                }
                case EQUAL: {
                    arg.argName = this.errorNonExistingSymbol(arg, this.lexer.getOffset(), 4195104);
                    break;
                }
            }
            if (arg.argName != null) {
                if (this.nextType == RTerminal.EQUAL) {
                    RParserPostExprVisitor.updateParentStatus(arg.argName);
                    arg.equalsOffset = this.lexer.getOffset();
                    arg.setEndOffset(arg.equalsOffset + 1);
                    this.consumeToken();
                    valueContext = new ExprContext(arg, arg.valueExpr, 3);
                    this.scanInExpression(valueContext);
                    if (arg.valueExpr.node != null) {
                        this.checkExpression(valueContext);
                        arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                    }
                } else {
                    arg.valueExpr.node = arg.argName;
                    arg.argName = null;
                    valueContext = new ExprContext(arg, arg.valueExpr, 3);
                    valueContext.update(arg.valueExpr.node, null);
                    this.scanInExpression(valueContext);
                    this.checkExpression(valueContext);
                    arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                }
            } else {
                valueContext = new ExprContext(arg, arg.valueExpr, 3);
                this.scanInExpression(valueContext);
                if (arg.valueExpr.node != null) {
                    this.checkExpression(valueContext);
                    arg.setEndOffset(arg.valueExpr.node.getEndOffset());
                } else {
                    arg.setStartEndOffset(args.getEndOffset());
                }
            }
            if (this.nextType != RTerminal.COMMA) break;
            builder.args.add(arg);
            RParserPostExprVisitor.updateParentStatus(arg);
            builder.sepOffsets.add(this.lexer.getOffset());
            args.setEndOffset(this.lexer.getOffset() + 1);
            this.consumeToken();
            this.readLines();
        }
        if (arg.hasChildren() || !builder.args.isEmpty()) {
            builder.args.add(arg);
            RParserPostExprVisitor.updateParentStatus(arg);
            args.setStartEndOffset(((SubIndexed.Arg)((Object)builder.args.get(0))).getStartOffset(), arg.getEndOffset());
        }
        args.finish(builder);
        this.returnArgsBuilder(builder);
    }

    final boolean recoverCCont() {
        return !this.wasLinebreak && (this.nextType == RTerminal.SYMBOL || this.nextType == RTerminal.SYMBOL_G || this.nextType == RTerminal.BLOCK_OPEN);
    }

    final void appendNonOp(ExprContext context, RAstNode newNode) {
        if (context.openExpr != null) {
            newNode.rParent = context.lastNode;
            context.openExpr.node = newNode;
        } else {
            Dummy.Operator error = new Dummy.Operator(4195200);
            error.rParent = context.rootNode;
            error.leftExpr.node = context.rootExpr.node;
            error.setStartEndOffset(newNode.getStartOffset());
            context.rootExpr.node = error;
            newNode.rParent = error;
            error.rightExpr.node = newNode;
            context.rootExpr.node = error;
        }
        context.update(newNode, newNode.getRightExpr());
    }

    final void appendOp(ExprContext context, RAstNode newNode) {
        if (context.openExpr != null) {
            context.openExpr.node = this.errorNonExistExpression(context.lastNode, newNode.getStartOffset(), newNode.getMissingExprStatus(newNode.getLeftExpr()));
            context.update(context.openExpr.node, null);
        }
        int newP = newNode.getNodeType().opPrec;
        RAstNode left = context.lastNode;
        RAstNode cand = context.lastNode;
        block4: while (cand != null && cand != context.rootNode) {
            NodeType candType = cand.getNodeType();
            if (candType.opPrec == newP) {
                switch (candType.opAssoc) {
                    case 3: {
                        left = cand;
                        if ((newNode.getStatusCode() & 0x400000) != 0) break block4;
                        newNode.setStatus(4194731);
                        break;
                    }
                    case 4: {
                        left = cand;
                        break;
                    }
                }
                break;
            }
            if (candType.opPrec > newP) break;
            left = cand;
            cand = cand.rParent;
        }
        RAstNode baseNode = left.rParent;
        if (baseNode == null) {
            throw new IllegalStateException();
        }
        Expression baseExpr = baseNode.getExpr(left);
        newNode.getLeftExpr().node = left;
        left.rParent = newNode;
        baseExpr.node = newNode;
        newNode.rParent = baseNode;
        context.update(newNode, newNode.getRightExpr());
    }

    Dummy.Terminal errorNonExistExpression(RAstNode parent, int stopHint, int statusCode) {
        Dummy.Terminal error = new Dummy.Terminal(statusCode, parent, stopHint != Integer.MIN_VALUE ? stopHint : parent.getEndOffset());
        parent.setStatusSeverityInChild(0x4000000);
        return error;
    }

    Dummy.Terminal errorFromNext(@Nullable RAstNode parent) {
        Dummy.Terminal error = new Dummy.Terminal(this.nextType == RTerminal.UNKNOWN ? 4194704 : 4194720, parent, this.lexer.getOffset(), this.lexer.getEndOffset());
        if (this.createText) {
            error.text = this.lexer.getText();
        }
        this.consumeToken();
        if (parent != null) {
            parent.setStatusSeverityInChild(0x4000000);
        }
        return error;
    }

    Symbol errorNonExistingSymbol(RAstNode parent, int offset, int statusCode) {
        Symbol.Std error = new Symbol.Std(statusCode, parent, offset, offset);
        ((SingleValue)error).setText("", null);
        error.setStatus(statusCode);
        parent.setStatusSeverityInChild(0x4000000);
        return error;
    }

    protected Symbol createSymbol(@Nullable RAstNode parent) {
        Symbol symbol = switch (this.nextType) {
            case RTerminal.SYMBOL_G -> new Symbol.G();
            case RTerminal.SYMBOL -> new Symbol.Std();
            default -> throw new IllegalStateException();
        };
        symbol.rParent = parent;
        this.setupFromSourceToken(symbol);
        RParserPostExprVisitor.updateParentStatus(symbol);
        this.consumeToken();
        return symbol;
    }

    protected NumberConst createNumberConst(@Nullable RAstNode parent) {
        NumberConst num = new NumberConst(this.nextType);
        num.rParent = parent;
        this.setupFromSourceToken(num);
        this.consumeToken();
        return num;
    }

    protected NullConst createNullConst(RAstNode parent) {
        NullConst num = new NullConst();
        num.rParent = parent;
        this.setupFromSourceToken(num);
        this.consumeToken();
        return num;
    }

    protected StringConst createStringConst(@Nullable RAstNode parent) {
        StringConst str = switch (this.nextType) {
            case RTerminal.STRING_D -> new StringConst.D();
            case RTerminal.STRING_S -> new StringConst.S();
            case RTerminal.STRING_R -> new StringConst.R();
            default -> throw new IllegalStateException();
        };
        str.rParent = parent;
        this.setupFromSourceToken(str);
        this.consumeToken();
        return str;
    }

    protected Assignment createAssignment() {
        Assignment node = switch (this.nextType) {
            case RTerminal.ARROW_LEFT_S -> new Assignment.LeftS();
            case RTerminal.ARROW_LEFT_D -> new Assignment.LeftD();
            case RTerminal.ARROW_RIGHT_S -> new Assignment.RightS();
            case RTerminal.ARROW_RIGHT_D -> new Assignment.RightD();
            case RTerminal.EQUAL -> new Assignment.LeftE();
            case RTerminal.COLON_EQUAL -> new Assignment.LeftC();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Model createModel() {
        Model node = new Model();
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected CLoopCommand createLoopCommand() {
        CLoopCommand node = switch (this.nextType) {
            case RTerminal.NEXT -> new CLoopCommand.Next();
            case RTerminal.BREAK -> new CLoopCommand.Break();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Sign createSign() {
        Sign node = switch (this.nextType) {
            case RTerminal.PLUS -> new Sign.PlusSign();
            case RTerminal.MINUS -> new Sign.MinusSign();
            case RTerminal.NOT -> new Sign.Not();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Arithmetic createArithmetic() {
        Arithmetic node = switch (this.nextType) {
            case RTerminal.PLUS -> new Arithmetic.Plus();
            case RTerminal.MINUS -> new Arithmetic.Minus();
            case RTerminal.MULT -> new Arithmetic.Mult();
            case RTerminal.DIV -> new Arithmetic.Div();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Power createPower() {
        Power node = new Power();
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Seq createSeq() {
        Seq node = new Seq();
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Special createSpecial() {
        Special node = new Special();
        this.setupFromSourceToken(node);
        if (this.createText) {
            node.qualifier = this.lexer.getText(this.symbolTextFactory);
        }
        this.consumeToken();
        return node;
    }

    protected Relational createRelational() {
        Relational node = switch (this.nextType) {
            case RTerminal.REL_LT -> new Relational.LT();
            case RTerminal.REL_LE -> new Relational.LE();
            case RTerminal.REL_EQ -> new Relational.EQ();
            case RTerminal.REL_GE -> new Relational.GE();
            case RTerminal.REL_GT -> new Relational.GT();
            case RTerminal.REL_NE -> new Relational.NE();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Logical createLogical() {
        Logical node = switch (this.nextType) {
            case RTerminal.AND -> new Logical.And();
            case RTerminal.AND_D -> new Logical.AndD();
            case RTerminal.OR -> new Logical.Or();
            case RTerminal.OR_D -> new Logical.OrD();
            default -> throw new IllegalStateException();
        };
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    protected Help createHelp() {
        Help node = new Help();
        this.setupFromSourceToken(node);
        this.consumeToken();
        return node;
    }

    private final void setupFromSourceToken(RAstNode node) {
        node.setStatus(this.lexer.getFlags());
        node.setStartEndOffset(this.lexer.getOffset(), this.lexer.getEndOffset());
    }

    private final void setupFromSourceToken(Symbol node) {
        node.setStatus(this.lexer.getFlags());
        node.setStartEndOffset(this.lexer.getOffset(), this.lexer.getEndOffset());
        if (this.createText) {
            node.setText(this.lexer.getText(this.symbolTextFactory), this.lexer.getTextRegion());
            StatusDetail statusDetail = this.lexer.getStatusDetail();
            if (statusDetail != null) {
                node.addAttachment(statusDetail);
            }
        }
    }

    private final void setupFromSourceToken(SingleValue node) {
        node.setStatus(this.lexer.getFlags());
        node.setStartEndOffset(this.lexer.getOffset(), this.lexer.getEndOffset());
        if (this.createText) {
            node.setText(this.lexer.getText(), this.lexer.getTextRegion());
            StatusDetail statusDetail = this.lexer.getStatusDetail();
            if (statusDetail != null) {
                node.addAttachment(statusDetail);
            }
        }
    }

    private final int checkExpression(ExprContext context) {
        int state = 0;
        if (context.openExpr != null && context.openExpr.node == null) {
            context.openExpr.node = this.errorNonExistExpression(context.lastNode, context.lastNode.getEndOffset(), context.lastNode.getMissingExprStatus(context.openExpr));
            state = -1;
        }
        context.rootNode.setStatusSeverityInChild(this.postVisitor.check(context.rootExpr.node));
        return state;
    }

    private final void readLines() {
        while (this.nextType == RTerminal.LINEBREAK) {
            this.consumeToken();
        }
    }

    private final void consumeToken() {
        this.wasLinebreak = this.nextType == RTerminal.LINEBREAK;
        this.nextType = this.lexer.next();
        switch (this.nextType) {
            case COMMENT: 
            case ROXYGEN_COMMENT: {
                if ((this.commentsLevel & 8) != 0) {
                    this.consumeCommentWithRoxygen();
                } else {
                    this.consumeComment();
                }
                return;
            }
        }
    }

    private void consumeCommentWithRoxygen() {
        block5: while (true) {
            switch (this.nextType) {
                case COMMENT: {
                    if (this.roxygen.hasComment()) {
                        this.comments.add(this.roxygen.finish(this.lexer));
                    }
                    Comment comment = new Comment.CommonLine();
                    this.setupFromSourceToken(comment);
                    this.comments.add(comment);
                    this.nextType = this.lexer.next();
                    continue block5;
                }
                case ROXYGEN_COMMENT: {
                    Comment comment = new Comment.RoxygenLine();
                    this.setupFromSourceToken(comment);
                    this.roxygen.add(comment);
                    this.nextType = this.lexer.next();
                    continue block5;
                }
                case LINEBREAK: {
                    this.nextType = this.lexer.next();
                    if (this.nextType != RTerminal.LINEBREAK || !this.roxygen.hasComment()) continue block5;
                    this.comments.add(this.roxygen.finish(null));
                    continue block5;
                }
            }
            break;
        }
        if (this.roxygen.hasComment()) {
            this.comments.add(this.roxygen.finish(this.lexer));
        }
        this.wasLinebreak = true;
    }

    private void consumeComment() {
        block4: while (true) {
            switch (this.nextType) {
                case COMMENT: 
                case ROXYGEN_COMMENT: {
                    if (this.commentsLevel != 0) {
                        Comment comment = this.nextType == RTerminal.ROXYGEN_COMMENT ? new Comment.RoxygenLine() : new Comment.CommonLine();
                        this.setupFromSourceToken(comment);
                        this.comments.add(comment);
                    }
                    this.nextType = this.lexer.next();
                    continue block4;
                }
                case LINEBREAK: {
                    this.nextType = this.lexer.next();
                    continue block4;
                }
            }
            break;
        }
        this.wasLinebreak = true;
    }

    private void clearArgsBuilder() {
        int idx = this.argBuildersIdx;
        while (idx > 0) {
            ArgsBuilder<?> builder = this.argBuilders.get(--idx);
            builder.args.clear();
            builder.sepOffsets.clear();
        }
        this.argBuildersIdx = 0;
    }

    private <TArg> ArgsBuilder<TArg> getArgsBuilder() {
        ArgsBuilder<Object> builder;
        if (this.argBuildersIdx < this.argBuilders.size()) {
            builder = this.argBuilders.get(this.argBuildersIdx);
        } else {
            builder = new ArgsBuilder();
            this.argBuilders.add(builder);
        }
        ++this.argBuildersIdx;
        return builder;
    }

    private void returnArgsBuilder(ArgsBuilder<?> builder) {
        builder.args.clear();
        builder.sepOffsets.clear();
        --this.argBuildersIdx;
    }

    static final class ArgsBuilder<T> {
        final ArrayList<T> args = new ArrayList(8);
        final IntList sepOffsets = new IntArrayList(8);

        ArgsBuilder() {
        }
    }

    private static final class ExprContext {
        final RAstNode rootNode;
        final Expression rootExpr;
        RAstNode lastNode;
        @Nullable Expression openExpr;
        final byte lineMode;

        public ExprContext(RAstNode node, Expression expr, byte eatLines) {
            this.rootNode = this.lastNode = node;
            this.rootExpr = this.openExpr = expr;
            this.lineMode = eatLines;
        }

        final void update(RAstNode lastNode, @Nullable Expression openExpr) {
            this.lastNode = lastNode;
            this.openExpr = openExpr == null || openExpr.node != null ? null : openExpr;
        }
    }

    private static final class RoxygenCollector {
        private Comment[] lines = new Comment[64];
        private int lineCount;
        private @Nullable DocuComment current;

        private RoxygenCollector() {
        }

        void init() {
            this.lineCount = 0;
            this.current = null;
        }

        void add(Comment comment) {
            if (this.current == null) {
                this.current = new DocuComment();
            }
            comment.rParent = this.current;
            if (this.lineCount == this.lines.length) {
                this.lines = Arrays.copyOf(this.lines, this.lineCount + 64);
            }
            this.lines[this.lineCount++] = comment;
        }

        boolean hasComment() {
            return this.current != null;
        }

        DocuComment finish(@Nullable RLexer lexer) {
            DocuComment comment = new DocuComment();
            Comment[] lines = Arrays.copyOf(this.lines, this.lineCount);
            comment.lines = lines;
            comment.setStartEndOffset(lines[0].getStartOffset(), lines[this.lineCount - 1].getEndOffset());
            comment.nextOffset = lexer != null && lexer.getType() != RTerminal.EOF ? lexer.getOffset() : Integer.MIN_VALUE;
            this.lineCount = 0;
            this.current = null;
            return comment;
        }
    }
}

