/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.internal.nico.ui.console.ControlMarker;
import org.eclipse.statet.internal.nico.ui.console.ExtStylingEngine;
import org.eclipse.statet.internal.nico.ui.console.InternArrayList;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartition;
import org.eclipse.statet.internal.nico.ui.console.StreamProcessor;
import org.eclipse.statet.internal.nico.ui.console.StyleData;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.progress.WorkbenchJob;

@NonNullByDefault
public class NIConsolePartitioner
implements IConsoleDocumentPartitioner,
IDocumentPartitionerExtension {
    private static final boolean DEBUG = false;
    private final NIConsole console;
    private final @NonNull String[] partitionIds;
    private @Nullable AbstractDocument document;
    private boolean isConnected = false;
    private final InternArrayList<NIConsolePartition> partitions = new InternArrayList();
    private @Nullable NIConsolePartition lastPartition;
    private final ArrayList<@Nullable PendingPartition> pendingPartitions = new ArrayList();
    private int pendingTextLength;
    private final QueueProcessingJob queueJob = new QueueProcessingJob();
    private final TrimJob trimJob = new TrimJob();
    private boolean updateInProgress;
    private final StreamProcessor streamProcessor;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private final Object overflowLock = new Object();
    private final ExtStylingEngine stylingEngine = new ExtStylingEngine();

    public NIConsolePartitioner(NIConsole console, List<String> ids) {
        this.console = console;
        this.streamProcessor = new StreamProcessor(this);
        this.partitionIds = ids.toArray(new String[ids.size()]);
        this.trimJob.setRule(this.console.getSchedulingRule());
        this.queueJob.setRule(this.console.getSchedulingRule());
    }

    NIConsolePartitioner(ISchedulingRule schedulingRule, List<String> ids) {
        this.console = null;
        this.streamProcessor = new StreamProcessor(this);
        this.partitionIds = ids.toArray(new String[ids.size()]);
        this.trimJob.setRule(schedulingRule);
        this.queueJob.setRule(schedulingRule);
    }

    public NIConsole getConsole() {
        return this.console;
    }

    public @Nullable AbstractDocument getDocument() {
        return this.document;
    }

    @Nullable NIConsolePartition getLastPartition() {
        return this.lastPartition;
    }

    public void connect(IDocument doc) {
        this.document = (AbstractDocument)doc;
        doc.setDocumentPartitioner((IDocumentPartitioner)this);
        this.isConnected = true;
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int low, int high) {
        this.lowWaterMark = low;
        this.highWaterMark = high;
        ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NIConsolePartitioner.this.checkBufferSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            this.pendingPartitions.add(null);
        }
        this.queueJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.isConnected = false;
            this.document = null;
            this.partitions.clear();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public @NonNull String[] getLegalContentTypes() {
        return this.partitionIds;
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    /*
     * Unable to fully structure code
     */
    private int indexOfFirstPartition(int offset) {
        low = 0;
        high = this.partitions.size() - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            p = (NIConsolePartition)this.partitions.get(mid);
            if (p.getOffset() > offset) {
                high = mid - 1;
                continue;
            }
            if (p.getOffset() == offset || p.getEndOffset() > offset) ** GOTO lbl14
            low = mid + 1;
            continue;
            while ((p = (NIConsolePartition)this.partitions.get(mid - 1)).getOffset() == offset || p.getEndOffset() > offset) {
                --mid;
lbl14:
                // 2 sources

                if (mid > 0) continue;
            }
            return mid;
        }
        return ~low;
    }

    /*
     * Unable to fully structure code
     */
    private int indexOfLastPartition(int offset) {
        low = 0;
        high = this.partitions.size() - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            p = (NIConsolePartition)this.partitions.get(mid);
            if (p.getOffset() > offset) {
                high = mid - 1;
                continue;
            }
            if (p.getOffset() == offset || p.getEndOffset() >= offset) ** GOTO lbl14
            low = mid + 1;
            continue;
            while ((p = (NIConsolePartition)this.partitions.get(mid + 1)).getOffset() <= offset) {
                ++mid;
lbl14:
                // 2 sources

                if (mid < high) continue;
            }
            return mid;
        }
        return ~low;
    }

    public ITypedRegion getPartition(int offset) {
        int index = this.indexOfLastPartition(offset);
        if (index < 0) {
            NIConsolePartition p = this.lastPartition;
            return p != null ? new NIConsolePartition(p.getType(), p.getStream(), offset, 0) : new NIConsolePartition(this.partitionIds[0], null, offset, 0);
        }
        return (ITypedRegion)this.partitions.get(index);
    }

    public @NonNull ITypedRegion[] computePartitioning(int offset, int length) {
        int index = this.indexOfLastPartition(offset);
        if (index < 0) {
            return new NIConsolePartition[0];
        }
        int endOffset = offset + length;
        ArrayList<NIConsolePartition> list = new ArrayList<NIConsolePartition>();
        NIConsolePartition p = null;
        p = (NIConsolePartition)this.partitions.get(index++);
        list.add(p.trim(offset, endOffset));
        while (index < this.partitions.size()) {
            if ((p = (NIConsolePartition)this.partitions.get(index++)).getEndOffset() < endOffset) {
                list.add(p);
                continue;
            }
            if (p.getOffset() >= endOffset) continue;
            list.add(p.trim(offset, endOffset));
            break;
        }
        return list.toArray(new NIConsolePartition[list.size()]);
    }

    public List<NIConsolePartition> computePartitioningWithStyles(int offset, int length) {
        int index = this.indexOfLastPartition(offset);
        if (index < 0) {
            return ImCollections.emptyList();
        }
        int endOffset = offset + length;
        ArrayList<NIConsolePartition> list = new ArrayList<NIConsolePartition>();
        NIConsolePartition p = null;
        p = (NIConsolePartition)this.partitions.get(index++);
        list.add(p.trimWithStyles(offset, endOffset));
        while (index < this.partitions.size()) {
            if ((p = (NIConsolePartition)this.partitions.get(index++)).getEndOffset() < endOffset) {
                list.add(p);
                continue;
            }
            if (p.getOffset() >= endOffset) continue;
            list.add(p.trimWithStyles(offset, endOffset));
            break;
        }
        return list;
    }

    private void checkBufferSize() {
        int length;
        AbstractDocument document = this.document;
        if (document != null && this.highWaterMark > 0 && (length = document.getLength()) > this.highWaterMark && this.trimJob.getState() == 0) {
            this.trimJob.setOffset(length - this.lowWaterMark);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.trimJob.setOffset(-1);
            this.trimJob.schedule();
        }
    }

    public @Nullable IRegion documentChanged2(DocumentEvent event) {
        AbstractDocument document = this.document;
        if (document == null) {
            return null;
        }
        if (document.getLength() == 0) {
            this.partitions.clear();
            this.lastPartition = null;
            this.streamProcessor.clear();
            return new Region(0, 0);
        }
        if (this.updateInProgress && this.streamProcessor.hasUpdate()) {
            int offset = this.streamProcessor.getTextOffsetInDoc();
            NIConsolePartition partition = this.lastPartition;
            for (PendingPartition pp : this.streamProcessor.getPartitions()) {
                if (pp == null || pp.startOffset == pp.endOffset && pp.controlMarkers == null) continue;
                if (partition != null) {
                    int idx;
                    if (partition.getStream() == pp.stream) {
                        partition.append(offset, pp.endOffset, pp.controlMarkers);
                        offset = pp.endOffset;
                        continue;
                    }
                    if (partition.getLength() == 0 && !partition.getControlMarkers().isEmpty() && (idx = this.partitions.lastIndexOf(partition)) >= 0) {
                        this.partitions.remove(idx);
                    }
                    partition = null;
                }
                partition = new NIConsolePartition(pp.stream.getId(), pp.stream, offset, pp.endOffset, pp.initalStyleData, pp.controlMarkers);
                this.partitions.add(partition);
                offset = partition.getEndOffset();
            }
            this.lastPartition = partition;
            this.streamProcessor.updateApplied();
        }
        return new Region(event.fOffset, event.fText.length());
    }

    private void setUpdateInProgress(boolean b) {
        this.updateInProgress = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAppended(NIConsoleOutputStream stream, String s, int startIndex, int endIndex) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            PendingPartition last;
            PendingPartition pendingPartition = last = !this.pendingPartitions.isEmpty() ? this.pendingPartitions.getLast() : null;
            if (last != null && last.stream == stream) {
                last.append(s, startIndex, endIndex);
            } else {
                this.pendingPartitions.add(new PendingPartition(stream, s, startIndex, endIndex));
                if (this.pendingTextLength > 511) {
                    this.queueJob.schedule();
                } else {
                    this.queueJob.schedule(50L);
                }
            }
            if (this.pendingTextLength > 65535) {
                if (Display.getCurrent() == null) {
                    try {
                        this.pendingPartitions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.processQueue();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        Object object = this.overflowLock;
        synchronized (object) {
            block13: {
                int pendingLength;
                ImList pendingCopy;
                ArrayList<PendingPartition> arrayList = this.pendingPartitions;
                synchronized (arrayList) {
                    pendingCopy = ImCollections.toList(this.pendingPartitions);
                    this.pendingPartitions.clear();
                    pendingLength = this.pendingTextLength;
                    this.pendingTextLength = 0;
                    this.pendingPartitions.notifyAll();
                }
                if (pendingCopy.isEmpty()) {
                    return;
                }
                this.streamProcessor.prepareUpdate((ImList<PendingPartition>)pendingCopy, pendingLength);
                try {
                    try {
                        if (this.isConnected) {
                            AbstractDocument document = (AbstractDocument)ObjectUtils.nonNullAssert((Object)this.document);
                            this.setUpdateInProgress(true);
                            document.replace(this.streamProcessor.getTextOffsetInDoc(), this.streamProcessor.getTextReplaceLengthInDoc(), this.streamProcessor.getText());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.setUpdateInProgress(false);
                        this.streamProcessor.wasFinished();
                        this.streamProcessor.updateDone();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.setUpdateInProgress(false);
                    this.streamProcessor.wasFinished();
                    this.streamProcessor.updateDone();
                    throw throwable;
                }
                this.setUpdateInProgress(false);
                this.streamProcessor.wasFinished();
                this.streamProcessor.updateDone();
            }
            this.checkBufferSize();
        }
    }

    public boolean isReadOnly(int offset) {
        return true;
    }

    public ExtStylingEngine getStylingEngine() {
        return this.stylingEngine;
    }

    public @NonNull StyleRange[] getStyleRanges(int offset, int length) {
        if (!this.isConnected) {
            return new StyleRange[0];
        }
        ArrayList<StyleRange> styles = this.stylingEngine.computeStyleRanges(this.computePartitioningWithStyles(offset, length));
        return styles.toArray(new StyleRange[styles.size()]);
    }

    final class PendingPartition {
        private final NIConsoleOutputStream stream;
        private final StringBuilder text;
        private int startOffset;
        private int endOffset;
        private @Nullable StyleData initalStyleData;
        private @Nullable InternArrayList<ControlMarker> controlMarkers;

        PendingPartition(NIConsoleOutputStream stream, String text, int startIndex, int endIndex) {
            this.stream = stream;
            this.text = new StringBuilder(Math.max(4, 2 + (endIndex - startIndex) / 1014) * 1024);
            this.append(text, startIndex, endIndex);
        }

        public NIConsoleOutputStream getStream() {
            return this.stream;
        }

        private void append(String text, int startIndex, int endIndex) {
            this.text.append(text, startIndex, endIndex);
            NIConsolePartitioner.this.pendingTextLength += endIndex - startIndex;
        }

        public StringBuilder getText() {
            return this.text;
        }

        public void setFinalData(int startOffset, int endOffset, @Nullable StyleData initalStyleData, @Nullable InternArrayList<ControlMarker> controlMarkers) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.initalStyleData = initalStyleData;
            this.controlMarkers = controlMarkers != null && !controlMarkers.isEmpty() ? controlMarkers : null;
        }
    }

    private class QueueProcessingJob
    extends WorkbenchJob {
        QueueProcessingJob() {
            super("IOConsole Updater");
            this.setSystem(true);
            this.setPriority(10);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            NIConsolePartitioner.this.processQueue();
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            boolean shouldRun = NIConsolePartitioner.this.isConnected && NIConsolePartitioner.this.pendingPartitions.size() > 0;
            return shouldRun;
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setOffset(int offset) {
            this.truncateOffset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            IJobManager jobManager = Job.getJobManager();
            try {
                jobManager.join((Object)NIConsolePartitioner.this.console, monitor);
            }
            catch (InterruptedException | OperationCanceledException e1) {
                return Status.CANCEL_STATUS;
            }
            AbstractDocument document = NIConsolePartitioner.this.document;
            if (document == null) {
                return Status.OK_STATUS;
            }
            int length = document.getLength();
            if (this.truncateOffset < length) {
                Object object = NIConsolePartitioner.this.overflowLock;
                synchronized (object) {
                    try {
                        if (this.truncateOffset < 0) {
                            NIConsolePartitioner.this.setUpdateInProgress(true);
                            document.set("");
                            NIConsolePartitioner.this.setUpdateInProgress(false);
                        } else {
                            int cutoffLine = document.getLineOfOffset(this.truncateOffset);
                            int cutOffset = document.getLineOffset(cutoffLine);
                            NIConsolePartitioner.this.setUpdateInProgress(true);
                            document.replace(0, cutOffset, "");
                            NIConsolePartitioner.this.setUpdateInProgress(false);
                            int firstIndex = NIConsolePartitioner.this.indexOfLastPartition(cutOffset);
                            NIConsolePartitioner.this.partitions.removeHead(firstIndex);
                            for (NIConsolePartition partition : NIConsolePartitioner.this.partitions) {
                                partition.shiftOffset(cutOffset);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

