/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.source.SourceConfig;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;

@NonNullByDefault
public class BasicSourceModelStamp
implements SourceModelStamp {
    private final long sourceStamp;
    private final ImList<SourceConfig> sourceConfigs;

    public BasicSourceModelStamp(long sourceStamp, ImList<SourceConfig> sourceConfigs) {
        this.sourceStamp = sourceStamp;
        this.sourceConfigs = (ImList)ObjectUtils.nonNullAssert(sourceConfigs);
    }

    public BasicSourceModelStamp(long sourceStamp) {
        this.sourceStamp = sourceStamp;
        this.sourceConfigs = ImCollections.emptyList();
    }

    @Override
    public final long getContentStamp() {
        return this.sourceStamp;
    }

    @Override
    public final <T> @Nullable T getConfig(Class<T> type) {
        for (SourceConfig sourceConfig : this.sourceConfigs) {
            if (!type.isInstance(type)) continue;
            return (T)sourceConfig;
        }
        return null;
    }

    public int hashCode() {
        int h = (int)(this.sourceStamp ^ this.sourceStamp >>> 32);
        h = 31 * h + this.sourceConfigs.hashCode();
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof BasicSourceModelStamp)) break block3;
                BasicSourceModelStamp other = (BasicSourceModelStamp)obj;
                if (this.getClass() == other.getClass() && this.sourceStamp == other.sourceStamp && this.sourceConfigs.equals(other.sourceConfigs)) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(BasicSourceModelStamp.class);
        sb.append(' ', this.sourceStamp);
        sb.addProp("sourceConfigs", this.sourceConfigs);
        return sb.toString();
    }
}

