/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.style;

import org.eclipse.statet.ecommons.waltable.persistence.ColorPersistor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Color;

@NonNullByDefault
public class BorderStyle {
    private final int thickness;
    private final Color color;
    private final LineStyle lineStyle;
    private final int offset;

    public BorderStyle(int thickness, Color color, LineStyle lineStyle, int offset) {
        this.thickness = thickness > 0 ? thickness : 0;
        this.color = (Color)ObjectUtils.nonNullAssert((Object)color);
        this.lineStyle = (LineStyle)((Object)ObjectUtils.nonNullAssert((Object)((Object)lineStyle)));
        this.offset = offset;
    }

    public BorderStyle(int thickness, Color color, LineStyle lineStyle) {
        this(thickness, color, lineStyle, 0);
    }

    public BorderStyle(String string) {
        String[] tokens = string.split("\\|");
        this.thickness = Integer.parseInt(tokens[0]);
        this.color = ColorPersistor.asColor(tokens[1]);
        this.lineStyle = LineStyle.valueOf(tokens[2]);
        this.offset = tokens.length > 3 ? Integer.parseInt(tokens[3]) : 0;
    }

    public int getThickness() {
        return this.thickness;
    }

    public Color getColor() {
        return this.color;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return (this.thickness * 13 + this.color.hashCode()) * 17 + this.lineStyle.hashCode() + this.offset * 31;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BorderStyle) {
            BorderStyle other = (BorderStyle)obj;
            return this.thickness == other.thickness && this.color.equals((Object)other.color) && this.lineStyle == other.lineStyle && this.offset == other.offset;
        }
        return false;
    }

    public String toString() {
        return this.thickness + "|" + ColorPersistor.asString(this.color) + "|" + String.valueOf((Object)this.lineStyle) + "|" + this.offset;
    }

    public static enum LineStyle {
        SOLID,
        DASHED,
        DOTTED,
        DASHDOT,
        DASHDOTDOT;

    }
}

