/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.extdoc;

import org.eclipse.statet.docmlet.wikitext.core.source.BlockWeaveParticipant;
import org.eclipse.statet.ltk.core.source.SourceContent;

public class YamlBlockWeaveParticipant
extends BlockWeaveParticipant {
    private SourceContent sourceContent;
    private int start;
    private int startMarker;

    @Override
    public String getForeignTypeId() {
        return "Yaml";
    }

    @Override
    public int getEmbedDescr() {
        return 17;
    }

    @Override
    public void reset(SourceContent content) {
        this.sourceContent = content;
        this.start = -1;
    }

    @Override
    public boolean checkStartLine(int startOffset, int endOffset) {
        String text = this.sourceContent.getString();
        int offset = startOffset;
        switch (endOffset - startOffset) {
            case 1: {
                if (text.charAt(offset) == '\n') {
                    ++offset;
                    break;
                }
                return false;
            }
            case 2: {
                if (text.charAt(offset) == '\r' && text.charAt(offset + 1) == '\n') {
                    offset += 2;
                    break;
                }
                return false;
            }
            default: {
                if (startOffset == 0 && this.sourceContent.getStartOffset() == 0) break;
                return false;
            }
        }
        if (text.regionMatches(offset, "---", 0, 3)) {
            this.start = startOffset;
            this.startMarker = offset;
            return true;
        }
        return false;
    }

    @Override
    public int getStartOffset() {
        return this.start;
    }

    @Override
    public boolean checkEndLine(int startOffset, int endOffset) {
        if (startOffset <= this.startMarker) {
            return false;
        }
        String text = this.sourceContent.getString();
        return text.regionMatches(startOffset, "---", 0, 3) || text.regionMatches(startOffset, "...", 0, 3);
    }

    @Override
    protected void appendReplacement(StringBuilder sb, String source, int startOffset, int endOffset) {
        sb.append("\n\n");
    }

    @Override
    protected int getTextLength() {
        return 0;
    }
}

