/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceHeadingAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Lines;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockNode;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockType;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class AtxHeaderBlock
extends SourceBlockType<AtxHeaderBlockNode> {
    private static final Pattern START_PATTERN = Pattern.compile("#{1,6}(?:[ \t].*)?", 32);
    private static final Pattern PATTERN = Pattern.compile("(#{1,6})(?:[ \t]??(.+?))??(?:[ \t]+#+)?[ \t]*", 32);
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher matcher;

    private Matcher getProcessMatcher() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            this.matcher = matcher = PATTERN.matcher("");
        }
        return matcher;
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockNode<?> currentNode) {
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.startMatcher).matches();
    }

    @Override
    public void createNodes(SourceBlocks.SourceBlockBuilder builder) {
        AtxHeaderBlockNode node = new AtxHeaderBlockNode(this, builder);
        builder.getLineSequence().advance();
    }

    @Override
    public void initializeContext(ProcessingContext context, AtxHeaderBlockNode node) {
    }

    @Override
    public void emit(ProcessingContext context, AtxHeaderBlockNode node, CommonmarkLocator locator, DocumentBuilder builder) {
        Line startLine = (Line)node.getLines().getFirst();
        Matcher matcher = startLine.setup(this.getProcessMatcher(), true, true);
        AtxHeaderBlock.assertMatches(matcher);
        int headingLevel = this.getHeadingLevel(startLine, matcher);
        Line contentLine = this.getContentLine(startLine, matcher);
        if (contentLine != null) {
            TextSegment textSegment = new TextSegment((ImList<Line>)ImCollections.newList((Object)contentLine));
            SourceHeadingAttributes attributes = new SourceHeadingAttributes(startLine.getLineDelimiter().isEmpty() ? 256 : 0);
            InlineParser inlineParser = context.getInlineParser();
            String headingText = inlineParser.toStringContent(context, textSegment);
            attributes.setId(context.generateHeadingId(headingLevel, headingText));
            locator.setBlockBegin(node);
            builder.beginHeading(headingLevel, (Attributes)attributes);
            inlineParser.emit(context, textSegment, locator, builder);
            locator.setBlockEnd(node);
            builder.endHeading();
        } else {
            locator.setBlockBegin(node);
            builder.beginHeading(headingLevel, (Attributes)new HeadingAttributes());
            locator.setBlockEnd(node);
            builder.endHeading();
        }
    }

    private int getHeadingLevel(Line line, Matcher matcher) {
        return matcher.end(1) - matcher.regionStart();
    }

    private @Nullable Line getContentLine(Line line, Matcher matcher) {
        int contentEnd;
        int contentOffset = matcher.start(2);
        if (contentOffset >= (contentEnd = matcher.end(2))) {
            return null;
        }
        return Lines.trimWhitespace(line.segment(contentOffset, contentEnd - contentOffset));
    }

    static final class AtxHeaderBlockNode
    extends SourceBlockNode<AtxHeaderBlock> {
        private AtxHeaderBlockNode(AtxHeaderBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

