/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.commands.EnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.Asts;

@NonNullByDefault
public class TexAsts
extends Asts {
    public static @Nullable TexAstNode[] resolveArguments(ControlNode node) {
        ImList<? extends TexCommand.Parameter> parameters = ((TexCommand)ObjectUtils.nonNullAssert((Object)node.getCommand())).getParameters();
        @Nullable TexAstNode[] resolved = new TexAstNode[parameters.size()];
        int idxArgs = 0;
        int idxValues = 0;
        while (idxArgs < resolved.length && idxValues < node.getChildCount()) {
            TexAstNode child = node.getChild(idxValues);
            if ((((TexCommand.Parameter)parameters.get(idxArgs)).getType() & 2) != 0) {
                if (child.getText() == "[") {
                    ++idxValues;
                    resolved[idxArgs++] = child;
                    continue;
                }
                ++idxArgs;
                continue;
            }
            if (child.getText() == "[") {
                ++idxValues;
                continue;
            }
            ++idxValues;
            resolved[idxArgs++] = child;
        }
        return resolved;
    }

    public static int getIndexAt(@Nullable TexAstNode[] nodes, int offset) {
        int insert = 0;
        int i = 0;
        while (i < nodes.length) {
            TexAstNode node = nodes[i];
            if (node != null) {
                if (offset < node.getStartOffset()) break;
                if (offset <= node.getEndOffset()) {
                    return i;
                }
                insert = i + 1;
            }
            ++i;
        }
        return ~insert;
    }

    public static TextRegion getInnerRegion(TexAstNode node) {
        if ((node.getStatusCode() & 0x700FFF) == 4195650) {
            return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset());
        }
        return new BasicTextRegion(node.getStartOffset() + 1, node.getEndOffset() - 1);
    }

    public static @Nullable Environment getDocumentNode(TexAstNode node) {
        int count = node.getChildCount();
        int i = 0;
        while (i < count) {
            TexAstNode child = node.getChild(i);
            if (child.getNodeType() == NodeType.ENVIRONMENT && ((Environment)node).getBeginNode().getCommand() == EnvDefinitions.ENV_document_BEGIN) {
                return (Environment)child;
            }
            ++i;
        }
        return null;
    }
}

