/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;

public class YamlCodeStyleSettings
extends AbstractPreferencesModelObject
implements IIndentSettings {
    public static final String QUALIFIER = "org.eclipse.statet.yaml.core/codestyle/Yaml";
    public static final String INDENT_GROUP_ID = "org.eclipse.statet.yaml.core/codestyle/Yaml/indent";
    public static final String[] ALL_GROUP_IDS = new String[]{"org.eclipse.statet.yaml.core/codestyle/Yaml/indent"};
    public static final Preference.IntPref TAB_WIDTH_PREF = new Preference.IntPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "Tab.size");
    public static final Preference.EnumPref<IIndentSettings.IndentationType> INDENT_DEFAULT_TYPE_PREF = new Preference.EnumPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "Indent.type", IIndentSettings.IndentationType.class, (Enum)IIndentSettings.IndentationType.TAB);
    public static final Preference.IntPref INDENT_SPACES_COUNT_PREF = new Preference.IntPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "Indent.Level.spaces_count");
    public static final Preference.BooleanPref REPLACE_CONVERSATIVE_PREF = new Preference.BooleanPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "Indent.ReplaceConservativ.enabled");
    public static final Preference.BooleanPref REPLACE_TABS_WITH_SPACES_PREF = new Preference.BooleanPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "Indent.ReplaceOtherTabs.enabled");
    public static final Preference.IntPref INDENT_BLOCK_DEPTH_PREF = new Preference.IntPref("org.eclipse.statet.yaml.core/codestyle/Yaml", "IndentBlockDepth.level");
    public static final String INDENT_BLOCK_DEPTH_PROP = "indentBlockDepth";
    private int tabWidth;
    private IIndentSettings.IndentationType indentDefaultType;
    private int indentSpacesCount;
    private boolean replaceOtherTabsWithSpaces;
    private boolean replaceConservative;
    private int indentBlockDepth;

    public YamlCodeStyleSettings(int mode) {
        if (mode >= 1) {
            this.installLock();
        }
        this.loadDefaults();
        this.resetDirty();
    }

    public String[] getNodeQualifiers() {
        return new String[]{QUALIFIER};
    }

    public void loadDefaults() {
        this.setTabWidth(4);
        this.setIndentDefaultType(IIndentSettings.IndentationType.SPACES);
        this.setIndentSpacesCount(2);
        this.setReplaceConservative(false);
        this.setReplaceOtherTabsWithSpaces(false);
        this.setIndentBlockDepth(1);
    }

    public void load(PreferenceAccess prefs) {
        this.setTabWidth((Integer)prefs.getPreferenceValue((Preference)TAB_WIDTH_PREF));
        this.setIndentDefaultType((IIndentSettings.IndentationType)prefs.getPreferenceValue(INDENT_DEFAULT_TYPE_PREF));
        this.setIndentSpacesCount((Integer)prefs.getPreferenceValue((Preference)INDENT_SPACES_COUNT_PREF));
        this.setReplaceConservative((Boolean)prefs.getPreferenceValue((Preference)REPLACE_CONVERSATIVE_PREF));
        this.setReplaceOtherTabsWithSpaces((Boolean)prefs.getPreferenceValue((Preference)REPLACE_TABS_WITH_SPACES_PREF));
        this.setIndentBlockDepth((Integer)prefs.getPreferenceValue((Preference)INDENT_BLOCK_DEPTH_PREF));
    }

    public void load(YamlCodeStyleSettings source) {
        Lock writeLock = this.getWriteLock();
        Lock sourceLock = source.getReadLock();
        try {
            sourceLock.lock();
            writeLock.lock();
            this.setTabWidth(source.tabWidth);
            this.setIndentDefaultType(source.indentDefaultType);
            this.setIndentSpacesCount(source.indentSpacesCount);
            this.setReplaceConservative(source.replaceConservative);
            this.setReplaceOtherTabsWithSpaces(source.replaceOtherTabsWithSpaces);
            this.setIndentBlockDepth(source.indentBlockDepth);
        }
        finally {
            sourceLock.unlock();
            writeLock.unlock();
        }
    }

    public Map<Preference<?>, Object> deliverToPreferencesMap(Map<Preference<?>, Object> map) {
        map.put((Preference<?>)TAB_WIDTH_PREF, this.getTabWidth());
        map.put((Preference<?>)INDENT_DEFAULT_TYPE_PREF, this.getIndentDefaultType());
        map.put((Preference<?>)INDENT_SPACES_COUNT_PREF, this.getIndentSpacesCount());
        map.put((Preference<?>)REPLACE_CONVERSATIVE_PREF, this.getReplaceConservative());
        map.put((Preference<?>)REPLACE_TABS_WITH_SPACES_PREF, this.getReplaceOtherTabsWithSpaces());
        map.put((Preference<?>)INDENT_BLOCK_DEPTH_PREF, this.getIndentBlockDepth());
        return map;
    }

    public void setTabWidth(int size) {
        int oldValue = this.tabWidth;
        this.tabWidth = size;
        this.firePropertyChange("tabWidth", oldValue, size);
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setIndentDefaultType(IIndentSettings.IndentationType type) {
        IIndentSettings.IndentationType oldValue = this.indentDefaultType;
        this.indentDefaultType = type;
        this.firePropertyChange("indentDefaultType", oldValue, type);
    }

    public IIndentSettings.IndentationType getIndentDefaultType() {
        return this.indentDefaultType;
    }

    public void setIndentSpacesCount(int count) {
        int oldValue = this.indentSpacesCount;
        this.indentSpacesCount = count;
        this.firePropertyChange("indentSpacesCount", oldValue, count);
    }

    public int getIndentSpacesCount() {
        return this.indentSpacesCount;
    }

    public void setReplaceConservative(boolean enable) {
        boolean oldValue = this.replaceConservative;
        this.replaceConservative = enable;
        this.firePropertyChange("replaceConservative", oldValue, enable);
    }

    public boolean getReplaceConservative() {
        return this.replaceConservative;
    }

    public void setReplaceOtherTabsWithSpaces(boolean enable) {
        boolean oldValue = this.replaceOtherTabsWithSpaces;
        this.replaceOtherTabsWithSpaces = enable;
        this.firePropertyChange("replaceOtherTabsWithSpaces", oldValue, this.getReplaceOtherTabsWithSpaces());
    }

    public boolean getReplaceOtherTabsWithSpaces() {
        return this.replaceOtherTabsWithSpaces;
    }

    public int getLineWidth() {
        return -1;
    }

    public final void setIndentBlockDepth(int depth) {
        int oldValue = this.indentBlockDepth;
        this.indentBlockDepth = depth;
        this.firePropertyChange(INDENT_BLOCK_DEPTH_PROP, oldValue, depth);
    }

    public final int getIndentBlockDepth() {
        return this.indentBlockDepth;
    }
}

