/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.ggplot.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.ecommons.collections.IntMap;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.rtm.base.core.AbstractRCodeGenerator;
import org.eclipse.statet.rtm.base.util.RExprTypes;
import org.eclipse.statet.rtm.ggplot.FacetLayout;
import org.eclipse.statet.rtm.ggplot.GGPlot;
import org.eclipse.statet.rtm.ggplot.GGPlotPackage;
import org.eclipse.statet.rtm.ggplot.GeomBarLayer;
import org.eclipse.statet.rtm.ggplot.GeomLineLayer;
import org.eclipse.statet.rtm.ggplot.GeomPointLayer;
import org.eclipse.statet.rtm.ggplot.GridFacetLayout;
import org.eclipse.statet.rtm.ggplot.Layer;
import org.eclipse.statet.rtm.ggplot.PropDataProvider;
import org.eclipse.statet.rtm.ggplot.PropStatProvider;
import org.eclipse.statet.rtm.ggplot.Stat;
import org.eclipse.statet.rtm.ggplot.SummaryStat;
import org.eclipse.statet.rtm.ggplot.TextStyle;
import org.eclipse.statet.rtm.ggplot.WrapFacetLayout;
import org.eclipse.statet.rtm.ggplot.core.GGPlotExprTypesProvider;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;

public class GGPlotRCodeGen
extends AbstractRCodeGenerator {
    private static final IntMap<E2R> E2R_PROPERTIES;
    private static final ImList<String> DIRECT_TYPES;
    private final String plotVar = "p";

    static {
        ArrayList<E2R> list = new ArrayList<E2R>();
        list.add(new E2R(GGPlotPackage.Literals.GG_PLOT, "ggplot"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_ABLINE_LAYER, "geom_abline"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_BAR_LAYER, "geom_bar"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_BOXPLOT_LAYER, "geom_boxplot"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_HISTOGRAM_LAYER, "geom_histogram"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_LINE_LAYER, "geom_line"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_POINT_LAYER, "geom_point"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_SMOOTH_LAYER, "geom_smooth"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_TEXT_LAYER, "geom_text"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_TILE_LAYER, "geom_tile"));
        list.add(new E2R(GGPlotPackage.Literals.GEOM_VIOLIN_LAYER, "geom_violin"));
        list.add(new E2R(GGPlotPackage.Literals.TEXT_STYLE, "text_theme"));
        list.add(new E2R(GGPlotPackage.Literals.GRID_FACET_LAYOUT, "facet_grid"));
        list.add(new E2R(GGPlotPackage.Literals.WRAP_FACET_LAYOUT, "facet_wrap"));
        E2R_PROPERTIES = new IntArrayMap();
        for (E2R e2r : list) {
            int id = e2r.getEClass().getClassifierID();
            E2R_PROPERTIES.put(id, (Object)e2r);
        }
        DIRECT_TYPES = ImCollections.newList((Object[])new String[]{"r", "chr"});
    }

    private static void appendMappedProperties(AbstractRCodeGenerator.FunBuilder fun, EObject obj, List<E2R.Property> properties) {
        for (E2R.Property property : properties) {
            if (!property.allowMapped()) continue;
            Object value = obj.eGet(property.getEFeature());
            fun.appendExpr(property.getRArg(), (RTypedExpr)value, "map");
        }
    }

    private static void appendDirectProperties(AbstractRCodeGenerator.FunBuilder fun, EObject obj, List<E2R.Property> properties) {
        for (E2R.Property property : properties) {
            if (!property.allowDirect()) continue;
            Object value = obj.eGet(property.getEFeature());
            fun.appendExpr(property.getRArg(), (RTypedExpr)value, DIRECT_TYPES);
        }
    }

    public void generate(EObject root) {
        this.reset();
        this.addRequirePackage("ggplot2");
        if (root == null) {
            return;
        }
        if (root.eClass().getClassifierID() != 0) {
            throw new IllegalArgumentException("root: " + root.eClass().getName());
        }
        this.appendNewLine();
        this.genRCode((GGPlot)root);
        this.appendNewLine();
        AbstractRCodeGenerator.FunBuilder printFun = this.appendFun("print");
        printFun.append(null, "p");
        printFun.close();
        this.appendNewLine();
    }

    public void genRCode(GGPlot plot) {
        this.appendAssign("p");
        E2R e2r = (E2R)E2R_PROPERTIES.get(0);
        AbstractRCodeGenerator.FunBuilder fun = this.appendFun(e2r.getRFun());
        this.appendData(fun, plot);
        this.appendAes(fun, plot, e2r);
        fun.close();
        this.appendNewLine();
        this.addFacet(plot.getFacet());
        this.addLab("title", plot.getMainTitle(), null, null);
        this.addTheme("plot.title", plot.getMainTitleStyle());
        this.addLab("x", plot.getAxXLabel(), null, null);
        this.addTheme("axis.title.x ", plot.getAxXLabelStyle());
        this.addTheme("axis.text.x ", plot.getAxXTextStyle());
        this.addLab("y", plot.getAxYLabel(), null, null);
        this.addTheme("axis.title.y ", plot.getAxYLabelStyle());
        this.addTheme("axis.text.y ", plot.getAxYTextStyle());
        EList<Layer> layers = plot.getLayers();
        for (Layer layer : layers) {
            this.appendAssign("p");
            this.builder.append("p");
            this.builder.append(" + ");
            E2R e2r2 = (E2R)E2R_PROPERTIES.get(layer.eClass().getClassifierID());
            AbstractRCodeGenerator.FunBuilder fun2 = this.appendFun(e2r2.getRFun());
            this.appendData(fun2, layer);
            this.appendAes(fun2, layer, e2r2);
            switch (layer.eClass().getClassifierID()) {
                case 5: {
                    this.appendStat(fun2, (GeomBarLayer)layer);
                    break;
                }
                case 8: {
                    this.appendStat(fun2, (GeomLineLayer)layer);
                    break;
                }
                case 9: {
                    this.appendPosition(fun2, (GeomPointLayer)layer);
                }
            }
            fun2.close();
            this.appendNewLine();
        }
    }

    private void appendData(AbstractRCodeGenerator.FunBuilder fun, PropDataProvider obj) {
        if (obj.getData() != null) {
            RTypedExpr dataFilter;
            Object expr = obj.getData().getExpr();
            if (obj instanceof GGPlot && (dataFilter = ((GGPlot)obj).getDataFilter()) != null) {
                expr = (String)expr + dataFilter.getExpr();
            }
            fun.append("data", (String)expr);
        }
    }

    private void appendAes(AbstractRCodeGenerator.FunBuilder fun, EObject obj, E2R e2r) {
        List<E2R.Property> aesProperties = e2r.getProperties();
        AbstractRCodeGenerator.FunBuilder aesFun = fun.appendFun(null, "aes");
        GGPlotRCodeGen.appendMappedProperties(aesFun, obj, aesProperties);
        aesFun.closeOrRemove();
        GGPlotRCodeGen.appendDirectProperties(fun, obj, aesProperties);
    }

    private void addFacet(FacetLayout obj) {
        AbstractRCodeGenerator.FunBuilder facetFun;
        if (obj == null) {
            return;
        }
        this.appendAssign("p");
        this.builder.append("p");
        this.builder.append(" + ");
        switch (obj.eClass().getClassifierID()) {
            case 15: {
                GridFacetLayout layout = (GridFacetLayout)obj;
                facetFun = this.appendFun("facet_grid");
                this.appendExprList((List)layout.getRowVars(), " + ", ".");
                this.builder.append(" ~ ");
                this.appendExprList((List)layout.getColVars(), " + ", ".");
                break;
            }
            case 16: {
                WrapFacetLayout layout = (WrapFacetLayout)obj;
                facetFun = this.appendFun("facet_wrap");
                this.builder.append("~ ");
                this.appendExprList((List)layout.getColVars(), " + ", ".");
                facetFun.appendExpr("ncol", ((WrapFacetLayout)obj).getColNum());
                break;
            }
            default: {
                throw new UnsupportedOperationException(obj.eClass().getName());
            }
        }
        facetFun.close();
        this.appendNewLine();
    }

    private void appendPosition(AbstractRCodeGenerator.FunBuilder fun, GeomPointLayer obj) {
        RTypedExpr xJitter = obj.getPositionXJitter();
        RTypedExpr yJitter = obj.getPositionYJitter();
        if (xJitter == null && yJitter == null) {
            return;
        }
        if (xJitter == null) {
            xJitter = R_NUM_ZERO_EXPR;
        }
        if (yJitter == null) {
            yJitter = R_NUM_ZERO_EXPR;
        }
        AbstractRCodeGenerator.FunBuilder jitterFun = fun.appendFun("position", "position_jitter");
        jitterFun.appendExpr("w", xJitter);
        jitterFun.appendExpr("h", yJitter);
        jitterFun.close();
    }

    private void appendStat(AbstractRCodeGenerator.FunBuilder fun, PropStatProvider obj) {
        Stat stat = obj.getStat();
        if (stat == null) {
            return;
        }
        switch (stat.eClass().getClassifierID()) {
            case 18: {
                fun.append("stat", "\"identity\"");
                return;
            }
            case 19: {
                fun.append("stat", "\"summary\"");
                fun.appendExpr("fun.y", ((SummaryStat)stat).getYFun());
                return;
            }
        }
    }

    private void addLab(String lab, RTypedExpr text, String lab2, RTypedExpr text2) {
        if (text == null && text2 == null) {
            return;
        }
        this.appendAssign("p");
        this.builder.append("p");
        this.builder.append(" + ");
        AbstractRCodeGenerator.FunBuilder labsFun = this.appendFun("labs");
        labsFun.appendExpr(lab, text, DIRECT_TYPES);
        if (lab2 != null) {
            labsFun.appendExpr(lab2, text2, DIRECT_TYPES);
        }
        labsFun.close();
        this.appendNewLine();
    }

    private void addTheme(String text, TextStyle obj) {
        if (obj.getFontFamily() == null && obj.getFontFace() == null && obj.getSize() == null && obj.getColor() == null && obj.getHJust() == null && obj.getVJust() == null && obj.getAngle() == null) {
            return;
        }
        E2R e2r = (E2R)E2R_PROPERTIES.get(obj.eClass().getClassifierID());
        this.appendAssign("p");
        this.builder.append("p");
        this.builder.append(" + ");
        AbstractRCodeGenerator.FunBuilder themeFun = this.appendFun("theme");
        AbstractRCodeGenerator.FunBuilder textFun = themeFun.appendFun(text, "element_text");
        GGPlotRCodeGen.appendDirectProperties(textFun, obj, e2r.getProperties());
        textFun.close();
        themeFun.close();
        this.appendNewLine();
    }

    static class E2R {
        private final EClass eClass;
        private final String rFun;
        private final List<Property> properties;

        public E2R(EClass eClass, String rFun) {
            this.eClass = eClass;
            this.rFun = rFun;
            ArrayList<Property> list = new ArrayList<Property>();
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_XVAR_PROVIDER__XVAR, "x");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_YVAR_PROVIDER__YVAR, "y");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.GEOM_TEXT_LAYER__LABEL, "label");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.GEOM_ABLINE_LAYER__INTERCEPT_VAR, "intercept");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.GEOM_ABLINE_LAYER__SLOPE_VAR, "slope");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_GROUP_VAR_PROVIDER__GROUP_VAR, "group");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_SHAPE_PROVIDER__SHAPE, "shape");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_LINE_TYPE_PROVIDER__LINE_TYPE, "linetype");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.TEXT_STYLE__FONT_FAMILY, "family");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.TEXT_STYLE__FONT_FACE, "face");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_SIZE_PROVIDER__SIZE, "size");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_COLOR_PROVIDER__COLOR, "colour");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.PROP_FILL_PROVIDER__FILL, "fill");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.TEXT_STYLE__HJUST, "hjust");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.TEXT_STYLE__VJUST, "vjust");
            this.addProperty(list, (EStructuralFeature)GGPlotPackage.Literals.TEXT_STYLE__ANGLE, "angle");
            this.properties = list;
        }

        private void addProperty(List<Property> list, EStructuralFeature eFeature, String rArg) {
            if (!this.eClass.getEAllStructuralFeatures().contains((Object)eFeature)) {
                return;
            }
            RExprTypes types = GGPlotExprTypesProvider.INSTANCE.getTypes(this.eClass, eFeature);
            boolean allowMapped = types.contains("map");
            boolean allowDirect = types.contains("r") || types.contains("chr");
            list.add(new Property(eFeature, rArg, allowMapped, allowDirect));
        }

        public EClass getEClass() {
            return this.eClass;
        }

        public String getRFun() {
            return this.rFun;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        static class Property {
            private final EStructuralFeature eFeature;
            private final String rArg;
            private final boolean allowMapped;
            private final boolean allowDirect;

            public Property(EStructuralFeature eFeature, String rArg, boolean allowMapped, boolean allowDirect) {
                this.eFeature = eFeature;
                this.rArg = rArg;
                this.allowMapped = allowMapped;
                this.allowDirect = allowDirect;
            }

            public boolean allowMapped() {
                return this.allowMapped;
            }

            public boolean allowDirect() {
                return this.allowDirect;
            }

            public String getRArg() {
                return this.rArg;
            }

            public EStructuralFeature getEFeature() {
                return this.eFeature;
            }
        }
    }
}

