/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectState;
import org.eclipse.statet.internal.rj.servi.APool2;
import org.eclipse.statet.internal.rj.servi.APool2NodeObject;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.internal.rj.servi.RServiImpl;
import org.eclipse.statet.internal.rj.servi.Stats;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.RjClosedException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.PoolNodeState;

@NonNullByDefault
public class APool2NodeHandler
extends NodeHandler
implements PoolNodeObject,
RServiImpl.PoolRef {
    private final APool2 pool;
    private final APool2NodeObject p;
    private volatile long evict;
    final Stats.NodeEntry stats = new Stats.NodeEntry();
    @Nullable Remote thisRemote;
    private volatile long accessId = -1L;
    private long allocationRenewPeriodNanos;
    private long allocationRenewTime;

    static final long safeNanos(long nanos) {
        return nanos != 0L ? nanos : 1L;
    }

    static final long evictNanos(@Nullable Duration timeout) {
        long nanos = System.nanoTime();
        if (timeout != null && !timeout.isNegative()) {
            nanos += timeout.toNanos();
        }
        return APool2NodeHandler.safeNanos(nanos);
    }

    public APool2NodeHandler(APool2 pool) {
        this.pool = pool;
        this.p = new APool2NodeObject(this);
    }

    @Override
    public NodeHandler getNodeHandler() {
        return this;
    }

    PooledObject<APool2NodeHandler> getPooledObject() {
        return this.p;
    }

    @Override
    public Instant getCreationTime() {
        return this.p.getCreateInstant();
    }

    @Override
    public long getAllocationCount() {
        return this.p.getBorrowedCount();
    }

    @Override
    public @Nullable Duration getLastestAllocationDuration() {
        return this.p.getActiveDuration();
    }

    @Override
    public PoolNodeState getState() {
        switch (this.p.getState()) {
            case IDLE: {
                return this.node == null ? PoolNodeState.INITIALIZING : PoolNodeState.IDLING;
            }
            case ALLOCATED: {
                return PoolNodeState.ALLOCATED;
            }
            case INVALID: {
                return this.node == null ? PoolNodeState.DISPOSED : PoolNodeState.DISPOSING;
            }
        }
        return PoolNodeState.CHECKING;
    }

    @Override
    public Instant getStateTime() {
        switch (this.getState()) {
            case DISPOSED: {
                return this.getShutdownTime();
            }
        }
        return this.p.getStateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bindClient(String name, String host) throws RemoteException {
        super.bindClient(name, host);
        APool2NodeHandler aPool2NodeHandler = this;
        synchronized (aPool2NodeHandler) {
            this.accessId = this.p.getBorrowedCount();
            Duration renewPeriod = this.pool.getClientAllocationRenewPeriod();
            this.allocationRenewPeriodNanos = renewPeriod != null ? renewPeriod.toNanos() : -1L;
            this.allocationRenewTime = System.nanoTime();
        }
    }

    void invalidateClient() {
        this.accessId = -1L;
        this.setClientLabel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void unbindClient() throws RemoteException {
        APool2NodeHandler aPool2NodeHandler = this;
        synchronized (aPool2NodeHandler) {
            this.invalidateClient();
        }
        super.unbindClient();
    }

    @Override
    public void evict(@Nullable Duration timeout) {
        this.doEvict(APool2NodeHandler.evictNanos(timeout), timeout == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEvict(long nanos, boolean direct) {
        APool2NodeObject aPool2NodeObject = this.p;
        synchronized (aPool2NodeObject) {
            if (this.evict == 0L || this.evict - nanos > 0L) {
                this.evict = APool2NodeHandler.safeNanos(nanos);
            }
        }
        if (direct) {
            try {
                this.pool.invalidateObject(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean isEvictRequested(long nanos) {
        long evict = this.evict;
        return evict != 0L && (nanos == 0L || nanos - evict >= 0L);
    }

    long getAccessId() {
        long accessId = this.accessId;
        if (accessId == -1L) {
            throw new IllegalAccessError();
        }
        return accessId;
    }

    @Override
    public long getCheckIntervalMillis() throws RemoteException {
        long allocationRenewPeriodNanos = this.allocationRenewPeriodNanos;
        return allocationRenewPeriodNanos != -1L ? allocationRenewPeriodNanos / 2125000L - 1000L : -1L;
    }

    @Override
    public synchronized void check(long accessId) throws RjException, RemoteException {
        if (this.accessId != accessId) {
            throw new RjClosedException("RServi instance is no longer valid.");
        }
        this.allocationRenewTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClientLost(long nanos) {
        String clientLabel;
        long allocationRenewPeriodNanos;
        if (this.accessId == -1L || (allocationRenewPeriodNanos = this.allocationRenewPeriodNanos) == -1L || nanos - this.allocationRenewTime - allocationRenewPeriodNanos < 0L || this.getPooledObject().getState() == PooledObjectState.INVALID) {
            return;
        }
        APool2NodeHandler aPool2NodeHandler = this;
        synchronized (aPool2NodeHandler) {
            long allocationRenewPeriodNanos2;
            if (this.accessId == -1L || (allocationRenewPeriodNanos2 = this.allocationRenewPeriodNanos) == -1L || nanos - this.allocationRenewTime - allocationRenewPeriodNanos2 < 0L) {
                return;
            }
            clientLabel = this.getClientLabel();
            this.doEvict(nanos, false);
        }
        Utils.logInfo(String.format("Abandoned RServi instance (client= %1$s) detected and marked for eviction.", clientLabel != null ? "'" + clientLabel + "'" : "<no label>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(long accessId) throws RjException {
        try {
            APool2NodeHandler aPool2NodeHandler = this;
            synchronized (aPool2NodeHandler) {
                if (this.accessId != accessId) {
                    throw new RjClosedException("RServi instance is no longer valid.");
                }
                this.invalidateClient();
            }
            this.pool.returnObject(this);
        }
        catch (Exception e) {
            Utils.logError("An unexpected error occurred when returning RServi instance.", e);
            throw new RjException("An unexpected error occurred when closing RServi instance. See server log for detail.");
        }
    }
}

