/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RGraphicsPlugin
extends AbstractUIPlugin {
    public static final String IMG_LOCTOOL_RESIZE_FIT_R = "org.eclipse.statet.rj.eclient.graphics/images/loctool/resize-fit-r";
    public static final String IMG_LOCTOOL_LOCATOR_DONE = "org.eclipse.statet.rj.eclient.graphics/images/loctool/locator-done";
    public static final String IMG_LOCTOOL_LOCATOR_CANCEL = "org.eclipse.statet.rj.eclient.graphics/images/loctool/locator-cancel";
    private static RGraphicsPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();

    public static RGraphicsPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RGraphicsPlugin plugin = RGraphicsPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RGraphicsPlugin rGraphicsPlugin = this;
            synchronized (rGraphicsPlugin) {
                this.started = false;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RGraphicsPlugin.log((IStatus)new Status(4, "org.eclipse.statet.rj.eclient.graphics", "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(IMG_LOCTOOL_RESIZE_FIT_R, "loctool_16", "resize-fit-r.png");
        util.register(IMG_LOCTOOL_LOCATOR_DONE, "loctool_16", "locator-done.png");
        util.register(IMG_LOCTOOL_LOCATOR_CANCEL, "loctool_16", "locator-cancel.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPluginDisposable(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        RGraphicsPlugin rGraphicsPlugin = this;
        synchronized (rGraphicsPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }
}

