/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractLogicalStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

@NonNullByDefault
public class RLogicalByte32Store
extends AbstractLogicalStore
implements RDataResizeExtension<Boolean>,
ExternalizableRStore,
Externalizable {
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;
    private int length;
    private byte[] boolValues;

    public RLogicalByte32Store() {
        this.length = 0;
        this.boolValues = EMPTY_BYTE_ARRAY;
    }

    public RLogicalByte32Store(int length) {
        this.length = length;
        this.boolValues = new byte[length];
    }

    public RLogicalByte32Store(boolean[] values) {
        this.length = values.length;
        this.boolValues = new byte[values.length];
        int i = values.length - 1;
        while (i >= 0) {
            this.boolValues[i] = values[i] ? (byte)1 : 0;
            --i;
        }
    }

    public RLogicalByte32Store(boolean[] values, int @Nullable [] naIdxs) {
        this.length = values.length;
        this.boolValues = new byte[values.length];
        int i = values.length - 1;
        while (i >= 0) {
            this.boolValues[i] = values[i] ? (byte)1 : 0;
            --i;
        }
        if (naIdxs != null) {
            i = 0;
            while (i < naIdxs.length) {
                this.boolValues[naIdxs[i]] = 2;
                ++i;
            }
        }
    }

    public RLogicalByte32Store(boolean[] values, boolean @Nullable [] isNAs) {
        this.length = values.length;
        this.boolValues = new byte[values.length];
        int i = values.length - 1;
        while (i >= 0) {
            this.boolValues[i] = values[i] ? (byte)1 : 0;
            --i;
        }
        if (isNAs != null) {
            if (isNAs.length != this.length) {
                throw new IllegalArgumentException();
            }
            i = 0;
            while (i < isNAs.length) {
                if (isNAs[i]) {
                    this.boolValues[i] = 2;
                }
                ++i;
            }
        }
    }

    public RLogicalByte32Store(byte[] values) {
        this.length = values.length;
        this.boolValues = values;
    }

    public RLogicalByte32Store(byte[] values, byte trueCode, byte naCode) {
        this.length = values.length;
        if (trueCode != 1 || naCode != 2) {
            int i = values.length - 1;
            while (i >= 0) {
                byte value = values[i];
                values[i] = value == trueCode ? 1 : (value == naCode ? 2 : 0);
                --i;
            }
        }
        this.boolValues = values;
    }

    public RLogicalByte32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.boolValues = io.readByteData(new byte[length], length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeByteData(this.boolValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.boolValues = new byte[this.length];
        in.readFully(this.boolValues, 0, this.length);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.boolValues, 0, this.length);
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.boolValues[idx] == 2;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] == 2;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.boolValues[idx] == 2;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] == 2;
    }

    @Override
    public void setNA(int idx) {
        this.boolValues[idx] = 2;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.boolValues[(int)idx] = 2;
    }

    @Override
    public boolean getLogi(int idx) {
        return this.boolValues[idx] == 1;
    }

    @Override
    public boolean getLogi(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.boolValues[(int)idx] == 1;
    }

    @Override
    public void setLogi(int idx, boolean value) {
        this.boolValues[idx] = value ? (byte)1 : 0;
    }

    @Override
    public void setLogi(long idx, boolean value) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.boolValues[(int)idx] = value ? (byte)1 : 0;
    }

    private void prepareInsert(int[] idxs) {
        this.boolValues = RLogicalByte32Store.prepareInsert(this.boolValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertLogi(int idx, boolean value) {
        this.prepareInsert(new int[]{idx});
        this.boolValues[idx] = value ? (byte)1 : 0;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.boolValues[idx] = 2;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.boolValues[idxs[idx] + idx] = 2;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.boolValues = RLogicalByte32Store.remove(this.boolValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.boolValues = RLogicalByte32Store.remove(this.boolValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public @Nullable Boolean get(int idx) {
        if (idx < 0 || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        switch (this.boolValues[idx]) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public @Nullable Boolean get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        switch (this.boolValues[(int)idx]) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public @Nullable Boolean[] toArray() {
        Boolean[] array = new Boolean[this.length];
        byte[] bools = this.boolValues;
        int i = 0;
        while (i < array.length) {
            switch (bools[i]) {
                case 1: {
                    array[i] = Boolean.TRUE;
                    break;
                }
                case 0: {
                    array[i] = Boolean.FALSE;
                    break;
                }
            }
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        long l = this.getLength();
        byte[] bools = this.boolValues;
        int i = (int)fromIdx;
        while ((long)i < l) {
            if (bools[i] == 2) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE || integer == Integer.MIN_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length;
        byte[] bools = this.boolValues;
        if (integer != 0) {
            int i = (int)fromIdx;
            while (i < l) {
                if (bools[i] == 1) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = (int)fromIdx;
            while (i < l) {
                if (bools[i] == 0) {
                    return i;
                }
                ++i;
            }
        }
        return -1L;
    }
}

