/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class RJIO {
    private static final ThreadLocal<RJIO> INSTANCES = new ThreadLocal<RJIO>(){

        @Override
        protected RJIO initialValue() {
            return new RJIO();
        }
    };
    private static final int BB_LENGTH = 16384;
    private static final int BA_LENGTH = 16384;
    private static final int BB_PART = 4096;
    private static final int CB_LENGTH = 8192;
    private static final int CA_LENGTH = 65536;
    private static final int IB_LENGTH = 4096;
    private static final int DB_LENGTH = 2048;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte MODE_BBARRAY = 0;
    private static final byte MODE_IPARRAY = 1;
    private final ByteBuffer bb;
    private final byte[] ba;
    private final CharBuffer cb;
    private final char[] ca;
    private final IntBuffer ib;
    private final DoubleBuffer db;
    private final byte mode;
    private ObjectInput in = (ObjectInput)ObjectUtils.nonNullLateInit();
    private ObjectOutput out = (ObjectOutput)ObjectUtils.nonNullLateInit();
    private int temp;
    public int flags;
    private int serialKey;

    public static RJIO get(ObjectOutput out) {
        RJIO io = INSTANCES.get();
        io.connect(out);
        return io;
    }

    public static RJIO get(ObjectInput in) {
        RJIO io = INSTANCES.get();
        io.connect(in);
        return io;
    }

    public RJIO() {
        this.bb = ByteBuffer.allocateDirect(16384);
        if (this.bb.hasArray()) {
            this.mode = 0;
            this.ba = this.bb.array();
        } else {
            this.mode = 1;
            this.ba = new byte[16384];
        }
        this.cb = this.bb.asCharBuffer();
        this.ca = new char[65536];
        this.ib = this.bb.asIntBuffer();
        this.db = this.bb.asDoubleBuffer();
        this.serialKey = (int)System.currentTimeMillis();
    }

    public void connect(ObjectOutput out) {
        this.out = out;
    }

    public void connect(ObjectInput in) {
        this.in = in;
    }

    public void disconnect(ObjectOutput out) throws IOException {
        this.out.flush();
        this.out = null;
    }

    public void disconnect(ObjectInput in) throws IOException {
        this.in = null;
    }

    private void writeFullyBB(int bn) throws IOException {
        switch (this.mode) {
            case 0: {
                this.out.write(this.ba, 0, bn);
                return;
            }
        }
        this.bb.clear();
        this.bb.get(this.ba, 0, bn);
        this.out.write(this.ba, 0, bn);
    }

    private void readFullyBB(int bn) throws IOException {
        switch (this.mode) {
            case 0: {
                this.in.readFully(this.ba, 0, bn);
                return;
            }
        }
        this.in.readFully(this.ba, 0, bn);
        this.bb.clear();
        this.bb.put(this.ba, 0, bn);
    }

    private void readFullyBB(int pos, int bn) throws IOException {
        switch (this.mode) {
            case 0: {
                this.in.readFully(this.ba, pos, bn);
                return;
            }
        }
        this.in.readFully(this.ba, pos, bn);
        this.bb.clear();
        this.bb.put(this.ba, 0, pos + bn);
    }

    public void writeDirectly(byte[] bytes, int off, int n) throws IOException {
        this.out.write(bytes, off, n);
    }

    public void writeByte(byte value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeByte(int value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.out.writeByte(value ? 1 : 0);
    }

    public void writeInt(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeIntArray(int[] array, int length) throws IOException {
        ObjectOutput out = this.out;
        out.writeInt(length);
        if (length <= 32) {
            int i = 0;
            while (i < length) {
                out.writeInt(array[i]);
                ++i;
            }
        } else if (length <= 4096) {
            this.ib.clear();
            this.ib.put(array, 0, length);
            this.writeFullyBB(length << 2);
        } else {
            int iw = 0;
            while (iw < length) {
                int icount = Math.min(length - iw, 4096);
                this.ib.clear();
                this.ib.put(array, iw, icount);
                this.writeFullyBB(icount << 2);
                iw += icount;
            }
        }
    }

    public void writeIntData(int[] array, int length) throws IOException {
        ObjectOutput out = this.out;
        if (length <= 32) {
            int i = 0;
            while (i < length) {
                out.writeInt(array[i]);
                ++i;
            }
        } else if (length <= 4096) {
            this.ib.clear();
            this.ib.put(array, 0, length);
            this.writeFullyBB(length << 2);
        } else {
            int iw = 0;
            while (iw < length) {
                int icount = Math.min(length - iw, 4096);
                this.ib.clear();
                this.ib.put(array, iw, icount);
                this.writeFullyBB(icount << 2);
                iw += icount;
            }
        }
    }

    public void writeLong(long value) throws IOException {
        this.out.writeLong(value);
    }

    public byte getVULongGrade(long value) {
        if ((value & 0xFFFFFFFFFFFFFF00L) == 0L) {
            return 0;
        }
        if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFF000000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFF0000000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFF000000000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 6;
        }
        return 7;
    }

    public void writeVULong(byte grade, long value) throws IOException {
        if (grade == 0) {
            this.out.writeByte((int)value);
            return;
        }
        byte[] ba = this.ba;
        switch (grade) {
            case 1: {
                ba[0] = (byte)(value >>> 8);
                ba[1] = (byte)value;
                this.out.write(ba, 0, 2);
                return;
            }
            case 2: {
                ba[0] = (byte)(value >>> 16);
                ba[1] = (byte)(value >>> 8);
                ba[2] = (byte)value;
                this.out.write(ba, 0, 3);
                return;
            }
            case 3: {
                ba[0] = (byte)(value >>> 24);
                ba[1] = (byte)(value >>> 16);
                ba[2] = (byte)(value >>> 8);
                ba[3] = (byte)value;
                this.out.write(ba, 0, 4);
                return;
            }
            case 4: {
                ba[0] = (byte)(value >>> 32);
                ba[1] = (byte)(value >>> 24);
                ba[2] = (byte)(value >>> 16);
                ba[3] = (byte)(value >>> 8);
                ba[4] = (byte)value;
                this.out.write(ba, 0, 5);
                return;
            }
            case 5: {
                ba[0] = (byte)(value >>> 40);
                ba[1] = (byte)(value >>> 32);
                ba[2] = (byte)(value >>> 24);
                ba[3] = (byte)(value >>> 16);
                ba[4] = (byte)(value >>> 8);
                ba[5] = (byte)value;
                this.out.write(ba, 0, 6);
                return;
            }
            case 6: {
                ba[0] = (byte)(value >>> 48);
                ba[1] = (byte)(value >>> 40);
                ba[2] = (byte)(value >>> 32);
                ba[3] = (byte)(value >>> 24);
                ba[4] = (byte)(value >>> 16);
                ba[5] = (byte)(value >>> 8);
                ba[6] = (byte)value;
                this.out.write(ba, 0, 7);
                return;
            }
            case 7: {
                ba[0] = (byte)(value >>> 56);
                ba[1] = (byte)(value >>> 48);
                ba[2] = (byte)(value >>> 40);
                ba[3] = (byte)(value >>> 32);
                ba[4] = (byte)(value >>> 24);
                ba[5] = (byte)(value >>> 16);
                ba[6] = (byte)(value >>> 8);
                ba[7] = (byte)value;
                this.out.write(ba, 0, 8);
                return;
            }
        }
        throw new IOException("Unsupported data format (c= " + grade + ").");
    }

    public void writeDouble(double value) throws IOException {
        this.out.writeDouble(value);
    }

    public void writeDoubleData(double[] array, int length) throws IOException {
        ObjectOutput out = this.out;
        if (length <= 16) {
            int i = 0;
            while (i < length) {
                out.writeLong(Double.doubleToRawLongBits(array[i]));
                ++i;
            }
        } else if (length <= 2048) {
            this.db.clear();
            this.db.put(array, 0, length);
            this.writeFullyBB(length << 3);
        } else {
            int dw = 0;
            while (dw < length) {
                int dcount = Math.min(length - dw, 2048);
                this.db.clear();
                this.db.put(array, dw, dcount);
                this.writeFullyBB(dcount << 3);
                dw += dcount;
            }
        }
    }

    public void writeFloat(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeByteData(byte[] array, int length) throws IOException {
        ObjectOutput out = this.out;
        out.write(array, 0, length);
    }

    public void writeString(@Nullable String s) throws IOException {
        int cn;
        ObjectOutput out;
        block5: {
            out = this.out;
            if (s == null) {
                out.writeInt(Integer.MIN_VALUE);
                return;
            }
            cn = s.length();
            if (cn <= 16384) {
                int ci = 0;
                while (ci < cn) {
                    if ((s.charAt(ci++) & 0xFFFFFF00) == 0) {
                        continue;
                    }
                    break block5;
                }
                if (cn <= 8) {
                    out.writeInt(-cn);
                    out.writeBytes(s);
                    return;
                }
                out.writeInt(-cn);
                s.getBytes(0, cn, this.ba, 0);
                out.write(this.ba, 0, cn);
                return;
            }
        }
        out.writeInt(cn);
        out.writeChars(s);
    }

    public void writeStringUtf8(byte @Nullable [] bytes) throws IOException {
        int cn;
        String s;
        ObjectOutput out;
        block8: {
            block7: {
                out = this.out;
                if (bytes == null) {
                    out.writeInt(Integer.MIN_VALUE);
                    return;
                }
                int bn = bytes.length;
                int bi = 0;
                while (bi < bn) {
                    if ((bytes[bi] & 0xFFFFFF80) == 0) {
                        ++bi;
                        continue;
                    }
                    break block7;
                }
                out.writeInt(-bn);
                out.write(bytes);
                return;
            }
            s = new String(bytes, StandardCharsets.UTF_8);
            cn = s.length();
            if (cn <= 16384) {
                int ci = 0;
                while (ci < cn) {
                    if ((s.charAt(ci++) & 0xFFFFFF00) == 0) {
                        continue;
                    }
                    break block8;
                }
                if (cn <= 8) {
                    out.writeInt(-cn);
                    out.writeBytes(s);
                    return;
                }
                out.writeInt(-cn);
                s.getBytes(0, cn, this.ba, 0);
                out.write(this.ba, 0, cn);
                return;
            }
        }
        out.writeInt(cn);
        out.writeChars(s);
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringData(@Nullable String[] array, int length) throws IOException {
        out = this.out;
        i = 0;
        while (i < length) {
            s = array[i];
            if (s == null) {
                out.writeInt(-2147483648);
            } else {
                cn = s.length();
                if (cn <= 16384) {
                    ci = 0;
                    while (ci < cn) {
                        if ((s.charAt(ci++) & -256) == 0) {
                            continue;
                        }
                        ** break block9
                    }
                    if (cn <= 8) {
                        out.writeInt(-cn);
                        out.writeBytes(s);
                    } else {
                        out.writeInt(-cn);
                        s.getBytes(0, cn, this.ba, 0);
                        out.write(this.ba, 0, cn);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    out.writeInt(cn);
                    out.writeChars(s);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeStringDataUtf8(byte[] @Nullable [] array, int length) throws IOException {
        ObjectOutput out = this.out;
        int i = 0;
        while (i < length) {
            block11: {
                int cn;
                String s;
                block9: {
                    block10: {
                        byte[] bytes = array[i];
                        if (bytes == null) {
                            out.writeInt(Integer.MIN_VALUE);
                        } else {
                            int bn = bytes.length;
                            int bi = 0;
                            while (bi < bn) {
                                if ((bytes[bi] & 0xFFFFFF80) != 0) {
                                    s = new String(bytes, StandardCharsets.UTF_8);
                                    cn = s.length();
                                    if (cn > 16384) break block9;
                                    break block10;
                                }
                                ++bi;
                            }
                            out.writeInt(-bn);
                            out.write(bytes);
                        }
                        break block11;
                    }
                    int ci = 0;
                    while (ci < cn) {
                        if ((s.charAt(ci++) & 0xFFFFFF00) == 0) {
                            continue;
                        }
                        break block9;
                    }
                    if (cn <= 8) {
                        out.writeInt(-cn);
                        out.writeBytes(s);
                        break block11;
                    } else {
                        out.writeInt(-cn);
                        s.getBytes(0, cn, this.ba, 0);
                        out.write(this.ba, 0, cn);
                    }
                    break block11;
                }
                out.writeInt(cn);
                out.writeChars(s);
            }
            ++i;
        }
    }

    public void writeStringKeyMap(@Nullable Map<String, @Nullable Object> map) throws IOException {
        ObjectOutput out = this.out;
        if (map == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.writeString(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public int[] readIntData(int[] array, int length) throws IOException {
        ObjectInput in = this.in;
        if (length <= 256) {
            switch (length) {
                case 0: {
                    return array;
                }
                case 1: {
                    array[0] = in.readInt();
                    return array;
                }
                case 2: {
                    array[0] = in.readInt();
                    array[1] = in.readInt();
                    return array;
                }
                case 3: {
                    array[0] = in.readInt();
                    array[1] = in.readInt();
                    array[2] = in.readInt();
                    return array;
                }
                case 4: {
                    array[0] = in.readInt();
                    array[1] = in.readInt();
                    array[2] = in.readInt();
                    array[3] = in.readInt();
                    return array;
                }
            }
            int bn = length << 2;
            in.readFully(this.ba, 0, bn);
            int ib = 0;
            while (ib < bn) {
                array[ib >>> 2] = (this.ba[ib] & 0xFF) << 24 | (this.ba[ib + 1] & 0xFF) << 16 | (this.ba[ib + 2] & 0xFF) << 8 | this.ba[ib + 3] & 0xFF;
                ib += 4;
            }
            return array;
        }
        if (length <= 4096) {
            this.readFullyBB(length << 2);
            this.ib.clear();
            this.ib.get(array, 0, length);
            return array;
        }
        int ir = 0;
        int position = 0;
        while (true) {
            if ((position += in.read(this.ba, position, 16384 - position)) < 4096) {
                continue;
            }
            int icount = position >>> 2;
            int bcount = icount << 2;
            if (this.mode != 0) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bcount);
            }
            this.ib.clear();
            this.ib.get(array, ir, icount);
            ir += icount;
            switch (position - bcount) {
                case 0: {
                    position = 0;
                    break;
                }
                case 1: {
                    this.ba[0] = this.ba[bcount];
                    position = 1;
                    break;
                }
                case 2: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    position = 2;
                    break;
                }
                case 3: {
                    array[ir++] = (this.ba[bcount] & 0xFF) << 24 | (this.ba[bcount + 1] & 0xFF) << 16 | (this.ba[bcount + 2] & 0xFF) << 8 | in.readByte() & 0xFF;
                    position = 0;
                }
            }
            if (length - ir <= 4096) break;
        }
        int bToComplete = length - ir << 2;
        if (bToComplete > 0) {
            this.readFullyBB(position, bToComplete - position);
            this.ib.clear();
            this.ib.get(array, ir, bToComplete >>> 2);
        }
        return array;
    }

    public int @Nullable [] readIntArray() throws IOException {
        ObjectInput in = this.in;
        int length = in.readInt();
        if (length <= 256) {
            switch (length) {
                case -1: {
                    return null;
                }
                case 0: {
                    return EMPTY_INT_ARRAY;
                }
                case 1: {
                    return new int[]{in.readInt()};
                }
                case 2: {
                    return new int[]{in.readInt(), in.readInt()};
                }
                case 3: {
                    return new int[]{in.readInt(), in.readInt(), in.readInt()};
                }
                case 4: {
                    return new int[]{in.readInt(), in.readInt(), in.readInt(), in.readInt()};
                }
            }
            int bn = length << 2;
            in.readFully(this.ba, 0, bn);
            int[] array = new int[length];
            int ib = 0;
            while (ib < bn) {
                array[ib >>> 2] = (this.ba[ib] & 0xFF) << 24 | (this.ba[ib + 1] & 0xFF) << 16 | (this.ba[ib + 2] & 0xFF) << 8 | this.ba[ib + 3] & 0xFF;
                ib += 4;
            }
            return array;
        }
        if (length <= 4096) {
            this.readFullyBB(length << 2);
            int[] array = new int[length];
            this.ib.clear();
            this.ib.get(array, 0, length);
            return array;
        }
        int[] array = new int[length];
        int ir = 0;
        int position = 0;
        while (true) {
            if ((position += in.read(this.ba, position, 16384 - position)) < 4096) {
                continue;
            }
            int icount = position >>> 2;
            int bcount = icount << 2;
            if (this.mode != 0) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bcount);
            }
            this.ib.clear();
            this.ib.get(array, ir, icount);
            ir += icount;
            switch (position - bcount) {
                case 0: {
                    position = 0;
                    break;
                }
                case 1: {
                    this.ba[0] = this.ba[bcount];
                    position = 1;
                    break;
                }
                case 2: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    position = 2;
                    break;
                }
                case 3: {
                    array[ir++] = (this.ba[bcount] & 0xFF) << 24 | (this.ba[bcount + 1] & 0xFF) << 16 | (this.ba[bcount + 2] & 0xFF) << 8 | in.readByte() & 0xFF;
                    position = 0;
                }
            }
            if (length - ir <= 4096) break;
        }
        int bToComplete = length - ir << 2;
        if (bToComplete > 0) {
            this.readFullyBB(position, bToComplete - position);
            this.ib.clear();
            this.ib.get(array, ir, bToComplete >>> 2);
        }
        return array;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public long readVULong(byte grade) throws IOException {
        if (grade == 0) {
            return this.in.readUnsignedByte();
        }
        byte[] ba = this.ba;
        switch (grade) {
            case 1: {
                this.in.read(ba, 0, 2);
                return (ba[0] & 0xFF) << 8 | ba[1] & 0xFF;
            }
            case 2: {
                this.in.read(ba, 0, 3);
                return (ba[0] & 0xFF) << 16 | (ba[1] & 0xFF) << 8 | ba[2] & 0xFF;
            }
            case 3: {
                this.in.read(ba, 0, 4);
                return (long)(ba[0] & 0xFF) << 24 | (long)((ba[1] & 0xFF) << 16) | (long)((ba[2] & 0xFF) << 8) | (long)(ba[3] & 0xFF);
            }
            case 4: {
                this.in.read(ba, 0, 5);
                return (long)(ba[0] & 0xFF) << 32 | (long)(ba[1] & 0xFF) << 24 | (long)((ba[2] & 0xFF) << 16) | (long)((ba[3] & 0xFF) << 8) | (long)(ba[4] & 0xFF);
            }
            case 5: {
                this.in.read(ba, 0, 6);
                return (long)(ba[0] & 0xFF) << 40 | (long)(ba[1] & 0xFF) << 32 | (long)(ba[2] & 0xFF) << 24 | (long)((ba[3] & 0xFF) << 16) | (long)((ba[4] & 0xFF) << 8) | (long)(ba[5] & 0xFF);
            }
            case 6: {
                this.in.read(ba, 0, 7);
                return (long)(ba[0] & 0xFF) << 48 | (long)(ba[1] & 0xFF) << 40 | (long)(ba[2] & 0xFF) << 32 | (long)(ba[3] & 0xFF) << 24 | (long)((ba[4] & 0xFF) << 16) | (long)((ba[5] & 0xFF) << 8) | (long)(ba[6] & 0xFF);
            }
            case 7: {
                this.in.read(ba, 0, 8);
                return (long)(ba[0] & 0xFF) << 56 | (long)(ba[1] & 0xFF) << 48 | (long)(ba[2] & 0xFF) << 40 | (long)(ba[3] & 0xFF) << 32 | (long)(ba[4] & 0xFF) << 24 | (long)((ba[5] & 0xFF) << 16) | (long)((ba[6] & 0xFF) << 8) | (long)(ba[7] & 0xFF);
            }
        }
        throw new IOException("Unsupported data format (c= " + grade + ").");
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public double[] readDoubleData(double[] array, int length) throws IOException {
        ObjectInput in = this.in;
        if (length <= 32) {
            switch (length) {
                case 0: {
                    return array;
                }
                case 1: {
                    array[0] = Double.longBitsToDouble(in.readLong());
                    return array;
                }
                case 2: {
                    array[0] = Double.longBitsToDouble(in.readLong());
                    array[1] = Double.longBitsToDouble(in.readLong());
                    return array;
                }
            }
            int bn = length << 3;
            in.readFully(this.ba, 0, bn);
            int db = 0;
            while (db < bn) {
                array[db >>> 3] = Double.longBitsToDouble((long)(this.ba[db] & 0xFF) << 56 | (long)(this.ba[db + 1] & 0xFF) << 48 | (long)(this.ba[db + 2] & 0xFF) << 40 | (long)(this.ba[db + 3] & 0xFF) << 32 | (long)(this.ba[db + 4] & 0xFF) << 24 | (long)((this.ba[db + 5] & 0xFF) << 16) | (long)((this.ba[db + 6] & 0xFF) << 8) | (long)(this.ba[db + 7] & 0xFF));
                db += 8;
            }
            return array;
        }
        if (length <= 2048) {
            this.readFullyBB(length << 3);
            this.db.clear();
            this.db.get(array, 0, length);
            return array;
        }
        int dr = 0;
        int position = 0;
        while (true) {
            if ((position += in.read(this.ba, position, 16384 - position)) < 4096) {
                continue;
            }
            int dcount = position >>> 3;
            int bcount = dcount << 3;
            if (this.mode != 0) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bcount);
            }
            this.db.clear();
            this.db.get(array, dr, dcount);
            dr += dcount;
            switch (position - bcount) {
                case 0: {
                    position = 0;
                    break;
                }
                case 1: {
                    this.ba[0] = this.ba[bcount];
                    position = 1;
                    break;
                }
                case 2: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    position = 2;
                    break;
                }
                case 3: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    this.ba[2] = this.ba[bcount + 2];
                    position = 3;
                    break;
                }
                case 4: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    this.ba[2] = this.ba[bcount + 2];
                    this.ba[3] = this.ba[bcount + 3];
                    position = 4;
                    break;
                }
                case 5: {
                    this.ba[0] = this.ba[bcount];
                    this.ba[1] = this.ba[bcount + 1];
                    this.ba[2] = this.ba[bcount + 2];
                    this.ba[3] = this.ba[bcount + 3];
                    this.ba[4] = this.ba[bcount + 4];
                    position = 5;
                    break;
                }
                case 6: {
                    array[dr++] = Double.longBitsToDouble((long)(this.ba[bcount] & 0xFF) << 56 | (long)(this.ba[bcount + 1] & 0xFF) << 48 | (long)(this.ba[bcount + 2] & 0xFF) << 40 | (long)(this.ba[bcount + 3] & 0xFF) << 32 | (long)(this.ba[bcount + 4] & 0xFF) << 24 | (long)((this.ba[bcount + 5] & 0xFF) << 16) | (long)((in.readByte() & 0xFF) << 8) | (long)(in.readByte() & 0xFF));
                    position = 0;
                    break;
                }
                case 7: {
                    array[dr++] = Double.longBitsToDouble((long)(this.ba[bcount] & 0xFF) << 56 | (long)(this.ba[bcount + 1] & 0xFF) << 48 | (long)(this.ba[bcount + 2] & 0xFF) << 40 | (long)(this.ba[bcount + 3] & 0xFF) << 32 | (long)(this.ba[bcount + 4] & 0xFF) << 24 | (long)((this.ba[bcount + 5] & 0xFF) << 16) | (long)((this.ba[bcount + 6] & 0xFF) << 8) | (long)(in.readByte() & 0xFF));
                    position = 0;
                }
            }
            if (length - dr <= 2048) break;
        }
        int bToComplete = length - dr << 3;
        if (bToComplete > 0) {
            this.readFullyBB(position, bToComplete - position);
            this.db.clear();
            this.db.get(array, dr, bToComplete >>> 3);
        }
        return array;
    }

    public double[] readDoubleArray() throws IOException {
        int l = this.temp = this.in.readInt();
        return this.readDoubleData(new double[l], l);
    }

    public double[] readDoubleArray2() throws IOException {
        int l = this.temp;
        return this.readDoubleData(new double[l], l);
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public byte[] readByteData(byte[] array, int length) throws IOException {
        this.in.readFully(array, 0, length);
        return array;
    }

    public byte[] readByteArray() throws IOException {
        int l = this.temp = this.in.readInt();
        return this.readByteData(new byte[l], l);
    }

    public byte[] readByteArray2() throws IOException {
        int l = this.temp;
        return this.readByteData(new byte[l], l);
    }

    private String readString(int cn, char[] ca, ObjectInput in) throws IOException {
        int cr = 0;
        int position = 0;
        while (true) {
            if ((position += in.read(this.ba, position, 16384 - position)) < 4096) {
                continue;
            }
            int icount = position >>> 1;
            int bcount = icount << 1;
            if (this.mode != 0) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bcount);
            }
            this.cb.clear();
            this.cb.get(ca, cr, icount);
            cr += icount;
            if (position - bcount != 0) {
                ca[cr++] = (char)((this.ba[bcount] & 0xFF) << 8 | in.readByte() & 0xFF);
            }
            position = 0;
            if (cn - cr <= 8192) break;
        }
        int bToComplete = cn - cr << 1;
        if (bToComplete > 0) {
            this.readFullyBB(position, bToComplete - position);
            this.cb.clear();
            this.cb.get(ca, cr, bToComplete >>> 1);
        }
        return new String(ca, 0, cn);
    }

    public @Nullable String readString() throws IOException {
        ObjectInput in = this.in;
        int cn = in.readInt();
        switch (cn) {
            case -2147483648: {
                return null;
            }
            case 0: {
                return "";
            }
        }
        if (cn > 0) {
            if (cn <= 64) {
                int ci = 0;
                while (ci < cn) {
                    this.ca[ci] = in.readChar();
                    ++ci;
                }
                return new String(this.ca, 0, cn);
            }
            if (cn <= 8192) {
                this.readFullyBB(cn << 1);
                this.cb.clear();
                this.cb.get(this.ca, 0, cn);
                return new String(this.ca, 0, cn);
            }
            if (cn <= 65536) {
                return this.readString(cn, this.ca, in);
            }
            return this.readString(cn, new char[cn], in);
        }
        int bn = -cn;
        if (bn <= 16384) {
            in.readFully(this.ba, 0, bn);
            return new String(this.ba, 0, 0, bn);
        }
        byte[] bytes = new byte[bn];
        in.readFully(bytes, 0, bn);
        return new String(bytes, 0, 0, bn);
    }

    public byte @Nullable [] readStringUtf8() throws IOException {
        byte[] bytes;
        int bn;
        block15: {
            ObjectInput in = this.in;
            int cn = in.readInt();
            switch (cn) {
                case -2147483648: {
                    return null;
                }
                case 0: {
                    return EMPTY_BYTE_ARRAY;
                }
            }
            if (cn > 0) {
                if (cn <= 64) {
                    int ci = 0;
                    while (ci < cn) {
                        this.ca[ci] = in.readChar();
                        ++ci;
                    }
                    return new String(this.ca, 0, cn).getBytes(StandardCharsets.UTF_8);
                }
                if (cn <= 8192) {
                    this.readFullyBB(cn << 1);
                    this.cb.clear();
                    this.cb.get(this.ca, 0, cn);
                    return new String(this.ca, 0, cn).getBytes(StandardCharsets.UTF_8);
                }
                if (cn <= 65536) {
                    return this.readString(cn, this.ca, in).getBytes(StandardCharsets.UTF_8);
                }
                return this.readString(cn, new char[cn], in).getBytes(StandardCharsets.UTF_8);
            }
            bn = -cn;
            if (bn <= 16384) {
                block14: {
                    in.readFully(this.ba, 0, bn);
                    int bi = 0;
                    while (bi < bn) {
                        if ((this.ba[bi] & 0xFFFFFF80) == 0) {
                            ++bi;
                            continue;
                        }
                        break block14;
                    }
                    byte[] bytes2 = new byte[bn];
                    System.arraycopy(this.ba, 0, bytes2, 0, bn);
                    return bytes2;
                }
                return new String(this.ba, 0, 0, bn).getBytes(StandardCharsets.UTF_8);
            }
            bytes = new byte[bn];
            in.readFully(bytes, 0, bn);
            int bi = 0;
            while (bi < bn) {
                if ((bytes[bi] & 0xFFFFFF80) == 0) {
                    ++bi;
                    continue;
                }
                break block15;
            }
            return bytes;
        }
        return new String(bytes, 0, 0, bn).getBytes(StandardCharsets.UTF_8);
    }

    public void readStringData(@Nullable String[] array, int length) throws IOException {
        ObjectInput in = this.in;
        int i = 0;
        while (i < length) {
            int cn = in.readInt();
            switch (cn) {
                case -2147483648: {
                    break;
                }
                case 0: {
                    array[i] = "";
                    break;
                }
                default: {
                    if (cn > 0) {
                        if (cn <= 64) {
                            int ci = 0;
                            while (ci < cn) {
                                this.ca[ci] = in.readChar();
                                ++ci;
                            }
                            array[i] = new String(this.ca, 0, cn);
                            break;
                        }
                        if (cn <= 8192) {
                            this.readFullyBB(cn << 1);
                            this.cb.clear();
                            this.cb.get(this.ca, 0, cn);
                            array[i] = new String(this.ca, 0, cn);
                            break;
                        }
                        if (cn <= 65536) {
                            array[i] = this.readString(cn, this.ca, in);
                            break;
                        }
                        array[i] = this.readString(cn, new char[cn], in);
                        break;
                    }
                    int bn = -cn;
                    if (bn <= 16384) {
                        in.readFully(this.ba, 0, bn);
                        array[i] = new String(this.ba, 0, 0, bn);
                        break;
                    }
                    byte[] bytes = new byte[bn];
                    in.readFully(bytes, 0, bn);
                    array[i] = new String(bytes, 0, 0, bn);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void readStringDataUtf8(byte[] @Nullable [] array, int length) throws IOException {
        in = this.in;
        i = 0;
        while (i < length) {
            cn = in.readInt();
            switch (cn) {
                case -2147483648: {
                    break;
                }
                case 0: {
                    array[i] = RJIO.EMPTY_BYTE_ARRAY;
                    break;
                }
                default: {
                    if (cn > 0) {
                        if (cn <= 64) {
                            ci = 0;
                            while (ci < cn) {
                                this.ca[ci] = in.readChar();
                                ++ci;
                            }
                            array[i] = new String(this.ca, 0, cn).getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        if (cn <= 8192) {
                            this.readFullyBB(cn << 1);
                            this.cb.clear();
                            this.cb.get(this.ca, 0, cn);
                            array[i] = new String(this.ca, 0, cn).getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        if (cn <= 65536) {
                            array[i] = this.readString(cn, this.ca, in).getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        array[i] = this.readString(cn, new char[cn], in).getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    bn = -cn;
                    if (bn > 16384) ** GOTO lbl49
                    in.readFully(this.ba, 0, bn);
                    bi = 0;
                    while (bi < bn) {
                        if ((this.ba[bi] & -128) == 0) {
                            ++bi;
                            continue;
                        }
                        ** GOTO lbl47
                    }
                    bytes = new byte[bn];
                    System.arraycopy(this.ba, 0, bytes, 0, bn);
                    array[i] = bytes;
                    break;
lbl47:
                    // 1 sources

                    array[i] = new String(this.ba, 0, 0, bn).getBytes(StandardCharsets.UTF_8);
                    break;
lbl49:
                    // 1 sources

                    bytes = new byte[bn];
                    in.readFully(bytes, 0, bn);
                    bi = 0;
                    while (bi < bn) {
                        if ((bytes[bi] & -128) == 0) {
                            ++bi;
                            continue;
                        }
                        ** GOTO lbl59
                    }
                    array[i] = bytes;
                    break;
lbl59:
                    // 1 sources

                    array[i] = new String(bytes, 0, 0, bn).getBytes(StandardCharsets.UTF_8);
                }
            }
            ++i;
        }
    }

    public @Nullable HashMap<String, Object> readStringKeyHashMap() throws IOException {
        ObjectInput in = this.in;
        int length = in.readInt();
        if (length < 0) {
            return null;
        }
        try {
            HashMap<String, @Nullable Object> map = new HashMap<String, Object>(length);
            int i = 0;
            while (i < length) {
                map.put(this.readString(), in.readObject());
                ++i;
            }
            return map;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int writeCheck1() throws IOException {
        this.out.writeInt(++this.serialKey);
        return this.serialKey;
    }

    public void writeCheck2(int check) throws IOException {
        this.out.writeInt(check);
    }

    public int readCheck1() throws IOException {
        return this.in.readInt();
    }

    public void readCheck2(int check) throws IOException {
        if (check != this.in.readInt()) {
            throw new IOException("Corrupted stream detected.");
        }
    }
}

