/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.client;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.graphic.core.RGraphic;
import org.eclipse.statet.rj.server.client.AbstractRJComClient;
import org.eclipse.statet.rj.server.client.RClientGraphic;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RGraphicCreator;
import org.eclipse.statet.rj.services.RService;

public class RGraphicCreatorImpl
implements RGraphicCreator {
    private final RService service;
    private final AbstractRJComClient rjs;
    private int options;
    private double width = -1.0;
    private double height = -1.0;

    public RGraphicCreatorImpl(RService service, AbstractRJComClient rjs, int options) {
        this.service = service;
        this.rjs = rjs;
    }

    public void setSize(double width, double height) {
        if (width == -1.0 && height == -1.0) {
            this.width = -1.0;
            this.height = -1.0;
            return;
        }
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    public RGraphic create(String expression, ProgressMonitor m) throws StatusException {
        return this.create(expression, null, m);
    }

    public RGraphic create(FunctionCall fcall, ProgressMonitor m) throws StatusException {
        return this.create(null, fcall, m);
    }

    private RGraphic create(String expression, FunctionCall fcall, ProgressMonitor m) throws StatusException {
        RClientGraphic graphic;
        int savedOptions = this.rjs.getGraphicOptions();
        int graphicOptions = this.options;
        if ((this.options & 2) == 0) {
            graphicOptions |= 4;
        }
        if ((this.options & 8) == 0) {
            graphicOptions |= 0x10;
        }
        this.rjs.setGraphicOptions(graphicOptions);
        try {
            if (this.width < 0.0) {
                this.service.evalVoid("rj::rj.GD()", m);
            } else {
                this.service.evalVoid("rj::rj.GD(width= " + this.width + ", height= " + this.height + ", size.unit= \"px\")", m);
            }
            if (expression != null) {
                this.service.evalData(expression, m);
            } else {
                fcall.evalVoid(m);
            }
            graphic = this.rjs.getLastGraphic();
        }
        finally {
            this.rjs.setGraphicOptions(savedOptions);
        }
        return graphic instanceof RGraphic ? (RGraphic)graphic : null;
    }
}

