/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrOutlinePage;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.ModelManager;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.source.doc.RPkgDescrDocumentContentInfo;
import org.eclipse.statet.r.ui.sourceediting.RPkgDescrSourceViewerConfiguration;
import org.eclipse.statet.r.ui.sourceediting.RPkgDescrSourceViewerConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

@NonNullByDefault
public class RPkgDescrEditor
extends SourceEditor1 {
    private RPkgDescrSourceViewerConfigurator config;

    public RPkgDescrEditor() {
        super(RCore.RPKG_DESCRIPTION_CONTENT_TYPE);
        this.config = (RPkgDescrSourceViewerConfigurator)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.config)));
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("org.eclipse.statet.r.menus.RPkgDescrEditorContextMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)RUIPlugin.getInstance().getRPkgDescrDocumentProvider());
        this.enableStructuralFeatures((ModelManager)RModel.getRModelManager(), null, null);
        this.config = new RPkgDescrSourceViewerConfigurator(RCore.getWorkbenchAccess(), new RPkgDescrSourceViewerConfiguration((DocContentSections)RPkgDescrDocumentContentInfo.INSTANCE, 0, (SourceEditor)this, null, null, null));
        return this.config;
    }

    public @Nullable RSourceUnit getSourceUnit() {
        return (RSourceUnit)super.getSourceUnit();
    }

    public RCoreAccess getRCoreAccess() {
        return this.config.getRCoreAccess();
    }

    protected void setupConfiguration(@Nullable IEditorInput newInput) {
        super.setupConfiguration(newInput);
        RSourceUnit su = this.getSourceUnit();
        this.config.setSource(RCore.getContextAccess((IAdaptable)su));
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
        pageIds.add("org.eclipse.statet.yaml.preferencePages.YamlTextStyles");
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new RPkgDescrOutlinePage(this);
    }

    public @NonNull String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline"};
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RCoreAccess.class) {
            return (T)this.getRCoreAccess();
        }
        if (adapterType == REnv.class) {
            return (T)this.getRCoreAccess().getREnv();
        }
        return (T)super.getAdapter(adapterType);
    }
}

