/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.r;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpHover;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class REditorInformationProvider
extends EditorInformationProvider {
    private @Nullable RHeuristicTokenScanner scanner;

    public REditorInformationProvider(RSourceEditor editor) {
        super((SourceEditor)editor, ImCollections.newList((Object)new RHelpHover(17)));
    }

    public RSourceEditor getEditor() {
        return (RSourceEditor)super.getEditor();
    }

    private RHeuristicTokenScanner getScanner() {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return scanner;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        try {
            ITypedRegion partition;
            RHeuristicTokenScanner scanner = this.getScanner();
            IDocument document = (IDocument)ObjectUtils.nonNullAssert((Object)textViewer.getDocument());
            scanner.configure(document);
            IRegion word = scanner.findRWord(offset, false, true);
            if (word != null && (RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches((partition = scanner.getPartition(word.getOffset())).getType()) || partition.getType() == "R.String" || partition.getType() == "R.QuotedSymbol")) {
                return word;
            }
        }
        catch (BadLocationException e) {
            RUIPlugin.logUncriticalError(e);
        }
        return new Region(offset, 0);
    }

    protected @Nullable AssistInvocationContext createContext(IRegion region, String contentType, IProgressMonitor monitor) {
        RHeuristicTokenScanner scanner = this.getScanner();
        RAssistInvocationContext context = new RAssistInvocationContext(this.getEditor(), region, contentType, scanner, monitor);
        if (context.getAstInfo() == null) {
            return null;
        }
        return context;
    }
}

