/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.core.util.ScheduledRealmRunnable;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.internal.r.ui.datafilter.FilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.IntervalVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class FilterSet {
    private static final int POST_DELAY_NANOS = 200000000;
    private static final int STD_DELAY = 1;
    private static final int NO_DELAY = 2;
    private final Object updateLock = new Object();
    private @Nullable RDataTableContentDescription input;
    private int inFilterUpdate;
    private boolean isInputFilterUpdate;
    private boolean updateDataScheduled;
    private final ToolRunnable updateDataRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/datafilter/load";
        }

        public String getLabel() {
            RDataTableContentDescription input = FilterSet.this.input;
            return NLS.bind((String)Messages.UpdateJob_label, (Object)(input != null ? input.getLabel() : "..."));
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    Object object = FilterSet.this.updateLock;
                    synchronized (object) {
                        FilterSet.this.updateDataScheduled = false;
                        FilterSet.this.updateLock.notifyAll();
                        break;
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            FilterSet.this.runUpdateData((RToolService)service, m);
        }
    };
    private boolean updateAll;
    private boolean inDataUpdate;
    private volatile ImList<VariableFilter> filters = ImCollections.emptyList();
    private ImList<String> filterNames = ImCollections.emptyList();
    private final CopyOnWriteIdentityListSet<FilterListener> listeners = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<FilterListener> postListeners = new CopyOnWriteIdentityListSet();
    private int listenerScheduled;
    private long listenerEventStamp;
    private final Runnable listenerRunnable = this::updateWithinRealm;
    private final ScheduledRealmRunnable postListenerRunnable;
    private volatile @Nullable String postListenerEffectiveFilter;
    private final Realm realm;
    private boolean enabled;
    private final Object effectiveFilterLock = new Object();
    private volatile @Nullable String effectiveFilter;

    public FilterSet(Realm realm) {
        this.realm = realm;
        this.enabled = true;
        this.postListenerRunnable = ScheduledRealmRunnable.adapt(this::notifyPostListeners, (Realm)realm);
    }

    public Realm getRealm() {
        return this.realm;
    }

    protected final void runInRealm(Runnable runnable) {
        if (this.realm.isCurrent()) {
            runnable.run();
        } else {
            this.realm.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInput(@Nullable RDataTableContentDescription input) {
        Object object = this.updateLock;
        synchronized (object) {
            this.input = input;
            ++this.inFilterUpdate;
        }
        try {
            object = this;
            synchronized (object) {
                ImList<VariableFilter> oldFilters = this.filters;
                ImList<String> oldFilterNames = this.filterNames;
                ArrayList<VariableFilter> filters = new ArrayList<VariableFilter>();
                ArrayList<String> filterNames = new ArrayList<String>();
                this.isInputFilterUpdate = true;
                try {
                    this.beginInputFilterUpdate();
                    int filterIdx = 0;
                    if (input != null) {
                        ImList<RDataTableColumn> columns = input.getDataColumns();
                        filters.ensureCapacity(columns.size());
                        filterNames.ensureCapacity(columns.size());
                        for (RDataTableColumn column : columns) {
                            String columnName = column.getName();
                            if (column.getRExpression() == null || columnName == null) continue;
                            VariableFilter oldFilter = null;
                            VariableFilter newFilter = null;
                            int oldIdx = oldFilterNames.indexOf((Object)columnName);
                            if (oldIdx >= 0) {
                                oldFilter = (VariableFilter)oldFilters.get(oldIdx);
                                if (this.getAvailableFilters(column).contains((Object)oldFilter.getType())) {
                                    newFilter = this.createFilter(oldFilter.getType(), column);
                                }
                                if (newFilter == null) {
                                    newFilter = this.createFilter(this.getDefaultFilter(column), column);
                                }
                                if (newFilter == null) continue;
                                newFilter.load(oldFilter);
                            } else {
                                newFilter = this.createFilter(this.getDefaultFilter(column), column);
                                if (newFilter == null) continue;
                            }
                            filters.add(newFilter);
                            filterNames.add(columnName);
                            this.updateFilter(filterIdx++, oldFilter, newFilter);
                        }
                    }
                }
                finally {
                    this.filters = ImCollections.toList(filters);
                    this.filterNames = ImCollections.toList(filterNames);
                    try {
                        this.completeInputFilterUpdate(this.filters);
                    }
                    finally {
                        this.isInputFilterUpdate = false;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object object2 = this.updateLock;
            synchronized (object2) {
                --this.inFilterUpdate;
                this.scheduleUpdate(true);
            }
            throw throwable;
        }
        Object object3 = this.updateLock;
        synchronized (object3) {
            --this.inFilterUpdate;
            this.scheduleUpdate(true);
        }
    }

    protected final boolean isInputFilterUpdate() {
        return this.isInputFilterUpdate;
    }

    protected void beginInputFilterUpdate() {
    }

    protected void updateFilter(int idx, @Nullable VariableFilter oldFilter, @Nullable VariableFilter newFilter) {
    }

    protected void completeInputFilterUpdate(ImList<VariableFilter> filter) {
    }

    public @Nullable FilterType getDefaultFilter(RDataTableColumn column) {
        switch (column.getVarType()) {
            case 1: 
            case 6: 
            case 10: {
                return FilterType.LEVEL;
            }
            case 2: 
            case 3: 
            case 17: 
            case 19: {
                return FilterType.INTERVAL;
            }
            case 5: {
                return FilterType.LEVEL;
            }
        }
        return null;
    }

    public ImList<FilterType> getAvailableFilters(RDataTableColumn column) {
        switch (column.getVarType()) {
            case 1: 
            case 6: {
                return ImCollections.newList((Object)FilterType.LEVEL);
            }
            case 10: {
                if (((RFactorStore)column.getDataStore()).isOrdered()) {
                    return ImCollections.newList((Object[])new FilterType[]{FilterType.LEVEL, FilterType.INTERVAL});
                }
                return ImCollections.newList((Object)FilterType.LEVEL);
            }
            case 2: 
            case 3: 
            case 17: 
            case 19: {
                return ImCollections.newList((Object[])new FilterType[]{FilterType.INTERVAL, FilterType.LEVEL});
            }
            case 5: {
                return ImCollections.newList((Object)FilterType.LEVEL);
            }
        }
        return ImCollections.emptyList();
    }

    /*
     * Exception decompiling
     */
    public VariableFilter replace(VariableFilter currentFilter, FilterType filterType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected @Nullable VariableFilter createFilter(@Nullable FilterType filterType, RDataTableColumn column) {
        if (filterType == null) {
            return null;
        }
        switch (filterType.getId()) {
            case 0: {
                return new LevelVariableFilter(this, column);
            }
            case 1: {
                return new IntervalVariableFilter(this, column);
            }
            case 2: {
                return new TextVariableFilter(this, column);
            }
        }
        throw new UnsupportedOperationException(filterType.toString());
    }

    public synchronized ImList<VariableFilter> getFilters() {
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdate(boolean all) {
        Object object = this.updateLock;
        synchronized (object) {
            if (all) {
                this.updateAll = true;
            }
            if (this.updateDataScheduled || this.inFilterUpdate > 0) {
                return;
            }
            RDataTableContentDescription input = this.input;
            if (input != null) {
                input.getRHandle().getQueue().add(this.updateDataRunnable);
                this.updateDataScheduled = true;
            }
        }
    }

    protected @Nullable Tool getTool() {
        RDataTableContentDescription input = this.input;
        return input != null ? input.getRHandle() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateData(RToolService r, ProgressMonitor m) {
        boolean all;
        ImList<VariableFilter> filters;
        Object object = this.updateLock;
        synchronized (object) {
            this.updateDataScheduled = false;
            RDataTableContentDescription input = this.input;
            if (this.inFilterUpdate > 0 || input == null || input.getRHandle() != r.getTool()) {
                return;
            }
            filters = this.filters;
            all = this.updateAll;
            this.updateAll = false;
            this.inDataUpdate = true;
        }
        try {
            for (VariableFilter filter : filters) {
                if (!all && !filter.updateScheduled) continue;
                filter.updateScheduled = false;
                try {
                    filter.updateData(r, m);
                }
                catch (StatusException | UnexpectedRDataException e) {
                    filter.setStatus((IStatus)new StatusInfo(4, e.getMessage()));
                }
            }
        }
        catch (Throwable throwable) {
            Object object2 = this.updateLock;
            synchronized (object2) {
                this.inDataUpdate = false;
            }
            throw throwable;
        }
        Object object3 = this.updateLock;
        synchronized (object3) {
            this.inDataUpdate = false;
        }
        this.updateEffectiveFilter(false);
    }

    public void addListener(FilterListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(FilterListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addPostListener(FilterListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void removePostListener(FilterListener listener) {
        this.postListeners.remove((Object)listener);
    }

    private void notifyListeners() {
        for (FilterListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    private void notifyPostListeners() {
        this.postListenerEffectiveFilter = this.effectiveFilter;
        for (FilterListener listener : this.postListeners) {
            listener.filterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithinRealm() {
        long stamp;
        int schedule;
        Runnable runnable = this.listenerRunnable;
        synchronized (runnable) {
            schedule = this.listenerScheduled;
            this.listenerScheduled = 0;
            stamp = this.listenerEventStamp;
        }
        if (schedule == 0) {
            return;
        }
        this.notifyListeners();
        if (schedule != 2) {
            this.postListenerRunnable.scheduleFor(stamp + 200000000L);
        } else {
            this.postListenerRunnable.runNow();
        }
    }

    public @Nullable String getFilterRExpression() {
        return this.effectiveFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String getFilterRExpression(@Nullable String varExpression, int nameFlags) {
        ImList<VariableFilter> filters;
        RDataTableContentDescription input;
        FilterSet filterSet = this;
        synchronized (filterSet) {
            block7: {
                input = this.input;
                if (this.inFilterUpdate <= 0 && input != null) break block7;
                return null;
            }
            filters = this.filters;
        }
        if (varExpression == null) {
            varExpression = (String)ObjectUtils.nonNullAssert((Object)input.getElementName().getDisplayName(nameFlags));
        }
        StringBuilder sb = new StringBuilder();
        for (VariableFilter filter : filters) {
            String rExpression = filter.getFilterRExpression(varExpression, nameFlags);
            if (rExpression == null || rExpression.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" & ");
            }
            sb.append(rExpression);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Object object = this.effectiveFilterLock;
        synchronized (object) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
        }
        this.notifyListeners(2);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEffectiveFilter(boolean delay) {
        ImList<VariableFilter> filters;
        Object object = this.updateLock;
        synchronized (object) {
            RDataTableContentDescription input = this.input;
            if (this.inFilterUpdate > 0 || input == null || this.inDataUpdate) {
                return;
            }
            filters = this.filters;
        }
        StringBuilder sb = new StringBuilder();
        for (VariableFilter filter : filters) {
            String rExpression = filter.getFilterRExpression();
            if (rExpression == null || rExpression.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" & ");
            }
            sb.append(rExpression);
        }
        String filterRExpression = sb.length() > 0 ? sb.toString() : null;
        Object object2 = this.effectiveFilterLock;
        synchronized (object2) {
            if (Objects.equals(this.effectiveFilter, filterRExpression) && (delay || this.postListenerEffectiveFilter == this.effectiveFilter)) {
                return;
            }
            this.effectiveFilter = filterRExpression;
        }
        this.notifyListeners(delay ? 1 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int mode) {
        Runnable runnable = this.listenerRunnable;
        synchronized (runnable) {
            int schedule = this.listenerScheduled;
            if (schedule >= mode) {
                return;
            }
            this.listenerScheduled = mode;
            this.listenerEventStamp = System.nanoTime();
        }
        this.runInRealm(this.listenerRunnable);
    }
}

