/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.FindListener;
import org.eclipse.statet.internal.r.ui.dataeditor.FindTask;
import org.eclipse.statet.internal.r.ui.dataeditor.LoadDataException;
import org.eclipse.statet.internal.r.ui.dataeditor.Lock;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.NullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.ui.statushandlers.StatusManager;

class FindManager {
    private static final int FIND_CELL = 1;
    private static final int FIND_ROW = 2;
    private static final int FIND_ERROR = -1;
    private final ToolRunnable findRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/dataeditor/find";
        }

        public String getLabel() {
            return "Find Data (" + FindManager.this.dataProvider.getInput().getName() + ")";
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        public boolean changed(int event, Tool process) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    FindManager.this.lock.lock();
                    try {
                        FindManager.this.lock.scheduled = false;
                        FindManager.this.lock.clear();
                        break;
                    }
                    finally {
                        FindManager.this.lock.unlock();
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            FindManager.this.runFind((RToolService)service, m);
        }
    };
    private FindTask scheduledTask;
    private String rCacheFind;
    private FindTask currentTask;
    private int activeMode;
    private String activeExpression;
    private long findTotalCount;
    private long findFilteredCount;
    private long findLastMatchIdx;
    private final FindLock lock = new FindLock();
    private final LazyRStore<RObject> findStore;
    private final CopyOnWriteIdentityListSet<FindListener> listeners = new CopyOnWriteIdentityListSet();
    private final AbstractRDataProvider<?> dataProvider;

    public FindManager(AbstractRDataProvider<?> dataProvider) {
        this.dataProvider = dataProvider;
        this.findStore = new LazyRStore(0L, 1L, 5, (LazyRStore.Updater)this.lock);
    }

    public void addFindListener(FindListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeFindListener(FindListener listener) {
        this.listeners.remove((Object)listener);
    }

    void clean(ProgressMonitor m) throws StatusException {
        if (this.rCacheFind != null) {
            this.dataProvider.getTmpItem().remove(this.rCacheFind, m);
            this.rCacheFind = null;
        }
    }

    void clear(int newState) {
        this.clear(newState, true);
    }

    void clear(int newState, boolean forceUpdate) {
        this.lock.lock();
        try {
            this.scheduledTask = null;
            if (!forceUpdate && this.findFilteredCount >= 0L) {
                this.findStore.clear(this.findFilteredCount);
            } else {
                this.findStore.clear(0L);
                this.activeExpression = null;
            }
            this.findLastMatchIdx = -1L;
            if (newState >= 0 && this.lock.state < 4) {
                this.lock.state = newState;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.notifyListeners(null, (IStatus)new StatusInfo(8, ""), -1L, -1L, -1L);
    }

    void reset(boolean filter) {
        this.lock.lock();
        try {
            this.scheduledTask = null;
            this.findStore.clear(-1L);
            if (filter) {
                this.findFilteredCount = -1L;
            }
            this.findLastMatchIdx = -1L;
            if (this.lock.state < 1) {
                this.lock.state = 1;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void find(FindTask task) {
        this.lock.lock();
        try {
            this.scheduledTask = task;
            if (!task.equals(this.currentTask)) {
                this.clear(-1, !task.expression.equals(this.activeExpression));
                this.scheduledTask = task;
                if (this.lock.state < 1) {
                    this.lock.state = 1;
                }
            }
            if (this.dataProvider.getLockState() > 1) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.findMatch(null, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (StatusException | UnexpectedRDataException throwable) {
            // empty catch block
        }
    }

    private void runFind(RToolService r, ProgressMonitor m) throws StatusException {
        try {
            boolean updateFinding;
            this.lock.lock();
            try {
                this.currentTask = this.scheduledTask;
                this.lock.scheduled = false;
                if (this.currentTask == null) {
                    return;
                }
                boolean bl = updateFinding = !this.currentTask.expression.equals(this.activeExpression);
                if (this.lock.state > 1) {
                    return;
                }
                if (this.lock.state == 1 && !updateFinding) {
                    this.lock.state = 0;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (updateFinding) {
                try {
                    this.updateFindingCache(r, m);
                }
                catch (Exception e) {
                    AbstractRDataProvider.checkCancel(e);
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when evaluating find criteria for data viewer.", (Throwable)e));
                    return;
                }
            }
            this.updateFindingFragments(r, m);
            this.findMatch(r, m);
        }
        catch (StatusException e) {
            if (e.getStatus().getSeverity() == 8) {
                this.notifyListeners(this.currentTask, (IStatus)new StatusInfo(8, ""), -1L, -1L, -1L);
            }
            throw e;
        }
        catch (UnexpectedRDataException e) {
            throw new StatusException((org.eclipse.statet.jcommons.status.Status)new ErrorStatus("org.eclipse.statet.r.ui", "An error occurred when evaluating find result for data viewer.", (Throwable)e));
        }
    }

    private void updateFindingCache(RToolService r, ProgressMonitor m) throws UnexpectedRDataException, StatusException {
        int mode = 0;
        long count = 0L;
        long filteredCount = 0L;
        try {
            try {
                boolean runWhich;
                if (this.rCacheFind == null) {
                    this.rCacheFind = this.dataProvider.getTmpItem().createSub("find");
                }
                StringBuilder cmd = this.dataProvider.getRCmdStringBuilder();
                cmd.append("local({");
                cmd.append("x <- ").append(this.dataProvider.getInput().getFullName()).append("; ");
                cmd.append("x.find <- (").append(this.currentTask.expression).append("); ");
                cmd.append("dimnames(").append("x.find").append(") <- NULL; ");
                cmd.append("assign('").append(this.rCacheFind).append("', envir= ").append("rj::.rj.tmp").append(", value= x.find); ");
                cmd.append("})");
                RObject logi = r.evalData(cmd.toString(), null, 1, 1, m);
                if (logi.getRObjectType() == 3 && logi.getData().getStoreType() == 1 && logi.getLength() == this.dataProvider.getFullRowCount() * this.dataProvider.getColumnCount()) {
                    mode = this.dataProvider.getColumnCount() == 1L ? 2 : 1;
                    runWhich = true;
                } else if (logi.getRObjectType() == 2 && logi.getData().getStoreType() == 1 && logi.getLength() == this.dataProvider.getFullRowCount()) {
                    mode = 2;
                    runWhich = true;
                } else if (logi.getRObjectType() == 2 && logi.getData().getStoreType() == 2) {
                    mode = 2;
                    runWhich = false;
                } else {
                    throw new UnexpectedRDataException(logi.toString());
                }
                if (runWhich) {
                    cmd = this.dataProvider.getRCmdStringBuilder();
                    cmd.append("which(").append("rj::.rj.tmp$").append(this.rCacheFind).append(", arr.ind= TRUE)");
                    this.dataProvider.getTmpItem().set(this.rCacheFind, cmd.toString(), m);
                }
                FunctionCall call = r.createFunctionCall("NROW");
                call.add("rj::.rj.tmp$" + this.rCacheFind);
                count = RDataUtils.checkSingleIntValue((RObject)call.evalData(m));
                filteredCount = this.getFilteredCount(count, r, m);
            }
            catch (StatusException | UnexpectedRDataException e) {
                this.clean(m);
                AbstractRDataProvider.checkCancel((Exception)e);
                mode = -1;
                throw e;
            }
        }
        finally {
            if (mode == -1) {
                this.notifyListeners(this.currentTask, (IStatus)new StatusInfo(4, "Error"), -1L, -1L, -1L);
            }
            this.lock.lock();
            try {
                this.activeMode = mode;
                this.activeExpression = this.currentTask.expression;
                this.findTotalCount = count;
                this.findFilteredCount = filteredCount;
                this.findStore.clear(filteredCount);
                this.findLastMatchIdx = -1L;
                if (mode != -1 && this.lock.state < 2) {
                    this.lock.state = 0;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private long getFilteredCount(long count, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        String filterVar = this.dataProvider.checkFilter();
        if (filterVar == null || count == 0L) {
            return count;
        }
        FunctionCall call = r.createFunctionCall("rj:::tmp.getFilteredCount");
        call.addChar("filter", filterVar);
        call.addChar("index", this.rCacheFind);
        return RDataUtils.checkSingleIntValue((RObject)call.evalData(m));
    }

    /*
     * Unable to fully structure code
     */
    private void updateFindingFragments(RToolService r, ProgressMonitor m) throws StatusException {
        block15: {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    this.lock.lock();
                    try {
                        fragment = this.findStore.getNextScheduledFragment();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    if (fragment == null) break block15;
                    if (m.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    fragmentObject = this.loadFindFragment((LazyRStore.Fragment<RObject>)fragment, r, m);
                    this.lock.lock();
                    try {
                        this.findStore.updateFragment(fragment, (Object)fragmentObject);
                    }
                    finally {
                        this.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                AbstractRDataProvider.checkCancel(e);
                this.lock.lock();
                try {
                    this.clear(-1);
                    if (this.lock.state < 3) {
                        this.lock.state = 3;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when loading find matches for data viewer.", (Throwable)e));
                return;
            }
            ** GOTO lbl-1000
        }
    }

    private RObject loadFindFragment(LazyRStore.Fragment<RObject> fragment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        String revIndexName = this.dataProvider.checkRevIndex(r, m);
        StringBuilder cmd = this.dataProvider.getRCmdStringBuilder();
        cmd.append("local({");
        if (revIndexName != null) {
            if (this.activeMode == 1) {
                cmd.append("x <- ").append("rj::.rj.tmp$").append(revIndexName).append("[").append("rj::.rj.tmp$").append(this.rCacheFind).append("[,1L]").append("]\n");
                cmd.append("x <- cbind(x, ").append("rj::.rj.tmp$").append(this.rCacheFind).append("[,2L]").append(")\n");
            } else {
                cmd.append("x <- ").append("rj::.rj.tmp$").append(revIndexName).append("[").append("rj::.rj.tmp$").append(this.rCacheFind).append("]\n");
            }
            cmd.append("x <- na.omit(x)\n");
        } else {
            cmd.append("x <- ").append("rj::.rj.tmp$").append(this.rCacheFind).append("\n");
        }
        cmd.append("x <- x[order(");
        if (this.activeMode == 1) {
            cmd.append(this.currentTask.firstInRow ? "x[,1L], x[,2L]" : "x[,2L], x[,1L]");
        } else {
            cmd.append("x");
        }
        cmd.append(")").append("[").append(fragment.getRowBeginIdx() + 1L).append(":").append(fragment.getRowEndIdx()).append("]");
        if (this.activeMode == 1) {
            cmd.append(",");
        }
        cmd.append("]; ");
        cmd.append("x; ");
        cmd.append("})");
        return r.evalData(cmd.toString(), m);
    }

    private void findMatch(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        long globalMatchIdx;
        long filteredCount;
        long totalCount;
        int mode;
        FindTask task;
        this.lock.lock();
        try {
            task = this.scheduledTask;
            mode = this.activeMode;
            totalCount = this.findTotalCount;
            filteredCount = this.findFilteredCount;
            globalMatchIdx = this.findLastMatchIdx;
            if (task == null || !task.equals(this.currentTask) || this.lock.state == 1) {
                this.notifyListeners(task, (IStatus)new StatusInfo(1, "Finding..."), -1L, -1L, -1L);
                this.lock.scheduleUpdate(null, null, null, 0, null);
                return;
            }
            if (mode == -1) {
                this.notifyListeners(task, (IStatus)new StatusInfo(4, "Error."), -1L, -1L, -1L);
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (filteredCount < 0L) {
            if (r != null) {
                filteredCount = this.getFilteredCount(totalCount, r, m);
                this.lock.lock();
                try {
                    this.findFilteredCount = filteredCount;
                    this.findStore.clear(filteredCount);
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.lock.lock();
            try {
                if (task != this.scheduledTask) {
                    return;
                }
                this.lock.scheduleUpdate(null, null, null, 0, null);
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        if (filteredCount <= 0L) {
            this.notifyListeners(task, (IStatus)new StatusInfo(1, NLS.bind((String)"Not found (total {0}/{1}).", (Object)filteredCount, (Object)totalCount)), filteredCount, -1L, -1L);
            return;
        }
        this.notifyListeners(task, (IStatus)new StatusInfo(1, NLS.bind((String)"Finding {0} (total {1}/{2})...", (Object[])new Object[]{task.forward ? "next" : "previous", filteredCount, totalCount})), filteredCount, -1L, -1L);
        if (globalMatchIdx >= filteredCount) {
            globalMatchIdx = filteredCount - 1L;
        } else if (globalMatchIdx < 0L) {
            globalMatchIdx = filteredCount / 2L;
        }
        try {
            long posCol;
            long posRow;
            long[] high;
            long[] low;
            long[] rPos;
            int colIdx;
            int rowIdx;
            if (mode == 1) {
                rowIdx = task.firstInRow ? 0 : 1;
                colIdx = task.firstInRow ? 1 : 0;
                rPos = new long[2];
                rPos[rowIdx] = task.rowIdx + 1L;
                rPos[colIdx] = task.columnIdx + 1L;
                low = new long[2];
                high = new long[2];
            } else {
                rowIdx = 0;
                colIdx = -1;
                rPos = new long[]{task.rowIdx + 1L};
                low = new long[1];
                high = new long[1];
            }
            do {
                long localMatchIdx;
                int length;
                RStore data;
                LazyRStore.Fragment<RObject> fragment;
                block53: {
                    int last = 0;
                    while (true) {
                        if (m.isCanceled()) {
                            throw new StatusException(org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS);
                        }
                        fragment = this.lock.getFragment(this.findStore, globalMatchIdx, 0L, 0, m);
                        if (fragment != null) {
                            data = ((RObject)fragment.getRObject()).getData();
                            length = (int)fragment.getRowCount();
                            low[rowIdx] = data.getInt(0);
                            high[rowIdx] = data.getInt(length - 1);
                            if (mode == 1) {
                                low[colIdx] = data.getInt(length);
                                high[colIdx] = data.getInt(length + length - 1);
                            }
                            if (RDataUtils.compare((long[])rPos, (long[])low) < 0) {
                                globalMatchIdx = fragment.getRowBeginIdx() - 1L;
                                if (globalMatchIdx < 0L || task.forward && last == 1) break block53;
                                last = -1;
                            }
                            if (RDataUtils.compare((long[])rPos, (long[])high) > 0 && (globalMatchIdx = fragment.getRowEndIdx()) <= filteredCount && (task.forward || last != -1)) {
                                last = 1;
                            }
                            break block53;
                        }
                        if (r == null) break;
                        this.updateFindingFragments(r, m);
                        this.lock.lock();
                        try {
                            if (task == this.scheduledTask && this.lock.state <= 0) continue;
                            return;
                        }
                        finally {
                            this.lock.unlock();
                            continue;
                        }
                        break;
                    }
                    this.lock.lock();
                    try {
                        if (task != this.scheduledTask) {
                            return;
                        }
                        this.lock.scheduleUpdate(null, null, null, 0, null);
                    }
                    finally {
                        this.lock.unlock();
                    }
                    return;
                }
                data = ((RObject)fragment.getRObject()).getData();
                length = (int)fragment.getRowCount();
                if (mode == 1) {
                    low[rowIdx] = 0L;
                    low[colIdx] = length;
                    localMatchIdx = RDataUtils.binarySearch((RStore)data, (long[])low, (int)length, (long[])rPos);
                } else {
                    localMatchIdx = RDataUtils.binarySearch((RStore)data, (long)rPos[rowIdx]);
                }
                if (localMatchIdx >= 0L) {
                    localMatchIdx += (long)(task.forward ? 1 : -1);
                } else {
                    localMatchIdx = -(localMatchIdx + 1L);
                    localMatchIdx += (long)(task.forward ? 0 : -1);
                }
                if (localMatchIdx < 0L || localMatchIdx >= (long)length) {
                    this.notifyListeners(task, (IStatus)new StatusInfo(1, NLS.bind((String)"No further match (total {0}/{1}).", (Object)filteredCount, (Object)totalCount)), filteredCount, -1L, -1L);
                    return;
                }
                this.lock.lock();
                try {
                    if (task != this.scheduledTask) {
                        return;
                    }
                    this.findLastMatchIdx = globalMatchIdx = fragment.getRowBeginIdx() + localMatchIdx;
                }
                finally {
                    this.lock.unlock();
                }
                rPos[rowIdx] = data.getInt(localMatchIdx);
                posRow = rPos[rowIdx] - 1L;
                if (mode == 1) {
                    rPos[colIdx] = data.getInt((long)length + localMatchIdx);
                    posCol = rPos[colIdx] - 1L;
                    continue;
                }
                posCol = -1L;
            } while (task.filter != null && !task.filter.match(posRow, posCol));
            this.notifyListeners(task, (IStatus)new StatusInfo(1, NLS.bind((String)"Match {0} (total {1}/{2}).", (Object[])new Object[]{globalMatchIdx + 1L, filteredCount, totalCount})), filteredCount, posRow, posCol);
            return;
        }
        catch (LoadDataException loadDataException) {
            return;
        }
    }

    private void notifyListeners(final FindTask task, final IStatus status, final long total, final long rowIdx, final long colIdx) {
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FindManager.this.lock.lock();
                try {
                    if (task != null && task != FindManager.this.scheduledTask) {
                        return;
                    }
                }
                finally {
                    FindManager.this.lock.unlock();
                }
                FindListener.FindEvent event = new FindListener.FindEvent(status, total, rowIdx, colIdx);
                for (FindListener listener : FindManager.this.listeners.toList()) {
                    listener.handleFindEvent(event);
                }
            }
        });
    }

    private class FindLock
    extends Lock
    implements LazyRStore.Updater<RObject> {
        private FindLock() {
        }

        public void scheduleUpdate(LazyRStore<RObject> store, RDataAssignment assignment, LazyRStore.Fragment<RObject> fragment, int flags, ProgressMonitor m) {
            if (fragment != null && this.state > 0) {
                return;
            }
            if (!this.scheduled) {
                this.scheduled = true;
                FindManager.this.dataProvider.schedule(FindManager.this.findRunnable);
            }
        }
    }
}

