/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.objectbrowser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.base.ui.StatetImages;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.models.core.util.ElementPartition;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SearchContributionItem;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.ColumnHoverManager;
import org.eclipse.statet.ecommons.ui.util.ColumnHoverStickyManager;
import org.eclipse.statet.ecommons.ui.util.ColumnWidgetTokenOwner;
import org.eclipse.statet.ecommons.ui.util.InformationDispatchHandler;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PostSelectionProviderProxy;
import org.eclipse.statet.ecommons.ui.util.TreeSelectionProxy;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.ViewActionUtil;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.objectbrowser.ContentInput;
import org.eclipse.statet.internal.r.objectbrowser.ContentJob;
import org.eclipse.statet.internal.r.objectbrowser.DeleteHandler;
import org.eclipse.statet.internal.r.objectbrowser.OpenInEditorHandler;
import org.eclipse.statet.internal.r.objectbrowser.SortByTypeComparator;
import org.eclipse.statet.internal.r.objectbrowser.ToggleAutoRefreshHandler;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.ltk.ui.util.ViewerDragSupport;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementComparator;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.rtool.CopyRElementHandler;
import org.eclipse.statet.r.ui.rtool.PrintRElementHandler;
import org.eclipse.statet.r.ui.rtool.RElementInfoHoverCreator;
import org.eclipse.statet.r.ui.rtool.RElementInfoTask;
import org.eclipse.statet.r.ui.rtool.RElementViewerDragSourceListener;
import org.eclipse.statet.r.ui.util.CopyRElementNameHandler;
import org.eclipse.statet.r.ui.util.RElementInputContentProvider;
import org.eclipse.statet.r.ui.util.RElementInputLabelProvider;
import org.eclipse.statet.r.ui.util.RElementInputUtils;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class ObjectBrowserView
extends ViewPart
implements ToolProvider {
    private static final String REFRESH_COMMAND_ID = "org.eclipse.ui.file.refresh";
    private static final String OPEN_COMMAND_ID = "org.eclipse.jdt.ui.edit.text.java.open.editor";
    private static final String PRINT_COMMAND_ID = "org.eclipse.statet.r.commands.RunPrintInR";
    private static final String FILTER_ONLY_USERSPACE_COMMAND_ID = "Filter.OnlyUserspace";
    private static final String FILTER_INCLUDE_INTERNAL_COMMAND_ID = "Filter.IncludeInternal";
    private static final String FILTER_ONLY_USERSPACE_SETTINGS_KEY = "Filter.OnlyUserspace.enabled";
    private static final String FILTER_INCLUDE_INTERNAL_SETTINGS_KEY = "Filter.IncludeInternal.enabled";
    private static final String SORT_BY_TYPE_SETTINGS_KEY = "Sort.ByType.enabled";
    static final RElementComparator ELEMENTNAME_COMPARATOR = new RElementComparator();
    private static final ViewerComparator TYPE_COMPARATOR = new SortByTypeComparator();
    private IDialogSettings settings;
    final Object sourceLock = new Object();
    private WorkbenchToolRegistryListener toolRegistryListener;
    private @Nullable RProcess process;
    private final CopyOnWriteIdentityListSet<ActiveToolListener> toolListeners = new CopyOnWriteIdentityListSet();
    private TreeViewer treeViewer;
    private ColumnWidgetTokenOwner tokenOwner;
    private Clipboard clipboard;
    private final ContentJob inputUpdater = new ContentJob(this);
    private boolean isUpdating;
    private final RefreshWorkspaceR manualRefreshRunnable = new RefreshWorkspaceR();
    private boolean filterUserspace;
    private boolean filterIncludeInternal;
    private String filterText;
    private boolean sortByType;
    private SearchContributionItem searchTextItem;
    private RElementInputContentProvider<ContentInput> inputContentProvider;
    private boolean filterUserspaceActivated;
    private ViewActionUtil actionUtil;
    private ContextHandlers handlers;
    private @Nullable Object currentInfoObject;
    private ColumnHoverManager hoveringController;
    private HandlerContributionItem refreshToolbarItem;
    private HandlerContributionItem refreshMenuItem;
    private boolean refreshDirtyIndicator;

    public void dispose() {
        if (this.toolRegistryListener != null) {
            NicoUI.getToolRegistry().removeListener(this.toolRegistryListener);
            this.toolRegistryListener = null;
        }
        this.setTool(null, false);
        this.inputUpdater.cancel();
        if (this.hoveringController != null) {
            this.hoveringController.dispose();
            this.hoveringController = null;
        }
        if (this.handlers != null) {
            this.handlers.dispose();
            this.handlers = null;
        }
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings = DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"ObjectBrowser");
        this.filterUserspaceActivated = this.filterUserspace = this.settings.getBoolean(FILTER_ONLY_USERSPACE_SETTINGS_KEY);
        this.filterIncludeInternal = this.settings.getBoolean(FILTER_INCLUDE_INTERNAL_SETTINGS_KEY);
        this.sortByType = this.settings.getBoolean(SORT_BY_TYPE_SETTINGS_KEY);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.settings = DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"ObjectBrowser");
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.newSashGrid());
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TreeSelectionProvider treeSelectionProvider = new TreeSelectionProvider();
        treeSelectionProvider.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObjectBrowserView.this.updateSelectionInfo((ITreeSelection)event.getSelection());
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RElementInputLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        this.inputContentProvider = new RElementInputContentProvider();
        this.treeViewer.setContentProvider(this.inputContentProvider);
        this.updateSorter();
        this.treeViewer.setInput((Object)this);
        this.tokenOwner = new ColumnWidgetTokenOwner((ColumnViewer)this.treeViewer);
        this.hoveringController = new HoverManager();
        this.hoveringController.setSizeConstraints(100, 12, false, true);
        this.hoveringController.install((Control)this.treeViewer.getTree());
        IViewSite site = this.getViewSite();
        site.setSelectionProvider((ISelectionProvider)treeSelectionProvider);
        this.actionUtil = new ViewActionUtil((IViewPart)this);
        this.handlers = new ContextHandlers((IServiceLocator)site);
        this.initActions((IServiceLocator)site, this.handlers);
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), (HandlerCollection)this.handlers);
        this.hookContextMenu();
        WorkbenchToolRegistry toolRegistry = NicoUI.getToolRegistry();
        this.toolRegistryListener = new WorkbenchToolRegistryListener(){

            public void toolSessionActivated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ObjectBrowserView.this.setTool(tool, true);
                    }
                });
            }

            public void toolTerminated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (tool == ObjectBrowserView.this.getTool()) {
                            ObjectBrowserView.this.setTool(null, true);
                        }
                    }
                });
            }
        };
        toolRegistry.addListener(this.toolRegistryListener, this.getViewSite().getPage());
        this.setTool(toolRegistry.getActiveToolSession(this.getViewSite().getPage()).getTool(), true);
    }

    TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        IContextService contexts = (IContextService)serviceLocator.getService(IContextService.class);
        contexts.activateContext("org.eclipse.statet.workbench.contexts.StructuredElementViewer");
        handlers.addActivate(REFRESH_COMMAND_ID, (IHandler2)new RefreshHandler());
        CopyRElementHandler copyHandler = new CopyRElementHandler(this.actionUtil, (ILabelProvider)this.treeViewer.getLabelProvider());
        handlers.addActivate("org.eclipse.ui.edit.copy", (IHandler2)copyHandler);
        handlers.addActivate("org.eclipse.statet.workbench.commands.CopyElementName", (IHandler2)new CopyRElementNameHandler(this.actionUtil));
        handlers.addActivate("org.eclipse.ui.edit.delete", (IHandler2)new DeleteHandler(this));
        ViewerDragSupport dragSupport = new ViewerDragSupport((StructuredViewer)this.treeViewer);
        dragSupport.addDragSourceListener((TransferDragSourceListener)new RElementViewerDragSourceListener(copyHandler, (StructuredViewer)this.treeViewer));
        dragSupport.init();
        handlers.addActivate(OPEN_COMMAND_ID, (IHandler2)new OpenInEditorHandler());
        handlers.addActivate(PRINT_COMMAND_ID, (IHandler2)new PrintRElementHandler(this.actionUtil));
        handlers.addActivate("org.eclipse.ui.edit.text.showInformation", (IHandler2)new InformationDispatchHandler(this.tokenOwner));
        handlers.add(FILTER_INCLUDE_INTERNAL_COMMAND_ID, (IHandler2)new FilterInternalHandler());
        handlers.add(FILTER_ONLY_USERSPACE_COMMAND_ID, (IHandler2)new FilterUserspaceHandler());
        handlers.addActivate("org.eclipse.ui.navigate.collapseAll", (IHandler2)new CollapseAllHandler((AbstractTreeViewer)this.treeViewer));
        RElementInputUtils.addDoubleClickExpansion((AbstractTreeViewer)this.treeViewer);
        this.searchTextItem = new SearchContributionItem("search.text", 0x10000000, true){

            protected void search() {
                ObjectBrowserView.this.filterText = this.getText();
                ObjectBrowserView.this.updateFilter();
            }
        };
        this.searchTextItem.setToolTip("Filter Elements");
        this.searchTextItem.setSizeControl(this.treeViewer.getControl().getParent());
        this.searchTextItem.setResultControl((Control)this.treeViewer.getTree());
        handlers.addActivate("org.eclipse.ui.edit.findReplace", (IHandler2)new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) {
                ObjectBrowserView.this.searchTextItem.show();
                return null;
            }
        });
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IMenuManager menuManager = actionBars.getMenuManager();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        ToggleAutoRefreshHandler autoRefreshHandler = new ToggleAutoRefreshHandler(this);
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, FILTER_ONLY_USERSPACE_COMMAND_ID, "NO_COMMAND", null, null, null, null, "Show non-&package Variables only", null, null, 32, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get(FILTER_ONLY_USERSPACE_COMMAND_ID))));
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, "Show &Internal Variables ('.*')", null, null, 32, null, false), (IHandler2)ObjectUtils.nonNullAssert((Object)handlers.get(FILTER_INCLUDE_INTERNAL_COMMAND_ID))));
        menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "Sort.ByType", "NO_COMMAND", null, null, null, null, "Sort by &Type", null, null, 32, null, false), (IHandler2)new SortByTypeHandler()));
        menuManager.add((IContributionItem)new Separator());
        final HandlerContributionItem autoRefreshItem = new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, null, null, null, "Refresh &automatically", null, null, 32, null, false), (IHandler2)autoRefreshHandler);
        menuManager.add((IContributionItem)autoRefreshItem);
        this.refreshMenuItem = new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "Refresh", REFRESH_COMMAND_ID, null, StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/images/tool/refresh"), StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/images/toold/refresh"), null, "&Refresh", null, null, 8, null, false), handlers);
        menuManager.add((IContributionItem)this.refreshMenuItem);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                autoRefreshItem.update();
            }
        });
        toolbarManager.add((IContributionItem)this.searchTextItem);
        toolbarManager.add((IContributionItem)new Separator());
        this.refreshToolbarItem = new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "Refresh", REFRESH_COMMAND_ID, null, StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/images/tool/refresh"), StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/images/toold/refresh"), null, null, null, null, 8, null, false), handlers);
        this.refreshToolbarItem.setVisible(false);
        toolbarManager.add((IContributionItem)this.refreshToolbarItem);
        toolbarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.collapseAll", null, null, null, null, null, null, null, 8, null, false), handlers));
    }

    void updateAutoRefresh(boolean enabled) {
        if (this.process == null || this.process.isTerminated()) {
            return;
        }
        if (enabled) {
            this.updateDirty(false);
        } else {
            this.updateDirty(this.process.getWorkspace().isRObjectDBDirty());
        }
        if (this.refreshToolbarItem.isVisible() != enabled) {
            return;
        }
        this.refreshToolbarItem.setVisible(!enabled);
        IContributionManager manager = this.refreshToolbarItem.getParent();
        manager.update(true);
        this.searchTextItem.resize();
    }

    void updateDirty(boolean enabled) {
        if (this.refreshDirtyIndicator == enabled) {
            return;
        }
        ImageDescriptor icon = (ImageDescriptor)ObjectUtils.nonNullAssert((Object)(enabled ? RUIPlugin.getInstance().getImageRegistry().getDescriptor("org.eclipse.statet.r.ui/images/loctool/refresh.recommended") : StatetImages.getDescriptor((String)"org.eclipse.statet.ide.ui/images/tool/refresh")));
        this.refreshToolbarItem.setIcon(icon);
        this.refreshMenuItem.setIcon(icon);
        this.refreshDirtyIndicator = enabled;
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("ContextMenu", "org.eclipse.statet.r.menus.RObjectBrowserContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this::fillContextMenu);
        Menu contextMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager m) {
        IWorkbenchPartSite serviceLocator = this.getSite();
        ContextHandlers handlers = this.handlers;
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, null, OPEN_COMMAND_ID, null, null, null, null, "Open in Data &Viewer", null, null, 8, null, true), (HandlerCollection)handlers));
        m.add((IContributionItem)new Separator("edit"));
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Copy", "org.eclipse.ui.edit.copy", null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Copy.ElementName", "org.eclipse.statet.workbench.commands.CopyElementName", null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Delete", "org.eclipse.ui.edit.delete", null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new Separator());
        m.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, null, PRINT_COMMAND_ID, null, null, null, null, null, null, null, 8, null, false), (HandlerCollection)handlers));
        m.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public @Nullable RProcess getTool() {
        return this.process;
    }

    public void addToolListener(ActiveToolListener action) {
        this.toolListeners.add((Object)action);
    }

    public void removeToolListener(ActiveToolListener action) {
        this.toolListeners.remove((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTool(@Nullable Tool tool, boolean update) {
        RProcess process;
        RProcess rProcess = process = tool != null && tool.isProvidingFeatureSet("org.eclipse.statet.r.data") && !tool.isTerminated() ? (RProcess)tool : null;
        if (this.process == tool) {
            return;
        }
        RProcess oldProcess = this.process;
        if (oldProcess != null) {
            oldProcess.getWorkspace().removePropertyListener((ToolWorkspace.Listener)this.inputUpdater);
        }
        Object object = this.sourceLock;
        synchronized (object) {
            this.process = process;
        }
        if (this.hoveringController != null) {
            this.hoveringController.stop();
        }
        this.clearActionInfo();
        if (oldProcess != null) {
            oldProcess.getQueue().remove((ToolRunnable)this.manualRefreshRunnable);
        }
        ActiveToolListener.ActiveToolEvent event = new ActiveToolListener.ActiveToolEvent(1, (Tool)process);
        for (ActiveToolListener listener : this.toolListeners) {
            listener.onToolChanged(event);
        }
        this.inputUpdater.forceUpdate(process);
        if (process != null) {
            process.getWorkspace().addPropertyListener((ToolWorkspace.Listener)this.inputUpdater);
            this.updateAutoRefresh(process.getWorkspace().isAutoRefreshEnabled());
        }
        if (update) {
            this.inputUpdater.schedule();
        }
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)this.treeViewer.getSelection();
    }

    public boolean getShowCondensedUserspace() {
        return this.filterUserspace;
    }

    public boolean getFilterIncludeInternal() {
        return this.filterIncludeInternal;
    }

    public String getFilterSearchText() {
        return this.filterText;
    }

    private void scheduleUpdateAll() {
        if (this.process != null) {
            this.process.getQueue().add((ToolRunnable)this.manualRefreshRunnable);
        }
    }

    /*
     * WARNING - void declaration
     */
    void updateView(@Nullable ContentInput input, @Nullable List<RProcessREnvironment> updateEnvirs) {
        block17: {
            CombinedRElement[] rootElements;
            if (!UIAccess.isOkToUse((Viewer)this.treeViewer)) {
                return;
            }
            this.isUpdating = true;
            this.hoveringController.stop();
            ContentInput prevInput = this.inputContentProvider.getInput();
            this.inputContentProvider.setInput(input);
            boolean processChanged = Objects.equals(input != null ? input.getSource() : null, prevInput != null ? prevInput.getSource() : null);
            ISelection selection = null;
            if (input != null && !processChanged && input.isFilterUserspace() != this.filterUserspaceActivated) {
                selection = this.treeViewer.getSelection();
            }
            this.filterUserspaceActivated = input != null ? input.isFilterUserspace() : false;
            Set<RReference> previousReferences = this.inputContentProvider.resetUsedReferences();
            if (input != null && updateEnvirs != null) {
                for (RProcessREnvironment entry : updateEnvirs) {
                    this.treeViewer.refresh((Object)entry, true);
                }
                if (!previousReferences.isEmpty()) {
                    Set<RReference> usedReferences = this.inputContentProvider.getUsedReferences();
                    block1: for (RReference reference : previousReferences) {
                        if (usedReferences.contains(reference)) continue;
                        for (RProcessREnvironment rProcessREnvironment : updateEnvirs) {
                            if (rProcessREnvironment.getHandle() != reference.getHandle()) continue;
                            this.treeViewer.refresh((Object)reference, true);
                            continue block1;
                        }
                        for (RProcessREnvironment rProcessREnvironment : input.searchEnvirs) {
                            if (rProcessREnvironment.getHandle() != reference.getHandle()) continue;
                            usedReferences.add(reference);
                            continue block1;
                        }
                    }
                }
            } else {
                this.treeViewer.refresh(true);
            }
            if (input != null && selection != null && !selection.isEmpty()) {
                void var10_16;
                ITreeSelection s = (ITreeSelection)selection;
                TreePath[] paths = s.getPaths();
                int j = 0;
                boolean n = false;
                while (var10_16 < paths.length) {
                    int shift;
                    TreePath oldPath = paths[var10_16];
                    int count = oldPath.getSegmentCount();
                    int n2 = shift = input.isFilterUserspace() ? -1 : 1;
                    if (count + shift >= 1) {
                        Object[] newPath = new Object[count + shift];
                        int k = shift == -1 ? 1 : 0;
                        while (k < count) {
                            newPath[k + shift] = oldPath.getSegment(k);
                            ++k;
                        }
                        if (shift == 1) {
                            newPath[0] = RElementInputContentProvider.getCombinedRElement(newPath[1]).getModelParent();
                        }
                        paths[j++] = new TreePath(newPath);
                    }
                    ++var10_16;
                }
                this.treeViewer.setSelection((ISelection)new TreeSelection(j < paths.length ? Arrays.copyOf(paths, j) : paths), true);
            }
            if (input != null && processChanged && !input.isFilterUserspace() && (rootElements = input.getRootElements()) != null && rootElements.length > 0) {
                CombinedRElement[] combinedRElementArray = rootElements;
                int n = rootElements.length;
                int n2 = 0;
                while (n2 < n) {
                    CombinedRElement element = combinedRElementArray[n2];
                    if (!this.treeViewer.getExpandedState((Object)element)) {
                        ++n2;
                        continue;
                    }
                    break block17;
                }
                this.treeViewer.expandToLevel((Object)new TreePath(new Object[]{rootElements[0]}), 1);
            }
        }
        this.isUpdating = false;
        this.updateSelectionInfo((ITreeSelection)this.actionUtil.getSelectionProvider().getSelection());
    }

    private void updateFilter() {
        this.inputUpdater.schedule();
    }

    private void updateSorter() {
        this.treeViewer.setComparator((ViewerComparator)(this.sortByType ? TYPE_COMPARATOR : null));
    }

    private void clearActionInfo() {
        this.actionUtil.getStatusLine().clearAll();
    }

    private void updateSelectionInfo(ITreeSelection selection) {
        if (this.isUpdating) {
            return;
        }
        Object infoObject = null;
        String message = null;
        RProcess tool = this.getTool();
        if (tool != null && !selection.isEmpty()) {
            if (selection.size() == 1) {
                String name;
                TreePath treePath = selection.getPaths()[0];
                RElementName elementName = this.getFQElementName(treePath);
                String string = name = elementName != null ? elementName.getDisplayName() : null;
                if (name != null) {
                    infoObject = selection.getFirstElement();
                    message = name;
                }
            } else {
                message = NLS.bind((String)"{0} items selected", (Object)selection.size());
            }
            if (message != null) {
                message = NLS.bind((String)"{0}  \u2012  {1}", (Object)message, (Object)tool.getLabel(0));
            }
        }
        if (infoObject == null || !infoObject.equals(this.currentInfoObject)) {
            this.clearActionInfo();
        }
        this.currentInfoObject = infoObject;
        this.actionUtil.getStatusLine().setSelectionMessage((IStatus)(message != null ? new StatusInfo(0, message) : null));
    }

    public @Nullable RElementName getFQElementName(TreePath treePath) {
        if (treePath.getSegmentCount() == 0) {
            return null;
        }
        int segmentIdx = 0;
        if (!this.filterUserspaceActivated) {
            if (treePath.getSegmentCount() == 1) {
                return RElementInputContentProvider.getCombinedRElement(treePath.getFirstSegment()).getElementName();
            }
            segmentIdx = 1;
        }
        ArrayList<RElementName> names = new ArrayList<RElementName>(treePath.getSegmentCount() - segmentIdx + 1);
        CombinedRElement first = RElementInputContentProvider.getCombinedRElement(treePath.getSegment(segmentIdx++));
        names.add(first.getModelParent().getElementName());
        names.add(first.getElementName());
        while (segmentIdx < treePath.getSegmentCount()) {
            Object segment;
            if ((segment = treePath.getSegment(segmentIdx++)) instanceof ElementPartition) continue;
            CombinedRElement rElement = RElementInputContentProvider.getCombinedRElement(segment);
            names.add(rElement.getElementName());
        }
        return RElementName.create(names);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == Control.class) {
            return (T)this.treeViewer.getControl();
        }
        if (adapterType == Tool.class) {
            return (T)this.process;
        }
        return (T)super.getAdapter(adapterType);
    }

    private class FilterInternalHandler
    extends AbstractHandler
    implements IElementUpdater {
        private FilterInternalHandler() {
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setChecked(ObjectBrowserView.this.filterIncludeInternal);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public @Nullable Object execute(ExecutionEvent event) {
            ObjectBrowserView.this.filterIncludeInternal = !ObjectBrowserView.this.filterIncludeInternal;
            ObjectBrowserView.this.settings.put(ObjectBrowserView.FILTER_INCLUDE_INTERNAL_SETTINGS_KEY, ObjectBrowserView.this.filterIncludeInternal);
            ObjectBrowserView.this.updateFilter();
            return null;
        }
    }

    private class FilterUserspaceHandler
    extends AbstractHandler
    implements IElementUpdater {
        private FilterUserspaceHandler() {
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setChecked(ObjectBrowserView.this.filterUserspace);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public @Nullable Object execute(ExecutionEvent event) {
            ObjectBrowserView.this.filterUserspace = !ObjectBrowserView.this.filterUserspace;
            ObjectBrowserView.this.settings.put(ObjectBrowserView.FILTER_ONLY_USERSPACE_SETTINGS_KEY, ObjectBrowserView.this.filterUserspace);
            ObjectBrowserView.this.inputUpdater.forceUpdate(ObjectBrowserView.this.process);
            ObjectBrowserView.this.inputUpdater.schedule();
            return null;
        }
    }

    private class HoverManager
    extends ColumnHoverManager {
        HoverManager() {
            super(ObjectBrowserView.this.treeViewer, ObjectBrowserView.this.tokenOwner, (IInformationControlCreator)new RElementInfoHoverCreator(1));
            ColumnHoverStickyManager stickyManager = new ColumnHoverStickyManager(ObjectBrowserView.this.tokenOwner, (IWidgetTokenKeeper)this);
            this.getInternalAccessor().setInformationControlReplacer((InformationControlReplacer)stickyManager);
        }

        protected @Nullable Object prepareHoverInformation(ViewerCell cell) {
            TreePath treePath = cell.getViewerRow().getTreePath();
            RElementName elementName = ObjectBrowserView.this.getFQElementName(treePath);
            if (elementName != null && elementName.getScope() != null) {
                return elementName;
            }
            return null;
        }

        protected @Nullable Object getHoverInformation(Object element) {
            if (element instanceof RElementName && ObjectBrowserView.this.process != null) {
                RElementInfoTask updater = new RElementInfoTask((RElementName)element);
                return updater.load((RTool)ObjectBrowserView.this.getTool(), this.getSubjectControl(), (IWorkbenchPart)ObjectBrowserView.this);
            }
            return null;
        }
    }

    private class RefreshHandler
    extends AbstractToolHandler<RProcess> {
        public RefreshHandler() {
            super("R", null, (ToolProvider)ObjectBrowserView.this, (IServiceLocator)ObjectBrowserView.this.getSite());
            this.init();
        }

        protected void refreshElements() {
            WorkbenchUIUtils.refreshCommandElements((String)ObjectBrowserView.REFRESH_COMMAND_ID, (IHandler2)this, null);
        }

        protected @Nullable Object execute(RProcess tool, ExecutionEvent event) {
            ObjectBrowserView.this.scheduleUpdateAll();
            return null;
        }
    }

    private class RefreshWorkspaceR
    extends AbstractRDataRunnable {
        public RefreshWorkspaceR() {
            super("r/objectbrowser/refreshWorkspace.force", "Update Object Browser");
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
            boolean current;
            Object object = ObjectBrowserView.this.sourceLock;
            synchronized (object) {
                current = r.getTool() != ObjectBrowserView.this.getTool();
            }
            IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)ObjectBrowserView.this.getViewSite().getService(IWorkbenchSiteProgressService.class);
            if (current && progressService != null) {
                progressService.incrementBusy();
            }
            try {
                ObjectBrowserView.this.inputUpdater.forceOnWorkspaceChange();
                r.refreshWorkspaceData(2, m);
            }
            finally {
                if (current && progressService != null) {
                    progressService.decrementBusy();
                }
            }
        }
    }

    private class SortByTypeHandler
    extends AbstractHandler
    implements IElementUpdater {
        private SortByTypeHandler() {
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                element.setChecked(ObjectBrowserView.this.sortByType);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public @Nullable Object execute(ExecutionEvent event) {
            ObjectBrowserView.this.sortByType = !ObjectBrowserView.this.sortByType;
            ObjectBrowserView.this.settings.put(ObjectBrowserView.SORT_BY_TYPE_SETTINGS_KEY, ObjectBrowserView.this.sortByType);
            ObjectBrowserView.this.updateSorter();
            return null;
        }
    }

    private class TreeElementSelection
    extends TreeSelectionProxy
    implements ElementNameProvider {
        public TreeElementSelection(ITreeSelection selection) {
            super(selection);
        }

        public @Nullable ElementName getElementName(Object selectionElement) {
            if (selectionElement instanceof TreePath) {
                return ObjectBrowserView.this.getFQElementName((TreePath)selectionElement);
            }
            return null;
        }
    }

    private class TreeSelectionProvider
    extends PostSelectionProviderProxy {
        public TreeSelectionProvider() {
            super((ISelectionProvider)ObjectBrowserView.this.treeViewer);
        }

        protected ISelection getSelection(ISelection originalSelection) {
            return new TreeElementSelection((ITreeSelection)originalSelection);
        }
    }
}

