/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.preferences;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class REnvLabelProvider
extends ColumnLabelProvider {
    private final IObservableValue<? extends REnvConfiguration> defaultValue;
    private Image envIcon;
    private Image envDefaultIcon;
    private Image envRemoteIcon;
    private Image envRemoteDefaultIcon;

    public REnvLabelProvider(IObservableValue<? extends REnvConfiguration> defaultValue) {
        this.defaultValue = defaultValue;
    }

    private Image createIcon(Image baseImage) {
        Rectangle bounds = baseImage.getBounds();
        return new DecorationOverlayIcon(baseImage, new ImageDescriptor[5], new Point(bounds.width + 4, bounds.height)).createImage();
    }

    private Image createDefaultIcon(Image baseImage) {
        Rectangle bounds = baseImage.getBounds();
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[3] = SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/default_marker");
        return new DecorationOverlayIcon(baseImage, imageDescriptorArray, new Point(bounds.width + 4, bounds.height)).createImage();
    }

    public void dispose() {
        if (this.envIcon != null) {
            this.envIcon.dispose();
            this.envIcon = null;
        }
        if (this.envDefaultIcon != null) {
            this.envDefaultIcon.dispose();
            this.envDefaultIcon = null;
        }
        if (this.envRemoteIcon != null) {
            this.envRemoteIcon.dispose();
            this.envRemoteIcon = null;
        }
        if (this.envRemoteDefaultIcon != null) {
            this.envRemoteDefaultIcon.dispose();
            this.envRemoteDefaultIcon = null;
        }
    }

    public Image getImage(Object element) {
        REnvConfiguration config = (REnvConfiguration)element;
        if (config.isRemote()) {
            if (this.defaultValue.getValue() == config) {
                if (this.envRemoteDefaultIcon == null) {
                    this.envRemoteDefaultIcon = this.createDefaultIcon(RUI.getImage("org.eclipse.statet.r/images/obj/r_environment.remote"));
                }
                return this.envRemoteDefaultIcon;
            }
            if (this.envRemoteIcon == null) {
                this.envRemoteIcon = this.createIcon(RUI.getImage("org.eclipse.statet.r/images/obj/r_environment.remote"));
            }
            return this.envRemoteIcon;
        }
        if (this.defaultValue.getValue() == config) {
            if (this.envDefaultIcon == null) {
                this.envDefaultIcon = this.createDefaultIcon(RUI.getImage("org.eclipse.statet.r/images/obj/r_environment"));
            }
            return this.envDefaultIcon;
        }
        if (this.envIcon == null) {
            this.envIcon = this.createIcon(RUI.getImage("org.eclipse.statet.r/images/obj/r_environment"));
        }
        return this.envIcon;
    }

    public String getText(Object element) {
        REnvConfiguration config = (REnvConfiguration)element;
        return config.getName();
    }
}

