/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.sourcelookup;

import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.debug.ui.sourcelookup.Messages;
import org.eclipse.statet.r.debug.core.sourcelookup.RLibrarySourceContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RLibrarySourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        String location;
        EditContainerDialog dialog = new EditContainerDialog(shell, null);
        if (dialog.open() == 0 && (location = dialog.getResult()) != null) {
            return new ISourceContainer[]{new RLibrarySourceContainer(location)};
        }
        return new ISourceContainer[0];
    }

    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        return containers.length == 1;
    }

    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        String location;
        EditContainerDialog dialog = new EditContainerDialog(shell, ((RLibrarySourceContainer)containers[0]).getLocation());
        if (dialog.open() == 0 && (location = dialog.getResult()) != null) {
            return new ISourceContainer[]{new RLibrarySourceContainer(location)};
        }
        return containers;
    }

    private static class EditContainerDialog
    extends ExtStatusDialog {
        private ResourceInputComposite resourceControl;
        private final IObservableValue<String> resourceValue;

        public EditContainerDialog(Shell parent, String location) {
            super(parent, location == null ? 2 : 6);
            this.setTitle(location == null ? Messages.RLibrarySourceContainerBrowser_Add_title : Messages.RLibrarySourceContainerBrowser_Edit_title);
            this.resourceValue = new WritableValue((Object)location, String.class);
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setLayoutData((Object)new GridData(4, 128, true, true));
            area.setLayout((Layout)LayoutUtils.newDialogGrid((int)1));
            Composite composite = area;
            Label label = new Label(area, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText(Messages.RLibrarySourceContainerBrowser_Directory_label + ":");
            this.resourceControl = new ResourceInputComposite(composite, 0, 10, Messages.RLibrarySourceContainerBrowser_Directory_label);
            this.resourceControl.setShowInsertVariable(false, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = LayoutUtils.hintWidth((Text)((Text)this.resourceControl.getTextControl()), (int)60);
            this.resourceControl.setLayoutData((Object)gd);
            EditContainerDialog.applyDialogFont((Control)area);
            return area;
        }

        protected void addBindings(DataBindingSupport db) {
            db.getContext().bindValue(this.resourceControl.getObservable(), this.resourceValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.resourceControl.getValidator()), null);
        }

        public String getResult() {
            return (String)this.resourceValue.getValue();
        }
    }
}

