/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.rj.renv.core.RPkgType;

final class Cache {
    private static final String BAK_POSTFIX = "-bak";
    private final IFileStore binDir;
    private final IFileStore srcDir;

    public Cache(IFileStore parent) {
        this.binDir = parent.getChild("pkg-bin");
        this.srcDir = parent.getChild("pkg-src");
    }

    private void checkDir(IProgressMonitor monitor) throws CoreException {
        if (!this.binDir.fetchInfo().exists()) {
            this.binDir.mkdir(0, monitor);
        }
        if (!this.srcDir.fetchInfo().exists()) {
            this.srcDir.mkdir(0, monitor);
        }
    }

    public void add(String pkgName, RPkgType type, IFileStore store, IProgressMonitor monitor) throws CoreException {
        this.checkDir(monitor);
        IFileStore dir = type == RPkgType.SOURCE ? this.srcDir : this.binDir;
        String[] names = dir.childNames(0, monitor);
        String prefix = pkgName + "_";
        String oldName = null;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith(prefix)) {
                if (name.endsWith(BAK_POSTFIX) || oldName != null) {
                    this.removeBak(dir.getChild(name), monitor);
                } else {
                    oldName = name;
                }
            }
            ++n2;
        }
        if (oldName != null) {
            this.makeBak(dir.getChild(oldName), monitor);
        }
        store.copy(dir.getChild(store.getName()), 0, monitor);
    }

    private void removeBak(IFileStore file, IProgressMonitor monitor) throws CoreException {
        file.delete(0, monitor);
    }

    private void makeBak(IFileStore file, IProgressMonitor monitor) throws CoreException {
        file.move(file.getParent().getChild(file.getName() + BAK_POSTFIX), 2, monitor);
    }

    public IFileStore get(String pkgName, RPkgType type, IProgressMonitor monitor) throws CoreException {
        IFileStore dir = type == RPkgType.SOURCE ? this.srcDir : this.binDir;
        String[] names = dir.childNames(0, monitor);
        String prefix = pkgName + "_";
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith(prefix) && !name.endsWith(BAK_POSTFIX)) {
                return dir.getChild(name);
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "R package '" + pkgName + "' not available in local package cache.", null));
    }
}

