/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.viewer;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserSession;
import org.eclipse.statet.internal.r.apps.ui.viewer.AppBrowserView;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.apps.ui.RApp;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class AppBrowserPage
extends PageBookBrowserPage {
    public AppBrowserPage(AppBrowserView view, AppBrowserSession session) {
        super((ManagedPageBookView)view, (BrowserSession)session);
    }

    public void dispose() {
        super.dispose();
    }

    public AppBrowserSession getSession() {
        return (AppBrowserSession)super.getSession();
    }

    protected @Nullable Control createAddressBar(Composite parent) {
        return null;
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        handlers.addActivate("org.eclipse.debug.ui.commands.Terminate", (IHandler2)new StopAppHandler());
        handlers.addActivate("org.eclipse.debug.ui.commands.TerminateAndRelaunch", (IHandler2)new RestartAppHandler());
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("app.Control", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "org.eclipse.debug.ui.commands.TerminateAndRelaunch", "org.eclipse.debug.ui.commands.TerminateAndRelaunch", null, null, null, null, Messages.Action_RestartApp_label, null, Messages.Action_RestartApp_label, 8, null, false), handlers));
        toolBarManager.appendToGroup("app.Control", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "org.eclipse.debug.ui.commands.Terminate", "org.eclipse.debug.ui.commands.Terminate", null, null, null, null, Messages.Action_StopApp_label, null, Messages.Action_StopApp_label, 8, null, false), handlers));
    }

    private class RestartAppHandler
    extends AbstractHandler {
        private RestartAppHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            AppBrowserSession session = AppBrowserPage.this.getSession();
            RApp app = session.getLatestApp();
            this.setBaseEnabled(app != null && app.canRestartApp());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            try {
                AppBrowserSession session = AppBrowserPage.this.getSession();
                RApp app = session.getLatestApp();
                if (app != null) {
                    app.restartApp(AppBrowserPage.this.getSite().getPage());
                }
                return null;
            }
            catch (CoreException e) {
                return null;
            }
        }
    }

    private class StopAppHandler
    extends AbstractHandler {
        private StopAppHandler() {
        }

        public void setEnabled(@Nullable Object evaluationContext) {
            AppBrowserSession session = AppBrowserPage.this.getSession();
            RApp app = session.getLatestApp();
            this.setBaseEnabled(app != null && app.canStopApp());
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            AppBrowserSession session = AppBrowserPage.this.getSession();
            RApp app = session.getLatestApp();
            if (app != null) {
                app.stopApp();
            }
            return null;
        }
    }
}

