/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.setup;

import java.net.URI;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.TitleAreaStatusUpdater;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.IProgressInfo;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.util.AbstractConsoleCommandHandler;
import org.eclipse.statet.nico.ui.util.ToolDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@NonNullByDefault
public class ChooseFileHandler
extends AbstractConsoleCommandHandler {
    public static final String CHOOSE_FILE_COMMAND_ID = "common/chooseFile";

    public Status execute(String id, ConsoleService service, ToolCommandData data, ProgressMonitor m) {
        String s = data.getString("message");
        if (s == null) {
            IProgressInfo progressInfo = service.getController().getProgressInfo();
            s = NLS.bind((String)"Choose file (asked by {0}):", (Object)progressInfo.getLabel());
        }
        String message = s;
        boolean newFile = data.getBooleanRequired("newResource");
        @Nullable IFileStore file = (IFileStore)UIAccess.getDisplay().syncCall(() -> {
            ChooseFileDialog dialog = new ChooseFileDialog(UIAccess.getActiveWorkbenchShell((boolean)true), service.getTool(), message, newFile);
            dialog.setBlockOnOpen(true);
            return dialog.open() == 0 ? dialog.getResource() : null;
        });
        if (file == null) {
            return Status.CANCEL_STATUS;
        }
        String fileName = file.toString();
        data.setReturnData("filename", (Object)fileName);
        data.setReturnData("fileName", (Object)fileName);
        data.setReturnData("filePath", (Object)fileName);
        return Status.OK_STATUS;
    }

    private static class ChooseFileDialog
    extends ToolDialog {
        private final int mode;
        private final String message;
        private ResourceInputComposite locationGroup;
        private final WritableValue<String> newLocationValue;
        private final String historyId;

        public ChooseFileDialog(Shell shell, ToolProcess tool, String message, boolean newFile) {
            super(tool, shell, null, Messages.Util_ChooseFile_Dialog_title);
            IPath path;
            this.mode = newFile ? 5 : 9;
            this.message = message;
            this.historyId = "statet:" + this.getTool().getMainType() + ":location.commonfile";
            IFileStore current = this.getTool().getWorkspace().getWorkspaceDir();
            String dir = "";
            if (current != null && (path = URIUtil.toPath((URI)current.toURI())) != null) {
                dir = path.toOSString();
            }
            this.newLocationValue = new WritableValue((Object)dir, String.class);
        }

        @Override
        protected IDialogSettings getDialogSettings() {
            return DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)"tools/ChooseFileDialog");
        }

        @Override
        protected Control createDialogContent(Composite parent) {
            this.setTitle(this.message);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
            Composite inputComposite = new Composite(composite, 0);
            inputComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            inputComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            this.locationGroup = new ResourceInputComposite(inputComposite, 1, this.mode, Messages.Util_ChooseFile_File_label);
            this.locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            String[] history = this.getDialogSettings().getArray(this.historyId);
            this.locationGroup.setHistory(history);
            DataBindingSupport databinding = new DataBindingSupport((Control)composite);
            this.addBindings(databinding);
            this.newLocationValue.setValue((Object)(history != null && history.length > 0 ? history[0] : ""));
            databinding.installStatusListener((StatusChangeListener)new TitleAreaStatusUpdater((TitleAreaDialog)this, this.message));
            return composite;
        }

        protected void addBindings(DataBindingSupport db) {
            db.getContext().bindValue(this.locationGroup.getObservable(), this.newLocationValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.locationGroup.getValidator()), null);
        }

        protected void okPressed() {
            this.saveSettings();
            super.okPressed();
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)this.historyId, (String)((String)this.newLocationValue.getValue()));
        }

        public IFileStore getResource() {
            return this.locationGroup.getResourceAsFileStore();
        }
    }
}

