/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.statet.nico.core.runtime.ILogOutput;

class RuntimeProcessOutput
implements ILogOutput {
    private final StringBuilder fStringBuilder = new StringBuilder(4096);
    private StreamListener fOutputStreamListener;
    private StreamListener fErrorStreamListener;
    private final boolean fFlush;
    private final int fHighWater;
    private final int fLowWater;

    public RuntimeProcessOutput(IStreamsProxy proxy, boolean flush) {
        this.fFlush = flush;
        this.fHighWater = 65536;
        this.fLowWater = this.fHighWater - 4096;
        this.fOutputStreamListener = new StreamListener(proxy.getOutputStreamMonitor());
        this.fErrorStreamListener = new StreamListener(proxy.getErrorStreamMonitor());
        this.fOutputStreamListener.init();
        this.fErrorStreamListener.init();
    }

    private synchronized void append(String text) {
        if (text == null) {
            return;
        }
        if (this.fStringBuilder.length() + text.length() > this.fHighWater) {
            int idx = this.fStringBuilder.length() + text.length() - this.fLowWater;
            boolean found = false;
            while (idx < this.fStringBuilder.length()) {
                char c;
                if ((c = this.fStringBuilder.charAt(idx++)) == '\n' || c == '\r') {
                    found = true;
                    continue;
                }
                if (!found) continue;
                --idx;
                break;
            }
            this.fStringBuilder.delete(0, idx);
        }
        this.fStringBuilder.append(text);
    }

    public synchronized void dispose() {
        if (this.fOutputStreamListener != null) {
            this.fOutputStreamListener.dispose();
            this.fOutputStreamListener = null;
        }
        if (this.fErrorStreamListener != null) {
            this.fErrorStreamListener.dispose();
            this.fErrorStreamListener = null;
        }
    }

    @Override
    public synchronized String getOutput() {
        return this.fStringBuilder.toString();
    }

    private final class StreamListener
    implements IStreamListener {
        private final IStreamMonitor fStreamMonitor;
        private boolean fFlushed;

        private StreamListener(IStreamMonitor streamMonitor) {
            this.fStreamMonitor = streamMonitor;
            this.fStreamMonitor.addListener((IStreamListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(String text, IStreamMonitor monitor) {
            if (!this.fFlushed) {
                String contents = null;
                IStreamMonitor iStreamMonitor = this.fStreamMonitor;
                synchronized (iStreamMonitor) {
                    IStreamMonitor iStreamMonitor2;
                    this.fFlushed = true;
                    contents = this.fStreamMonitor.getContents();
                    if (RuntimeProcessOutput.this.fFlush && (iStreamMonitor2 = this.fStreamMonitor) instanceof IFlushableStreamMonitor) {
                        IFlushableStreamMonitor m = (IFlushableStreamMonitor)iStreamMonitor2;
                        m.flushContents();
                        m.setBuffered(false);
                    }
                }
                RuntimeProcessOutput.this.append(contents);
            } else {
                RuntimeProcessOutput.this.append(text);
            }
        }

        public void init() {
            this.streamAppended(null, this.fStreamMonitor);
        }

        public void dispose() {
            this.fStreamMonitor.removeListener((IStreamListener)this);
        }
    }
}

