/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;

public final class ResourceMapping
implements IResourceMapping {
    private String id;
    private final String localText;
    private final IFileStore fileStore;
    private final IPath remotePath;
    private final String hostName;
    private InetAddress[] hostAddress;

    private static String cleanDirectory(String path) {
        int idx = path.length() - 1;
        while (idx > 0) {
            char c = path.charAt(idx);
            if (c != '/' && c != '\\') break;
            --idx;
        }
        return path.substring(0, idx + 1);
    }

    public ResourceMapping(String id, String localPath, String hostname, String remotePath) throws CoreException {
        this.id = id;
        this.localText = localPath;
        this.fileStore = FileUtil.getFileStore((String)this.localText);
        this.hostName = hostname;
        this.remotePath = new Path(ResourceMapping.cleanDirectory(remotePath));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        assert (this.id == null);
        this.id = id;
    }

    public InetAddress[] getHostAddresses() {
        return this.hostAddress;
    }

    public void resolve() throws UnknownHostException {
        this.hostAddress = InetAddress.getAllByName(this.hostName);
    }

    public String getLocalText() {
        return this.localText;
    }

    public IFileStore getFileStore() {
        return this.fileStore;
    }

    public String getHost() {
        return this.hostName;
    }

    public IPath getRemotePath() {
        return this.remotePath;
    }
}

