/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.presentation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.core.conversion.ClassTypedConverter;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ColorSelectorObservableValue;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStoreConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.OverlayStorePreference;
import org.eclipse.statet.ecommons.preferences.ui.PreferenceStoreBeanWrapper;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.ecommons.text.ui.settings.JFaceTextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ecommons.text.ui.Messages;
import org.eclipse.statet.internal.ltk.ui.PreviewSourceViewer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

@NonNullByDefault
public abstract class AbstractTextStylesConfigurationBlock
extends OverlayStoreConfigurationBlock {
    private static final Class<List<SyntaxNode.UseStyle>> List_UseStyle_TYPE = List.class;
    private ImList<? extends SyntaxNode> rootNodes;
    private DataBindingContext dbc;
    private TreeViewer selectionViewer;
    private Set<String> groupIds;
    private ComboViewer useViewer;
    private Label colorLabel;
    private ColorSelector colorEditor;
    private Button boldCheckbox;
    private Button italicCheckbox;
    private Button strikethroughCheckbox;
    private Button underlineCheckbox;
    private PreferenceStoreTextStyleManager<TextAttribute> textStyles;
    protected SourceViewer previewViewer;
    private SourceEditorViewerConfiguration configuration;

    private static void collectKeys(List<OverlayStorePreference> keys, ImList<? extends SyntaxNode> nodes) {
        for (SyntaxNode node : nodes) {
            node.gatherPreferenceKeys(keys);
            AbstractTextStylesConfigurationBlock.collectKeys(keys, (ImList<? extends SyntaxNode>)node.getChildren());
        }
    }

    private static void connectStore(ImList<? extends SyntaxNode> nodes, IPreferenceStore store) {
        for (SyntaxNode node : nodes) {
            node.connectPreferenceStore(store);
            AbstractTextStylesConfigurationBlock.connectStore((ImList<? extends SyntaxNode>)node.getChildren(), store);
        }
    }

    protected abstract ImList<? extends SyntaxNode> createItems();

    protected abstract String getSettingsGroup();

    protected Set<String> getChangedGroups() {
        return this.groupIds;
    }

    protected String getLinkMessage() {
        return Messages.SyntaxColoring_link;
    }

    protected boolean isTextAttributesSupported() {
        return true;
    }

    protected void createBlockArea(Composite pageComposite) {
        this.rootNodes = this.createItems();
        this.groupIds = new HashSet<String>();
        this.groupIds.add(this.getSettingsGroup());
        ArrayList<OverlayStorePreference> keys = new ArrayList<OverlayStorePreference>();
        AbstractTextStylesConfigurationBlock.collectKeys(keys, this.rootNodes);
        this.setupOverlayStore(keys.toArray(new OverlayStorePreference[keys.size()]));
        AbstractTextStylesConfigurationBlock.connectStore(this.rootNodes, (IPreferenceStore)this.fOverlayStore);
        String message = this.getLinkMessage();
        if (message != null) {
            this.addLinkHeader(pageComposite, Messages.SyntaxColoring_link);
        }
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText(Messages.SyntaxColoring_List_label);
        Composite configComposite = new Composite(composite, 0);
        configComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        configComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Control selectionControl = this.createTreeViewer(configComposite);
        GridData gd = new GridData(4, 4, false, true);
        Point size = ViewerUtils.calculateTreeSizeHint((Control)this.selectionViewer.getControl(), this.rootNodes, (int)9);
        gd.widthHint = size.x;
        gd.heightHint = size.y;
        selectionControl.setLayoutData((Object)gd);
        Control optionControl = this.createOptionsControl(configComposite);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 5;
        optionControl.setLayoutData((Object)gd);
        Label label2 = new Label(composite, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(Messages.SyntaxColoring_Preview);
        Control previewerControl = this.createPreviewer(composite);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        PixelConverter conv = new PixelConverter(previewerControl);
        gd.widthHint = conv.convertWidthInCharsToPixels(40);
        gd.heightHint = conv.convertHeightInCharsToPixels(10);
        previewerControl.setLayoutData((Object)gd);
        this.initFields();
        this.initBindings();
        ViewerUtils.scheduleStandardSelection((TreeViewer)this.selectionViewer);
    }

    public Control createTreeViewer(Composite parent) {
        this.selectionViewer = new TreeViewer(parent, 2818);
        this.selectionViewer.setContentProvider((IContentProvider)new ViewerUtils.NodeContentProvider());
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new SyntaxNodeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.selectionViewer);
        ViewerUtils.addDoubleClickExpansion((TreeViewer)this.selectionViewer);
        return this.selectionViewer.getControl();
    }

    private Control createOptionsControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.useViewer = new ComboViewer(composite, 12);
        this.useViewer.setLabelProvider((IBaseLabelProvider)new UseStyleLabelProvider());
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.useViewer.getCombo(), (String[])new String[]{"XXXXXXXXXXXXXXX", Messages.SyntaxColoring_Use_CustomStyle_label, Messages.SyntaxColoring_Use_NoExtraStyle_label});
        this.useViewer.getControl().setLayoutData((Object)gd);
        int indent = LayoutUtils.defaultSmallIndent();
        Label label = new Label(composite, 0);
        GridData gd2 = new GridData(4, 0x1000000, false, false);
        gd2.horizontalIndent = indent;
        label.setLayoutData((Object)gd2);
        label.setText(Messages.SyntaxColoring_Color);
        this.colorLabel = label;
        this.colorEditor = new ColorSelector(composite);
        Button foregroundColorButton = this.colorEditor.getButton();
        foregroundColorButton.setLayoutData((Object)new GridData(32));
        this.boldCheckbox = new Button(composite, 32);
        GridData gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.boldCheckbox.setLayoutData((Object)gd3);
        this.boldCheckbox.setText(Messages.SyntaxColoring_Bold);
        this.italicCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.italicCheckbox.setLayoutData((Object)gd3);
        this.italicCheckbox.setText(Messages.SyntaxColoring_Italic);
        this.underlineCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.underlineCheckbox.setLayoutData((Object)gd3);
        this.underlineCheckbox.setText(Messages.SyntaxColoring_Underline);
        this.strikethroughCheckbox = new Button(composite, 32);
        gd3 = new GridData(4, 0x1000000, false, false);
        gd3.horizontalIndent = indent;
        this.strikethroughCheckbox.setLayoutData((Object)gd3);
        this.strikethroughCheckbox.setText(Messages.SyntaxColoring_Strikethrough);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, EditorsUI.getPreferenceStore()});
        this.previewViewer = new PreviewSourceViewer(parent, (IPreferenceStore)store);
        this.configuration = this.getSourceViewerConfiguration((IPreferenceStore)store);
        this.previewViewer.configure((SourceViewerConfiguration)this.configuration);
        String content = this.loadPreviewContentFromFile(this.getPreviewFileName());
        Document document = new Document(content);
        this.getDocumentSetupParticipant().setup((IDocument)document);
        this.previewViewer.setDocument((IDocument)document);
        return this.previewViewer.getControl();
    }

    protected abstract String getPreviewFileName();

    protected SourceEditorViewerConfiguration getSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        this.textStyles = new JFaceTextStyleManager(preferenceStore, this.getSettingsGroup());
        return this.getSourceEditorViewerConfiguration(preferenceStore, this.textStyles);
    }

    protected abstract SourceEditorViewerConfiguration getSourceEditorViewerConfiguration(IPreferenceStore var1, PreferenceStoreTextStyleManager<TextAttribute> var2);

    protected abstract IDocumentSetupParticipant getDocumentSetupParticipant();

    private String loadPreviewContentFromFile(String filename) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(filename);){
                return IOUtils.readContentString((InputStream)((InputStream)ObjectUtils.nonNullAssert((Object)in)), (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", -1, NLS.bind((String)"An error occurred when loading the preview code from ''{0}''.", (Object)filename), (Throwable)e));
            return "";
        }
    }

    public void initFields() {
        this.selectionViewer.setInput(this.rootNodes);
    }

    private void initBindings() {
        final Realm realm = Realm.getDefault();
        this.dbc = new DataBindingContext(realm);
        IViewerObservableValue selectionValue = ViewerProperties.singleSelection(SyntaxNode.class).observe((Viewer)this.selectionViewer);
        selectionValue.addValueChangeListener((IValueChangeListener)new IValueChangeListener<SyntaxNode>(){

            public void handleValueChange(ValueChangeEvent<? extends SyntaxNode> event) {
                SyntaxNode newNode = (SyntaxNode)((Object)event.diff.getNewValue());
                if (newNode != null) {
                    AbstractTextStylesConfigurationBlock.this.updateEnablement(newNode, newNode.getUseStyle());
                }
            }
        });
        IObservableList list = MasterDetailObservables.detailList((IObservableValue)BeanProperties.value((String)"availableUseStyles", List_UseStyle_TYPE).observeDetail((IObservableValue)selectionValue), (IObservableFactory)new IObservableFactory<List<SyntaxNode.UseStyle>, IObservableList<SyntaxNode.UseStyle>>(){

            public IObservableList<SyntaxNode.UseStyle> createObservable(List<SyntaxNode.UseStyle> target) {
                return Observables.staticObservableList((Realm)realm, target);
            }
        }, null);
        this.useViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.useViewer.setInput((Object)list);
        IObservableValue useStyleValue = BeanProperties.value((String)"useStyle", SyntaxNode.UseStyle.class).observeDetail((IObservableValue)selectionValue);
        useStyleValue.addValueChangeListener((IValueChangeListener)new IValueChangeListener<SyntaxNode.UseStyle>(){

            public void handleValueChange(ValueChangeEvent<? extends SyntaxNode.UseStyle> event) {
                IStructuredSelection selection = (IStructuredSelection)AbstractTextStylesConfigurationBlock.this.selectionViewer.getSelection();
                SyntaxNode.UseStyle newUse = (SyntaxNode.UseStyle)event.diff.getNewValue();
                AbstractTextStylesConfigurationBlock.this.updateEnablement((SyntaxNode)((Object)selection.getFirstElement()), newUse);
            }
        });
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(SyntaxNode.UseStyle.class).observe((Viewer)this.useViewer), useStyleValue);
        this.dbc.bindValue((IObservableValue)new ColorSelectorObservableValue(this.colorEditor), BeanProperties.value((String)"color", RGB.class).observeDetail((IObservableValue)selectionValue));
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.boldCheckbox), BeanProperties.value((String)"bold", Boolean.TYPE).observeDetail((IObservableValue)selectionValue), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)));
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.italicCheckbox), BeanProperties.value((String)"italic", Boolean.TYPE).observeDetail((IObservableValue)selectionValue), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)));
        if (this.isTextAttributesSupported()) {
            this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.strikethroughCheckbox), BeanProperties.value((String)"strikethrough", Boolean.TYPE).observeDetail((IObservableValue)selectionValue), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)));
            this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.underlineCheckbox), BeanProperties.value((String)"underline", Boolean.TYPE).observeDetail((IObservableValue)selectionValue), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)), UpdateValueStrategy.create((IConverter)ClassTypedConverter.createIdentity(Boolean.TYPE)));
        } else {
            this.strikethroughCheckbox.setVisible(false);
            this.underlineCheckbox.setVisible(false);
        }
    }

    private void updateEnablement(SyntaxNode node, SyntaxNode.UseStyle useStyle) {
        boolean enableOptions;
        int showOptions;
        if (node instanceof StyleNode) {
            this.useViewer.getControl().setEnabled(node.getAvailableUseStyles().size() > 1);
            showOptions = 2;
            enableOptions = useStyle != null && useStyle.getRefRootKey().equals("");
        } else if (node instanceof BackgroundNode) {
            this.useViewer.getControl().setEnabled(false);
            showOptions = 1;
            enableOptions = true;
        } else {
            this.useViewer.getControl().setEnabled(false);
            showOptions = 0;
            enableOptions = false;
        }
        this.colorLabel.setVisible(showOptions >= 1);
        this.colorEditor.getButton().setVisible(showOptions >= 1);
        this.colorLabel.setEnabled(enableOptions);
        this.colorEditor.setEnabled(enableOptions);
        this.boldCheckbox.setVisible(showOptions >= 2);
        this.boldCheckbox.setEnabled(enableOptions);
        this.italicCheckbox.setVisible(showOptions >= 2);
        this.italicCheckbox.setEnabled(enableOptions);
        if (this.isTextAttributesSupported()) {
            this.strikethroughCheckbox.setVisible(showOptions >= 2);
            this.strikethroughCheckbox.setEnabled(enableOptions);
            this.underlineCheckbox.setVisible(showOptions >= 2);
            this.underlineCheckbox.setEnabled(enableOptions);
        }
    }

    protected void handlePropertyChange() {
        if (UIAccess.isOkToUse((Viewer)this.previewViewer)) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.textStyles != null) {
                this.textStyles.handleSettingsChanged(this.groupIds, options);
            }
            this.configuration.handleSettingsChanged(this.groupIds, options);
            this.previewViewer.invalidateTextPresentation();
        }
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        super.dispose();
    }

    protected String addListToTooltip(String tooltip, List<String> items) {
        StringBuilder description = new StringBuilder(tooltip);
        int n = items.size();
        if (n > 20) {
            n = 19;
        }
        int i = 0;
        while (i < n) {
            description.append("\n    ");
            description.append(items.get(i));
            ++i;
        }
        if (n < items.size()) {
            description.append("\n    ... (" + items.size() + ")");
        }
        return MessageUtils.escapeForTooltip((CharSequence)description);
    }

    protected String addExtraStyleNoteToTooltip(String tooltip) {
        return NLS.bind((String)tooltip, (Object)Messages.SyntaxColoring_MindExtraStyle_tooltip);
    }

    protected static class BackgroundNode
    extends SyntaxNode {
        private final String rootKey;

        public BackgroundNode(String name, String description, String rootKey) {
            super(name, description, null, (ImList<SyntaxNode.UseStyle>)ImCollections.newList((Object)BackgroundNode.createUseCustomStyle()));
            this.rootKey = rootKey;
            ArrayList<SyntaxNode.PrefProperty> prefs = new ArrayList<SyntaxNode.PrefProperty>();
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new RGBPref(null, this.getColorKey()), "color"));
            this.setPreferences(prefs);
        }

        private String getColorKey() {
            return this.rootKey + ".color";
        }

        @Override
        public RGB getColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey());
        }

        @Override
        public void setColor(RGB color) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey(), (RGB)color);
        }
    }

    protected static class CategoryNode
    extends SyntaxNode {
        public CategoryNode(String name, SyntaxNode ... children) {
            super(name, null, (ImList<SyntaxNode>)ImCollections.newList((Object[])children), (ImList<SyntaxNode.UseStyle>)ImCollections.emptyList());
        }
    }

    protected static class StyleNode
    extends SyntaxNode {
        private final String rootKey;

        public StyleNode(String name, String description, String rootKey, ImList<SyntaxNode.UseStyle> availableStyles, SyntaxNode ... children) {
            super(name, description, (ImList<SyntaxNode>)(children != null ? ImCollections.newList((Object[])children) : null), availableStyles);
            this.rootKey = rootKey;
            ArrayList<SyntaxNode.PrefProperty> prefs = new ArrayList<SyntaxNode.PrefProperty>();
            if (this.getAvailableUseStyles().size() > 1) {
                prefs.add(new SyntaxNode.PrefProperty(new UseStylePref(null, this.getUseKey()), "useStyle"));
            }
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new RGBPref(null, this.getColorKey()), "color"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getBoldKey()), "bold"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getItalicKey()), "italic"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getUnderlineKey()), "underline"));
            prefs.add(new SyntaxNode.PrefProperty((Preference<?>)new Preference.BooleanPref(null, this.getStrikethroughKey()), "strikethrough"));
            this.setPreferences(prefs);
        }

        private String getUseKey() {
            return this.rootKey + ".use";
        }

        private String getColorKey() {
            return this.rootKey + ".color";
        }

        private String getBoldKey() {
            return this.rootKey + ".bold";
        }

        private String getItalicKey() {
            return this.rootKey + ".italic";
        }

        private String getUnderlineKey() {
            return this.rootKey + ".underline";
        }

        private String getStrikethroughKey() {
            return this.rootKey + ".strikethrough";
        }

        @Override
        public void setUseStyle(SyntaxNode.UseStyle useStyle) {
            if (useStyle != null) {
                this.getPreferenceStore().setValue(this.getUseKey(), useStyle.getRefRootKey());
            }
        }

        @Override
        public SyntaxNode.UseStyle getUseStyle() {
            return this.getUseStyle(this.getPreferenceStore().getString(this.getUseKey()));
        }

        @Override
        public RGB getColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey());
        }

        @Override
        public void setColor(RGB color) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorKey(), (RGB)color);
        }

        @Override
        public boolean isBold() {
            return this.getPreferenceStore().getBoolean(this.getBoldKey());
        }

        @Override
        public void setBold(boolean enabled) {
            this.getPreferenceStore().setValue(this.getBoldKey(), enabled);
        }

        @Override
        public boolean isItalic() {
            return this.getPreferenceStore().getBoolean(this.getItalicKey());
        }

        @Override
        public void setItalic(boolean enabled) {
            this.getPreferenceStore().setValue(this.getItalicKey(), enabled);
        }

        @Override
        public boolean isStrikethrough() {
            return this.getPreferenceStore().getBoolean(this.getStrikethroughKey());
        }

        @Override
        public void setStrikethrough(boolean enabled) {
            this.getPreferenceStore().setValue(this.getStrikethroughKey(), enabled);
        }

        @Override
        public boolean isUnderline() {
            return this.getPreferenceStore().getBoolean(this.getUnderlineKey());
        }

        @Override
        public void setUnderline(boolean enabled) {
            this.getPreferenceStore().setValue(this.getUnderlineKey(), enabled);
        }

        public class UseStylePref
        extends Preference<SyntaxNode.UseStyle> {
            UseStylePref(String qualifier, String key) {
                super(qualifier, key);
            }

            public Class<SyntaxNode.UseStyle> getUsageType() {
                return SyntaxNode.UseStyle.class;
            }

            public SyntaxNode.UseStyle store2Usage(@Nullable String storeValue) {
                return StyleNode.this.getUseStyle(storeValue);
            }

            public String usage2Store(SyntaxNode.UseStyle usageValue) {
                return usageValue.getRefRootKey();
            }
        }
    }

    protected static abstract class SyntaxNode
    extends ViewerUtils.Node<SyntaxNode> {
        public static final String PROP_USE = "useStyle";
        public static final String PROP_COLOR = "color";
        public static final String PROP_BOLD = "bold";
        public static final String PROP_ITALIC = "italic";
        public static final String PROP_STRIKETHROUGH = "strikethrough";
        public static final String PROP_UNDERLINE = "underline";
        private final @Nullable String description;
        private final ImList<UseStyle> availableStyles;
        private IPreferenceStore preferenceStore = (IPreferenceStore)ObjectUtils.nonNullLateInit();
        private ImList<PrefProperty> preferences = ImCollections.emptyList();
        private PreferenceStoreBeanWrapper beanSupport = (PreferenceStoreBeanWrapper)ObjectUtils.nonNullLateInit();

        public static UseStyle createUseCustomStyle() {
            return new UseStyle("", Messages.SyntaxColoring_Use_CustomStyle_label);
        }

        public static UseStyle createUseNoExtraStyle(String parentKey) {
            return new UseStyle(parentKey, Messages.SyntaxColoring_Use_NoExtraStyle_label);
        }

        public static UseStyle createUseOtherStyle(String otherKey, String otherLabel) {
            return new UseStyle(otherKey, NLS.bind((String)Messages.SyntaxColoring_Use_OtherStyle_label, (Object)otherLabel));
        }

        public static UseStyle createUseOtherStyle(String otherKey, String cat, String otherLabel) {
            return new UseStyle(otherKey, NLS.bind((String)Messages.SyntaxColoring_Use_OtherStyleOf_label, (Object)otherLabel, (Object)cat));
        }

        private SyntaxNode(String name, @Nullable String description, @Nullable ImList<SyntaxNode> children, ImList<UseStyle> availableStyles) {
            super(name, children);
            this.description = description;
            this.availableStyles = (ImList)ObjectUtils.nonNullAssert(availableStyles);
        }

        protected void setPreferences(List<PrefProperty> prefs) {
            this.preferences = ImCollections.toList(prefs);
        }

        public @Nullable String getDescription() {
            return this.description;
        }

        protected void gatherPreferenceKeys(List<OverlayStorePreference> keys) {
            for (PrefProperty pref : this.preferences) {
                keys.add(OverlayStorePreference.create(pref.pref));
            }
        }

        protected void connectPreferenceStore(IPreferenceStore store) {
            this.preferenceStore = store;
            this.beanSupport = new PreferenceStoreBeanWrapper(store, (Object)this);
            for (PrefProperty pref : this.preferences) {
                this.beanSupport.addPreference(pref.prop, pref.pref);
            }
        }

        protected IPreferenceStore getPreferenceStore() {
            return this.preferenceStore;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.beanSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.beanSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.beanSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.beanSupport.removePropertyChangeListener(propertyName, listener);
        }

        public ImList<UseStyle> getAvailableUseStyles() {
            return this.availableStyles;
        }

        public @Nullable UseStyle getUseStyle() {
            return !this.availableStyles.isEmpty() ? (UseStyle)this.availableStyles.get(0) : null;
        }

        protected UseStyle getUseStyle(@Nullable String value) {
            for (UseStyle style : this.availableStyles) {
                if (!style.getRefRootKey().equals(value)) continue;
                return style;
            }
            return (UseStyle)this.availableStyles.get(0);
        }

        public void setUseStyle(UseStyle useStyle) {
        }

        public @Nullable RGB getColor() {
            return null;
        }

        public void setColor(RGB color) {
        }

        public boolean isBold() {
            return false;
        }

        public void setBold(boolean enabled) {
        }

        public boolean isItalic() {
            return false;
        }

        public void setItalic(boolean enabled) {
        }

        public boolean isStrikethrough() {
            return false;
        }

        public void setStrikethrough(boolean enabled) {
        }

        public boolean isUnderline() {
            return false;
        }

        public void setUnderline(boolean enabled) {
        }

        protected static class PrefProperty {
            public final Preference<?> pref;
            public final String prop;

            public PrefProperty(Preference<?> pref, String prop) {
                this.pref = pref;
                this.prop = prop;
            }
        }

        public static class UseStyle {
            private final String label;
            private final String refRootKey;

            public UseStyle(String refRootKey, String label) {
                this.refRootKey = refRootKey;
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }

            public String getRefRootKey() {
                return this.refRootKey;
            }
        }
    }

    private static class SyntaxNodeLabelProvider
    extends CellLabelProvider {
        private SyntaxNodeLabelProvider() {
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public @Nullable String getToolTipText(Object element) {
            return ((SyntaxNode)((Object)element)).getDescription();
        }

        public void update(ViewerCell cell) {
            cell.setText(((SyntaxNode)((Object)cell.getElement())).getName());
        }
    }

    private static class UseStyleLabelProvider
    extends LabelProvider {
        private UseStyleLabelProvider() {
        }

        public String getText(Object element) {
            SyntaxNode.UseStyle style = (SyntaxNode.UseStyle)element;
            return style.getLabel();
        }
    }
}

