/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.ecommons.runtime.core.util.PathUtils;
import org.eclipse.statet.internal.ltk.ui.LtkUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class PathCompletionComputor
implements ContentAssistComputer {
    private int searchMatchRules;
    private char fileSeparator;
    private char fileSeparatorBackup;
    private boolean isWindows;

    @Override
    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
        this.isWindows = this.getIsWindows();
        this.fileSeparator = this.getDefaultFileSeparator();
    }

    @Override
    public void onSessionEnded() {
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    protected boolean getIsWindows() {
        return SystemUtils.getLocalOs() == 1;
    }

    protected final boolean isWindows() {
        return this.isWindows;
    }

    protected char getDefaultFileSeparator() {
        return this.isWindows() ? (char)'\\' : '/';
    }

    protected char getSegmentSeparator() {
        return this.fileSeparator;
    }

    @Override
    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            String completionPrefix;
            IPath basePath;
            IPath path;
            int offset = context.getInvocationOffset();
            TextRegion contentRange = this.getContentRegion(context, mode);
            if (contentRange == null || offset < contentRange.getStartOffset() || offset > contentRange.getEndOffset()) {
                return;
            }
            String prefix = this.getPrefix(context, contentRange, offset);
            if (prefix == null) {
                return;
            }
            boolean needSeparatorBeforeStart = false;
            String segmentPrefix = "";
            if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '.') {
                if (prefix.equals(".") || prefix.endsWith("/.") || this.isWindows() && prefix.endsWith("\\.")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                    segmentPrefix = ".";
                } else if (prefix.equals("..") || prefix.endsWith("/..") || this.isWindows() && prefix.endsWith("\\..")) {
                    prefix = prefix.substring(0, prefix.length() - 2);
                    segmentPrefix = "..";
                }
            }
            if ((path = this.createPath(prefix)) == null) {
                return;
            }
            if (path.segmentCount() == 0) {
                if (this.isWindows() && path.getDevice() != null && !path.isRoot()) {
                    path = path.addTrailingSeparator();
                    needSeparatorBeforeStart = true;
                }
            } else if (segmentPrefix.isEmpty() && !path.hasTrailingSeparator()) {
                segmentPrefix = path.lastSegment();
                path = path.removeLastSegments(1);
            }
            if (path.isAbsolute() && this.isWindows() && path.getDevice() == null && !path.isUNC() && (basePath = this.getRelativeBasePath()) != null) {
                path = path.setDevice(basePath.getDevice());
            }
            IFileStore baseStore = this.resolveStore(path);
            this.updatePathSeparator(prefix);
            String string = completionPrefix = needSeparatorBeforeStart ? Character.toString(this.fileSeparator) : null;
            if (baseStore == null || !baseStore.fetchInfo().exists()) {
                this.tryAlternative(context, path, offset - segmentPrefix.length(), segmentPrefix, completionPrefix, proposals);
                return;
            }
            SourceProposal.ProposalParameters<?> parameters = this.createProposalParameters(context, offset - segmentPrefix.length(), segmentPrefix);
            this.doAddChildren(parameters, baseStore, completionPrefix, proposals);
            if (!segmentPrefix.isEmpty() && !segmentPrefix.equals(".") && (baseStore = baseStore.getChild(segmentPrefix)).fetchInfo().exists()) {
                StringBuilder prefixBuilder = new StringBuilder();
                if (completionPrefix != null) {
                    prefixBuilder.append(completionPrefix);
                }
                prefixBuilder.append(baseStore.getName());
                prefixBuilder.append(this.fileSeparator);
                completionPrefix = prefixBuilder.toString();
                SourceProposal.ProposalParameters<?> parameters2 = this.createProposalParameters(context, offset - segmentPrefix.length(), "");
                parameters2.baseRelevance = 20;
                this.doAddChildren(parameters2, baseStore, completionPrefix, proposals);
            }
            return;
        }
        catch (CoreException | BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, "An error occurred while preparing path completions.", e), 1);
        }
        finally {
            this.restorePathSeparator();
        }
    }

    @Override
    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
    }

    protected @Nullable String getPrefix(AssistInvocationContext context, TextRegion contentRegion, int offset) throws BadLocationException {
        return this.checkPrefix(context.getSourceViewer().getDocument().get(contentRegion.getStartOffset(), offset - contentRegion.getStartOffset()));
    }

    protected @Nullable String checkPrefix(@Nullable String prefix) {
        if (prefix == null) {
            return null;
        }
        char[] breakingChars = "\n\r+<>|?*\"".toCharArray();
        int i = 0;
        while (i < breakingChars.length) {
            if (prefix.indexOf(breakingChars[i]) >= 0) {
                return null;
            }
            ++i;
        }
        return prefix;
    }

    private @Nullable IPath createPath(String s) {
        if (this.isWindows() && File.separatorChar == '/') {
            s = s.replace('\\', '/');
        }
        return PathUtils.check((IPath)new Path(s));
    }

    private void updatePathSeparator(String prefix) {
        int lastForw;
        int lastBack = prefix.lastIndexOf(92);
        if (lastBack > (lastForw = prefix.lastIndexOf(47))) {
            this.fileSeparatorBackup = this.fileSeparator;
            this.fileSeparator = (char)92;
        } else if (lastForw > lastBack) {
            this.fileSeparatorBackup = this.fileSeparator;
            this.fileSeparator = (char)47;
        }
    }

    private void restorePathSeparator() {
        if (this.fileSeparatorBackup != '\u0000') {
            this.fileSeparator = this.fileSeparatorBackup;
            this.fileSeparatorBackup = '\u0000';
        }
    }

    protected SourceProposal.ProposalParameters<?> createProposalParameters(AssistInvocationContext context, int replacementOffset, String pattern) {
        SourceProposal.ProposalParameters<AssistInvocationContext> parameters = new SourceProposal.ProposalParameters<AssistInvocationContext>(context, replacementOffset, new SearchPattern(this.getSearchMatchRules(), pattern));
        parameters.baseRelevance = 20;
        return parameters;
    }

    protected void doAddChildren(SourceProposal.ProposalParameters<? extends AssistInvocationContext> parameters, IFileStore baseStore, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        IContainer[] workspaceRefs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(baseStore.toURI());
        IContainer workspaceRef = workspaceRefs.length > 0 ? workspaceRefs[0] : null;
        String[] names = baseStore.childNames(0, (IProgressMonitor)new NullProgressMonitor());
        Arrays.sort(names, Collator.getInstance());
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (parameters.matchesNamePattern(name)) {
                proposals.add(new ResourceCompletionProposal(parameters, baseStore.getChild(name), null, completionPrefix, workspaceRef));
            }
            ++n2;
        }
    }

    protected abstract @Nullable TextRegion getContentRegion(AssistInvocationContext var1, int var2) throws BadLocationException;

    protected @Nullable IPath getRelativeBasePath() {
        return null;
    }

    protected @Nullable IFileStore getRelativeBaseStore() {
        return null;
    }

    protected @Nullable IFileStore resolveStore(IPath path) throws CoreException {
        if (!path.isAbsolute()) {
            if (!this.isWindows() && path.getDevice() == null && "~".equals(path.segment(0))) {
                Path homePath = new Path(System.getProperty("user.home"));
                path = PathUtils.check((IPath)homePath.append(path.removeFirstSegments(1)));
            } else {
                IFileStore base = this.getRelativeBaseStore();
                if (base != null) {
                    return base.getFileStore(path);
                }
                return null;
            }
        }
        return EFS.getStore((URI)URIUtil.toURI((IPath)path));
    }

    protected void tryAlternative(AssistInvocationContext context, IPath path, int startOffset, String segmentPrefix, @Nullable String completionPrefix, AssistProposalCollector proposals) throws CoreException {
    }

    protected String checkPathCompletion(IDocument document, int completionOffset, String completion) {
        return completion;
    }

    protected class ResourceCompletionProposal
    extends SourceProposal<AssistInvocationContext> {
        private final IFileStore fileStore;
        private final boolean isDirectory;
        private final @Nullable IContainer workspaceRef;
        private final String name;
        private @Nullable String completion;

        public ResourceCompletionProposal(SourceProposal.ProposalParameters<? extends AssistInvocationContext> parameters, IFileStore fileStore, String explicitName, @Nullable String prefix, IContainer workspaceRef) {
            super(parameters);
            this.fileStore = fileStore;
            this.isDirectory = this.fileStore.fetchInfo().isDirectory();
            this.workspaceRef = workspaceRef;
            StringBuilder name = new StringBuilder(explicitName != null ? explicitName : this.fileStore.getName());
            if (prefix != null) {
                name.insert(0, prefix);
            }
            if (this.isDirectory) {
                name.append(PathCompletionComputor.this.fileSeparator);
            }
            this.name = name.toString();
        }

        @Override
        protected String getName() {
            return this.name;
        }

        @Override
        public String getSortingString() {
            return this.name;
        }

        @Override
        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = ((AssistInvocationContext)this.getInvocationContext()).getSourceViewer().getDocument();
                int length = document.getLength();
                while (end < length) {
                    char c = document.getChar(end);
                    if (!Character.isLetterOrDigit(c) && c != '_' && c != '.') break;
                    ++end;
                }
                if (end >= length) {
                    end = length;
                }
            }
            return end - replacementOffset;
        }

        @Override
        public Image getImage() {
            IResource member;
            Image image = null;
            if (this.workspaceRef != null && (member = this.workspaceRef.findMember(this.fileStore.getName(), true)) != null) {
                image = LtkUIPlugin.getInstance().getWorkbenchLabelProvider().getImage((Object)member);
            }
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage(this.isDirectory ? "IMG_OBJ_FOLDER" : "IMG_OBJ_FILE");
            }
            return image;
        }

        private String getCompletion() {
            String completion = this.completion;
            if (completion == null) {
                Object context = this.getInvocationContext();
                IDocument document = ((AssistInvocationContext)context).getDocument();
                this.completion = completion = PathCompletionComputor.this.checkPathCompletion(document, this.getReplacementOffset(), this.name);
            }
            return completion;
        }

        @Override
        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return this.getCompletion();
        }

        @Override
        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            Object context = this.getInvocationContext();
            IDocument document = ((AssistInvocationContext)context).getDocument();
            SourceProposal.ApplyData applyData = this.getApplyData();
            String replacement = this.getCompletion();
            Position newSelectionOffset = new Position(replacementOffset + replacementLength, 0);
            try {
                document.addPosition(newSelectionOffset);
                document.replace(replacementOffset, newSelectionOffset.getOffset() - replacementOffset, replacement);
                applyData.setSelection(newSelectionOffset.getOffset());
            }
            finally {
                document.removePosition(newSelectionOffset);
            }
            if (this.isDirectory) {
                this.reinvokeAssist();
            }
        }
    }
}

