/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class InfoHoverDescriptor {
    private final String id;
    private final String name;
    int stateMask;
    boolean isEnabled;
    private final IConfigurationElement configurationElement;

    InfoHoverDescriptor(String id, String name, IConfigurationElement configurationElement) {
        this.id = id;
        this.name = name;
        this.configurationElement = configurationElement;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable InfoHover createHover() {
        try {
            return (InfoHover)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", 0, "Could not create text hover '" + this.name + "'.", (Throwable)e));
            return null;
        }
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.id.equals(((InfoHoverDescriptor)obj).getId());
    }
}

