/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.statet.internal.ltk.ui.sourceediting.AnnotationPresentationConfig;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.issues.core.Issue;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.SourceIssueEditorAnnotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

@NonNullByDefault
final class SourceIssueMarkerAnnotation<TIssue extends Issue>
extends MarkerAnnotation
implements SourceIssueAnnotation<TIssue>,
IAnnotationPresentation {
    final IssueTypeSet.IssueCategory<TIssue> issueCategory;
    private @Nullable SourceIssueEditorAnnotation overlay;
    private boolean isControlled;
    private final AnnotationPresentationConfig presentationConfig;

    public SourceIssueMarkerAnnotation(IssueTypeSet.IssueCategory<TIssue> issueCategory, String type, IMarker marker) {
        super(type, marker);
        this.issueCategory = issueCategory;
        this.presentationConfig = SourceIssueEditorAnnotation.getIssuePresentationConfig(issueCategory, type);
    }

    @Override
    public IssueTypeSet.IssueCategory<TIssue> getIssueCategory() {
        return this.issueCategory;
    }

    boolean isControlled() {
        return this.isControlled;
    }

    @Override
    public boolean isMarkedDeleted() {
        return this.isControlled || super.isMarkedDeleted();
    }

    @Override
    public @Nullable SourceIssueAnnotation<TIssue> getOverlay() {
        return this.overlay;
    }

    @Override
    public ImList<Annotation> getOverlaidAnnotations() {
        return ImCollections.emptyList();
    }

    void disableOverlay() {
        this.isControlled = false;
        SourceIssueEditorAnnotation prev = this.overlay;
        if (prev != null) {
            prev.removeOverlaidAnnotation((Annotation)this);
        }
        this.overlay = null;
    }

    void setOverlay(@Nullable SourceIssueEditorAnnotation annotation) {
        this.isControlled = true;
        SourceIssueEditorAnnotation prev = this.overlay;
        if (prev != null) {
            prev.removeOverlaidAnnotation((Annotation)this);
        }
        this.overlay = annotation;
        if (annotation != null) {
            annotation.addOverlaidAnnotation((Annotation)this);
        }
    }

    public int getLayer() {
        return super.getLayer();
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        if (this.getOverlay() != null) {
            return;
        }
        super.paint(gc, canvas, r);
    }

    protected @Nullable Image getImage(Display display) {
        Image image = this.isMarkedDeleted() ? this.presentationConfig.getAwayImage() : this.presentationConfig.getImage();
        if (image != null) {
            return image;
        }
        return super.getImage(display);
    }
}

