/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.ui.refactoring.AbstractElementsHandler;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

public class CutElementsHandler
extends AbstractElementsHandler {
    public CutElementsHandler(CommonRefactoringFactory refactoring) {
        super(refactoring);
    }

    public void setEnabled(Object context) {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)context);
        if (selection != null) {
            this.setBaseEnabled(!selection.isEmpty());
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object[] sourceElements = LTKSelectionUtils.getSelectedSourceStructElements(selection);
        if (sourceElements != null) {
            RefactoringAdapter adapter = this.refactoring.createAdapter((Object)sourceElements);
            if (adapter == null) {
                return null;
            }
            try {
                String code = adapter.getSourceCodeStringedTogether((SourceStructElement[])sourceElements, null);
                if (this.copyToClipboard(event, code)) {
                    IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
                    IWorkbenchPartSite site = activePart.getSite();
                    Shell shell = site.getShell();
                    IProgressService progressService = (IProgressService)site.getService(IProgressService.class);
                    this.startCutRefactoring(sourceElements, adapter, shell, progressService);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, adapter.getPluginIdentifier(), -1, Messages.CutElements_error_message, (Throwable)e), 3);
            }
            catch (InvocationTargetException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, adapter.getPluginIdentifier(), -1, Messages.CutElements_error_message, e.getCause()), 3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    private void startCutRefactoring(Object[] elements, RefactoringAdapter adapter, Shell shell, IProgressService context) throws InvocationTargetException, InterruptedException {
        DeleteProcessor processor = this.refactoring.createDeleteProcessor((Object)elements, adapter);
        if (processor == null) {
            return;
        }
        DeleteRefactoring refactoring = new DeleteRefactoring(processor);
        RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)refactoring, RefactoringCore.getConditionCheckingFailedSeverity(), shell, context);
        helper.perform(false, false);
    }
}

