/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ProcessUtils {
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"", 16);
    private static final String DOUBLE_QUOTE_REPLACEMENT = "\\\\\"";

    public static String generateCommandLine(List<String> command) {
        if (command.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : command) {
            String escaped = DOUBLE_QUOTE_PATTERN.matcher(arg).replaceAll(DOUBLE_QUOTE_REPLACEMENT);
            if (escaped.indexOf(32) >= 0) {
                sb.append('\"');
                sb.append(escaped);
                sb.append('\"');
            } else {
                sb.append(escaped);
            }
            sb.append(' ');
        }
        return sb.substring(0, sb.length() - 1);
    }

    private ProcessUtils() {
    }
}

