/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.collections.CategoryElementList;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.jcommons.collections.SortedListSet;

public class TextSearchResultMatchTableContentProvider<E, M extends Match>
extends TextSearchResultContentProvider<E, M, TableViewer> {
    protected final ElementMatchComparator<E, M> comparator;
    private final CategoryElementList<E, M> currentMatches;

    public TextSearchResultMatchTableContentProvider(ExtTextSearchResultPage<E, M> page, TableViewer viewer) {
        super(page, viewer);
        this.comparator = page.comparator;
        this.currentMatches = new CategoryElementList((Object[])this.comparator.getMatch0(), this.comparator);
    }

    @Override
    protected void reset() {
        super.reset();
        this.currentMatches.clear();
    }

    public Object[] getElements(Object inputElement) {
        if (!this.active) {
            ExtTextSearchResult result = this.getInput();
            assert (result == inputElement);
            if (result == null) {
                return NO_ELEMENTS;
            }
            assert (this.currentMatches.isEmpty());
            int limit = this.getElementLimit();
            E[] elements = result.getElements();
            int i = 0;
            while (i < elements.length && limit > 0) {
                Object element = elements[i];
                Object[] matches = result.getPickedMatches(element);
                this.currentMatches.addAllE(this.currentMatches.size(), matches, 0, Math.min(matches.length, limit));
                limit -= matches.length;
                ++i;
            }
            this.active = true;
        }
        return this.currentMatches.toArray();
    }

    @Override
    public void elementsChanged(Object[] elements) {
        if (!this.active) {
            return;
        }
        ExtTextSearchResult result = this.getInput();
        int limit = this.getElementLimit();
        TableViewer viewer = (TableViewer)this.getViewer();
        ArrayList<Match> toAdd = new ArrayList<Match>();
        ArrayList<Match> toUpdate = new ArrayList<Match>();
        ArrayList<Match> toRemove = new ArrayList<Match>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            Match[] matches = result.getPickedMatches(element);
            SortedListSet currentElementMatches = this.currentMatches.subList(element);
            int j = 0;
            while (j < matches.length) {
                int k;
                Match match = matches[j];
                if (this.currentMatches.size() < limit) {
                    k = currentElementMatches.addE((Object)match);
                    if (k >= 0) {
                        toAdd.add(match);
                    } else {
                        toUpdate.add(match);
                        k = -(k + 1);
                    }
                } else {
                    k = currentElementMatches.indexOf((Object)match);
                    if (k >= 0) {
                        toUpdate.add(match);
                    } else {
                        k = -(k + 1);
                    }
                }
                while (k > j) {
                    toRemove.add((Match)currentElementMatches.remove(j));
                    --k;
                }
                ++j;
            }
            while (currentElementMatches.size() > matches.length) {
                currentElementMatches.remove(matches.length);
            }
            ++i;
        }
        viewer.getTable().setRedraw(false);
        try {
            viewer.remove(toRemove.toArray());
            viewer.refresh((Object)toUpdate.toArray(), true);
            viewer.add(toAdd.toArray());
        }
        finally {
            viewer.getTable().setRedraw(true);
        }
    }
}

