/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportSelectDimPositionsCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ViewportSelectDimPositionsCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectDimPositionsCommand> {
    private final AbstractLayer viewportLayer;
    private final @Nullable Orientation orientation;

    public ViewportSelectDimPositionsCommandHandler(AbstractLayer viewportLayer) {
        this(viewportLayer, null);
    }

    public ViewportSelectDimPositionsCommandHandler(AbstractLayer viewportLayer, @Nullable Orientation orientation) {
        this.viewportLayer = viewportLayer;
        this.orientation = orientation;
    }

    @Override
    public Class<ViewportSelectDimPositionsCommand> getCommandClass() {
        return ViewportSelectDimPositionsCommand.class;
    }

    @Override
    protected boolean doCommand(ViewportSelectDimPositionsCommand command) {
        if (this.orientation != null && command.getOrientation() != this.orientation) {
            return false;
        }
        this.viewportLayer.doCommand(new SelectDimPositionsCommand((LayerDim)this.viewportLayer.getDim(command.getOrientation()), command.getRefPosition(), command.getPositions(), 0L, command.getSelectionFlags(), command.getPositionToReveal()));
        return true;
    }
}

