/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.events.StructuralDiff;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.ecommons.waltable.viewport.swt.ScrollBarHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
class ViewportLayerDimImpl
extends ViewportLayerDim {
    private long minimumOriginPosition;
    private long minimumOriginPixel;
    private long originPixel;
    private long cachedClientAreaSize;
    private long cachedOriginPosition;
    private int cachedOriginPositionPixelShift;
    private long cachedPositionCount;
    private long cachedSize;
    private @Nullable ScrollBarHandler scrollBarAdapter;

    public ViewportLayerDimImpl(ViewportLayer layer, LayerDim underlyingDim) {
        super(layer, underlyingDim);
        this.invalidateStructure();
    }

    protected void dispose() {
        if (this.scrollBarAdapter != null) {
            this.scrollBarAdapter.dispose();
            this.scrollBarAdapter = null;
        }
    }

    protected long getClientAreaSize() {
        long clientAreaSize = ((ViewportLayer)this.layer).getClientAreaProvider().getClientArea().getSize(this.orientation);
        if (clientAreaSize != this.cachedClientAreaSize) {
            this.invalidateStructure();
            this.cachedClientAreaSize = clientAreaSize;
        }
        return this.cachedClientAreaSize;
    }

    protected void invalidateStructure() {
        this.cachedClientAreaSize = 0L;
        this.cachedOriginPosition = -1L;
        this.cachedOriginPositionPixelShift = 0;
        this.cachedPositionCount = -1L;
        this.cachedSize = -1L;
    }

    @Override
    public long getPositionCount() {
        if (((ViewportLayer)this.layer).isViewportOff()) {
            return Math.max(this.underlyingDim.getPositionCount() - this.getMinimumOriginPosition(), 0L);
        }
        if (this.cachedPositionCount < 0L) {
            this.recalculateAvailableSizeAndPositionCount();
        }
        return this.cachedPositionCount;
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        if (refPosition < 0L) {
            throw PositionOutOfBoundsException.refPosition(refPosition, this.getOrientation());
        }
        return this.getOriginPosition() + position;
    }

    @Override
    protected long doUnderlyingToLocalPosition(long underlyingPosition) {
        return underlyingPosition - this.getOriginPosition();
    }

    protected void recalculateAvailableSizeAndPositionCount() {
        long availableSize = this.getClientAreaSize();
        this.cachedSize = Math.min(this.getUnderlyingSize(), availableSize);
        this.originPixel = this.boundsCheckOrigin(this.originPixel);
        long positionBound = this.underlyingDim.getPositionCount();
        this.cachedOriginPosition = this.getMinimumOriginPosition() < positionBound ? this.underlyingDim.getPositionByPixel(this.getOriginPixel()) : 0L;
        this.cachedPositionCount = 0L;
        long position = this.cachedOriginPosition;
        if (position >= 0L && position < positionBound) {
            this.cachedOriginPositionPixelShift = (int)(this.getOriginPixel() - this.underlyingDim.getPositionStart(position));
            availableSize += (long)this.cachedOriginPositionPixelShift;
        }
        while (position >= 0L && position < positionBound && availableSize > 0L) {
            int positionSize = this.underlyingDim.getPositionSize(position);
            availableSize -= (long)positionSize;
            ++position;
            ++this.cachedPositionCount;
        }
    }

    private long getUnderlyingSize() {
        long offsetPosition = this.getMinimumOriginPosition();
        if (offsetPosition >= this.underlyingDim.getPositionCount()) {
            return 0L;
        }
        return this.underlyingDim.getSize() - this.underlyingDim.getPositionStart(offsetPosition);
    }

    @Override
    public long getSize() {
        if (((ViewportLayer)this.layer).isViewportOff()) {
            return this.getUnderlyingSize();
        }
        if (this.cachedSize < 0L) {
            this.recalculateAvailableSizeAndPositionCount();
        }
        return this.cachedSize;
    }

    @Override
    public long getPositionByPixel(long pixel) {
        return super.getPositionByPixel(this.getOriginPixel() + pixel);
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        return super.getPositionStart(refPosition, position) - this.getOriginPixel();
    }

    @Override
    public long getPositionStart(long position) {
        return super.getPositionStart(position) - this.getOriginPixel();
    }

    @Override
    public final LayerDim getScrollable() {
        return this.underlyingDim;
    }

    @Override
    public long getMinimumOriginPixel() {
        return this.minimumOriginPixel;
    }

    @Override
    public long getMinimumOriginPosition() {
        return this.minimumOriginPosition;
    }

    @Override
    public void setMinimumOriginPosition(long scrollablePosition) {
        long pixel;
        if (scrollablePosition < 0L || scrollablePosition > this.underlyingDim.getPositionCount()) {
            throw new PositionOutOfBoundsException("scrollablePosition: " + scrollablePosition);
        }
        long l = pixel = scrollablePosition < this.underlyingDim.getPositionCount() ? this.underlyingDim.getPositionStart(scrollablePosition) : this.underlyingDim.getSize();
        if (pixel < 0L) {
            return;
        }
        long delta = pixel - this.minimumOriginPixel;
        this.minimumOriginPosition = scrollablePosition;
        this.minimumOriginPixel = pixel;
        this.setOriginPixel(this.getOriginPixel() - delta);
        this.recalculateScrollBar();
    }

    @Override
    public long getOriginPixel() {
        if (((ViewportLayer)this.layer).isViewportOff()) {
            return this.minimumOriginPixel;
        }
        return this.originPixel;
    }

    @Override
    public long getOriginPosition() {
        if (this.cachedOriginPosition < 0L) {
            this.recalculateAvailableSizeAndPositionCount();
        }
        return this.cachedOriginPosition;
    }

    protected long adjustOrigin(long pixel) {
        if (this.getPositionCount() == 0L) {
            return 0L;
        }
        long availableSize = this.getClientAreaSize() - (this.underlyingDim.getSize() - pixel);
        if (availableSize <= 0L) {
            return pixel;
        }
        return pixel - availableSize;
    }

    private long boundsCheckOrigin(long pixel) {
        long min = this.getMinimumOriginPixel();
        if (pixel <= min) {
            return min;
        }
        long max = Math.max(this.underlyingDim.getSize() - 1L, min);
        if (pixel >= max) {
            return max;
        }
        return pixel;
    }

    @Override
    public void setOriginPixel(long scrollablePixel) {
        if (this.doSetOriginPixel(scrollablePixel)) {
            ((ViewportLayer)this.layer).fireScrollEvent();
        }
    }

    protected boolean doSetOriginPixel(long scrollablePixel) {
        scrollablePixel = this.boundsCheckOrigin(scrollablePixel);
        if (this.originPixel != (scrollablePixel = this.boundsCheckOrigin(this.adjustOrigin(scrollablePixel)))) {
            this.invalidateStructure();
            this.originPixel = scrollablePixel;
            return true;
        }
        return false;
    }

    @Override
    public void setOriginPosition(long scrollablePosition) {
        if (scrollablePosition < this.getMinimumOriginPosition() || scrollablePosition > this.getMinimumOriginPosition() && scrollablePosition >= this.underlyingDim.getPositionCount()) {
            throw new PositionOutOfBoundsException("scrollablePosition: " + scrollablePosition);
        }
        this.setOriginPixel(this.underlyingDim.getPositionStart(scrollablePosition));
    }

    @Override
    public void reset(long scrollablePosition) {
        if (scrollablePosition < 0L || scrollablePosition > 0L && scrollablePosition >= this.underlyingDim.getPositionCount()) {
            throw new PositionOutOfBoundsException("scrollablePosition: " + scrollablePosition);
        }
        this.minimumOriginPosition = 0L;
        this.minimumOriginPixel = 0L;
        this.originPixel = -1L;
        this.setOriginPosition(scrollablePosition);
    }

    @Override
    public void movePositionIntoViewport(long scrollablePosition) {
        if (this.underlyingDim.getPositionId(scrollablePosition, scrollablePosition) >= 0L && scrollablePosition >= this.getMinimumOriginPosition()) {
            if (scrollablePosition <= this.getOriginPosition()) {
                this.setOriginPosition(scrollablePosition);
            } else {
                long scrollableStart = this.underlyingDim.getPositionStart(scrollablePosition);
                long scrollableEnd = scrollableStart + (long)this.underlyingDim.getPositionSize(scrollablePosition);
                long clientAreaSize = this.getClientAreaSize();
                long originPosition = this.getOriginPosition();
                long viewportEnd = this.underlyingDim.getPositionStart(originPosition) + clientAreaSize;
                if (viewportEnd < scrollableEnd) {
                    this.setOriginPixel(Math.min(scrollableEnd - clientAreaSize, scrollableStart));
                }
            }
            this.adjustScrollBar();
        }
    }

    @Override
    public void scrollBackwardByStep() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long origin = this.getOriginPixel();
        long maxSize = origin - this.getMinimumOriginPixel();
        long stepSize = Math.min((long)this.getWindowStepSize(), maxSize);
        long position = this.getOriginPosition();
        long sizeForPosition = origin - this.underlyingDim.getPositionStart(position);
        if (sizeForPosition <= 0L && position > this.getMinimumOriginPosition()) {
            sizeForPosition += (long)this.underlyingDim.getPositionSize(position - 1L);
            --position;
        }
        if (sizeForPosition > 0L && sizeForPosition <= stepSize) {
            this.setOriginPixel(origin - sizeForPosition);
            return;
        }
        this.setOriginPixel(origin - stepSize / 2L);
    }

    @Override
    public void scrollForwardByStep() {
        long sizeForPosition;
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long origin = this.getOriginPixel();
        long maxSize = this.underlyingDim.getSize() - origin;
        long stepSize = Math.min((long)this.getWindowStepSize(), maxSize);
        long position = this.getOriginPosition();
        if (position + 1L < this.underlyingDim.getPositionCount() && (sizeForPosition = this.underlyingDim.getPositionStart(position + 1L) - origin) > 0L && sizeForPosition <= stepSize) {
            this.setOriginPixel(origin + sizeForPosition);
            return;
        }
        this.setOriginPixel(origin + stepSize / 2L);
    }

    private int getWindowStepSize() {
        int size = (int)this.getSize();
        int hint = size / 4 - 16;
        if (hint < 48) {
            return size;
        }
        return hint;
    }

    @Override
    public void scrollBackwardByPosition() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long position = this.getOriginPosition();
        long positionPixel = this.getPositionStart(position);
        if (positionPixel < this.getOriginPixel()) {
            this.setOriginPixel(positionPixel);
            return;
        }
        if (position - 1L >= this.getMinimumOriginPosition()) {
            this.setOriginPosition(position - 1L);
        }
    }

    @Override
    public void scrollForwardByPosition() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long position = this.getOriginPosition();
        if (position + 1L < this.underlyingDim.getPositionCount()) {
            this.setOriginPosition(position + 1L);
        }
    }

    @Override
    public void scrollBackwardByPage() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long origin = this.getOriginPixel();
        long maxSize = origin - this.getMinimumOriginPixel();
        long pageSize = Math.min(this.getWindowPageSize(), maxSize);
        long position = this.getOriginPosition();
        long sizeForPosition = origin - this.underlyingDim.getPositionStart(position);
        long bound = this.getMinimumOriginPosition();
        while (position > bound) {
            long size = this.underlyingDim.getPositionSize(position - 1L);
            if (sizeForPosition + size > pageSize) break;
            sizeForPosition += size;
            --position;
        }
        if (sizeForPosition > 16L && sizeForPosition <= pageSize) {
            this.setOriginPixel(origin - sizeForPosition);
            return;
        }
        if (pageSize == maxSize) {
            this.setOriginPixel(origin - pageSize);
            return;
        }
        this.setOriginPixel(origin - (pageSize - 16L));
    }

    @Override
    public void scrollForwardByPage() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        long origin = this.getOriginPixel();
        long maxSize = this.underlyingDim.getSize() - origin;
        long pageSize = Math.min(this.getWindowPageSize(), maxSize);
        long position = this.getOriginPosition();
        long sizeForPosition = this.underlyingDim.getPositionStart(position) - origin;
        long bound = this.underlyingDim.getPositionCount();
        while (position + 1L < bound) {
            long size = this.underlyingDim.getPositionSize(position);
            if (sizeForPosition + size > pageSize) break;
            sizeForPosition += size;
            ++position;
        }
        if (sizeForPosition >= 16L && sizeForPosition <= pageSize) {
            this.setOriginPixel(origin + sizeForPosition);
            return;
        }
        if (pageSize == maxSize) {
            this.setOriginPixel(origin + pageSize);
            return;
        }
        this.setOriginPixel(origin + (pageSize - 16L));
    }

    private long getWindowPageSize() {
        int size = (int)this.getSize();
        int hint = size - 8;
        if (hint < 64) {
            return size;
        }
        return hint;
    }

    @Override
    public void scrollBackwardToBound() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        this.setOriginPosition(this.getMinimumOriginPosition());
    }

    @Override
    public void scrollForwardToBound() {
        if (this.getPositionCount() == 0L || ((ViewportLayer)this.layer).isViewportOff()) {
            return;
        }
        this.setOriginPosition(this.getScrollable().getPositionCount() - 1L);
    }

    protected void checkScrollBar(Object control) {
        if (this.scrollBarAdapter == null) {
            this.scrollBarAdapter = ScrollBarHandler.create(this, control);
        }
    }

    private void adjustScrollBar() {
        ScrollBarHandler scrollBarAdapter = this.scrollBarAdapter;
        if (scrollBarAdapter != null) {
            scrollBarAdapter.adjustScrollBar();
        }
    }

    private void recalculateScrollBar() {
        if (this.scrollBarAdapter != null) {
            this.scrollBarAdapter.recalculateScrollBarSize();
            if (!this.scrollBarAdapter.getScrollBar().getEnabled()) {
                this.setOriginPosition(this.getMinimumOriginPosition());
            }
        }
    }

    protected void handleResize() {
        this.recalculateAvailableSizeAndPositionCount();
        this.setOriginPixel(this.getOriginPixel());
        this.recalculateScrollBar();
    }

    protected void handleStructuralChange(Collection<StructuralDiff> diffs) {
        long minimumOriginPosition = this.getMinimumOriginPosition();
        long minimumOriginPixel = this.getMinimumOriginPixel();
        long selectedOriginPosition = this.cachedOriginPosition;
        int selectedOriginPositionShift = this.cachedOriginPositionPixelShift;
        long selectedOriginPixel = this.originPixel;
        this.invalidateStructure();
        if (diffs != null) {
            int minimumPositionChange = 0;
            int selectedPositionChange = 0;
            int freezeMove = 0;
            for (StructuralDiff diff : diffs) {
                long start = diff.getBeforePositionRange().start;
                switch (diff.getDiffType()) {
                    case ADD: {
                        if (start < minimumOriginPosition || freezeMove == 1 && start == minimumOriginPosition) {
                            minimumPositionChange = (int)((long)minimumPositionChange + diff.getAfterPositionRange().size());
                        }
                        if (start >= selectedOriginPosition) break;
                        selectedPositionChange = (int)((long)selectedPositionChange + diff.getAfterPositionRange().size());
                        break;
                    }
                    case DELETE: {
                        if (start < minimumOriginPosition) {
                            minimumPositionChange = (int)((long)minimumPositionChange - (Math.min(diff.getBeforePositionRange().end, minimumOriginPosition + 1L) - start));
                            if (freezeMove == 0) {
                                freezeMove = 1;
                            }
                        } else {
                            freezeMove = -1;
                        }
                        if (start >= selectedOriginPosition) break;
                        selectedPositionChange = (int)((long)selectedPositionChange - (Math.min(diff.getBeforePositionRange().end, selectedOriginPosition + 1L) - start));
                        break;
                    }
                }
            }
            this.setMinimumOriginPosition(minimumOriginPosition + (long)minimumPositionChange);
            if (selectedOriginPosition >= 0L) {
                long pixel = this.underlyingDim.getPositionStart(selectedOriginPosition + (long)selectedPositionChange);
                if (pixel >= 0L) {
                    this.setOriginPixel(pixel + (long)selectedOriginPositionShift);
                }
            } else {
                this.setOriginPixel(selectedOriginPixel + (this.getMinimumOriginPixel() - minimumOriginPixel));
            }
        } else {
            this.recalculateAvailableSizeAndPositionCount();
        }
    }
}

