/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.menu;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.persistence.DisplayPersistenceDialogCommand;
import org.eclipse.statet.ecommons.waltable.resize.core.InitializeAutoResizeCommand;
import org.eclipse.statet.ecommons.waltable.style.editor.DisplayColumnStyleEditorCommand;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.statet.ecommons.waltable.ui.menu.IMenuItemProvider;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

public class MenuItemProviders {
    public static NatEventData getNatEventData(SelectionEvent selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (widget == null || !(widget instanceof MenuItem)) {
            return null;
        }
        MenuItem menuItem = (MenuItem)widget;
        Object data = null;
        for (Menu parentMenu = menuItem.getParent(); parentMenu != null; parentMenu = parentMenu.getParentMenu()) {
            if (parentMenu.getData() == null) {
                continue;
            }
            data = parentMenu.getData();
            break;
        }
        return data != null ? (NatEventData)data : null;
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeColumnMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeColumn"));
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
                autoResizeColumns.setText(menuLabel);
                autoResizeColumns.setImage(GUIHelper.getImage("auto_resize"));
                autoResizeColumns.setEnabled(true);
                autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        long columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeCommand(natTable.getDim(Orientation.HORIZONTAL), columnPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider() {
        return MenuItemProviders.autoResizeRowMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeRow"));
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeRows = new MenuItem(popupMenu, 8);
                autoResizeRows.setText(menuLabel);
                autoResizeRows.setEnabled(true);
                autoResizeRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        long rowPosition = MenuItemProviders.getNatEventData(event).getRowPosition();
                        natTable.doCommand(new InitializeAutoResizeCommand(natTable.getDim(Orientation.VERTICAL), rowPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeAllSelectedColumnMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeAllSelectedColumns"));
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
                autoResizeColumns.setText(menuLabel);
                autoResizeColumns.setEnabled(true);
                autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        long columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeCommand(natTable.getDim(Orientation.HORIZONTAL), columnPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider() {
        return MenuItemProviders.columnStyleEditorMenuItemProvider(Messages.getString("MenuItemProviders.editStyles"));
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
                columnStyleEditor.setText(menuLabel);
                columnStyleEditor.setImage(GUIHelper.getImage("preferences"));
                columnStyleEditor.setEnabled(true);
                columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        long rowPosition = MenuItemProviders.getNatEventData(event).getRowPosition();
                        long columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new DisplayColumnStyleEditorCommand(natTable, natTable.getConfigRegistry(), columnPosition, rowPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider inspectLabelsMenuItemProvider() {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem inspectLabelsMenuItem = new MenuItem(popupMenu, 8);
                inspectLabelsMenuItem.setText(Messages.getString("MenuItemProviders.debugInfo"));
                inspectLabelsMenuItem.setEnabled(true);
                inspectLabelsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NatEventData natEventData = MenuItemProviders.getNatEventData(e);
                        NatTable natTable = natEventData.getNatTable();
                        long columnPosition = natEventData.getColumnPosition();
                        long rowPosition = natEventData.getRowPosition();
                        LayerCell cell = natTable.getCellByPosition(columnPosition, rowPosition);
                        String msg = "Display mode: " + String.valueOf((Object)cell.getDisplayMode()) + "\nConfig labels: " + String.valueOf(cell.getLabels()) + "\nData value: " + String.valueOf(cell.getDataValue(0, null)) + "\n\nColumn position: " + columnPosition + "\nColumn id: " + cell.getDim(Orientation.HORIZONTAL).getId() + "\n\nRow position: " + rowPosition + "\nRow id: " + cell.getDim(Orientation.VERTICAL).getId();
                        MessageBox messageBox = new MessageBox(natTable.getShell(), 34);
                        messageBox.setText(Messages.getString("MenuItemProviders.debugInformation"));
                        messageBox.setMessage(msg);
                        messageBox.open();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider stateManagerMenuItemProvider() {
        return MenuItemProviders.stateManagerMenuItemProvider(Messages.getString("MenuItemProviders.stateManager"));
    }

    public static IMenuItemProvider stateManagerMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem saveState = new MenuItem(popupMenu, 8);
                saveState.setText(menuLabel);
                saveState.setImage(GUIHelper.getImage("table_icon"));
                saveState.setEnabled(true);
                saveState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new DisplayPersistenceDialogCommand(natTable));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider separatorMenuItemProvider() {
        return new IMenuItemProvider(){

            @Override
            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                new MenuItem(popupMenu, 2);
            }
        };
    }
}

