/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LineStylePicker
extends Composite {
    private final Combo combo;

    public LineStylePicker(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(new String[]{Messages.getString("LineStylePicker.solid"), Messages.getString("LineStylePicker.dashed"), Messages.getString("LineStylePicker.dotted"), Messages.getString("LineStylePicker.dashdot"), Messages.getString("LineStylePicker.dashdotdot")});
        this.combo.select(0);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public void setSelectedLineStyle(BorderStyle.LineStyle lineStyle) {
        int index = 0;
        if (lineStyle.equals((Object)BorderStyle.LineStyle.SOLID)) {
            index = 0;
        } else if (lineStyle.equals((Object)BorderStyle.LineStyle.DASHED)) {
            index = 1;
        } else if (lineStyle.equals((Object)BorderStyle.LineStyle.DOTTED)) {
            index = 2;
        } else if (lineStyle.equals((Object)BorderStyle.LineStyle.DASHDOT)) {
            index = 3;
        } else if (lineStyle.equals((Object)BorderStyle.LineStyle.DASHDOTDOT)) {
            index = 4;
        }
        this.combo.select(index);
    }

    public BorderStyle.LineStyle getSelectedLineStyle() {
        int index = this.combo.getSelectionIndex();
        if (index == 0) {
            return BorderStyle.LineStyle.SOLID;
        }
        if (index == 1) {
            return BorderStyle.LineStyle.DASHED;
        }
        if (index == 2) {
            return BorderStyle.LineStyle.DOTTED;
        }
        if (index == 3) {
            return BorderStyle.LineStyle.DASHDOT;
        }
        if (index == 4) {
            return BorderStyle.LineStyle.DASHDOTDOT;
        }
        throw new IllegalStateException("never happen");
    }
}

