/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer.events;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class StructuralDiff {
    private final DiffType diffType;
    private final LRange beforePositionRange;
    private final LRange afterPositionRange;

    public StructuralDiff(DiffType diffType, LRange beforePositionRange, LRange afterPositionRange) {
        this.diffType = (DiffType)((Object)ObjectUtils.nonNullAssert((Object)((Object)diffType)));
        this.beforePositionRange = (LRange)ObjectUtils.nonNullAssert((Object)beforePositionRange);
        this.afterPositionRange = (LRange)ObjectUtils.nonNullAssert((Object)afterPositionRange);
    }

    public DiffType getDiffType() {
        return this.diffType;
    }

    public LRange getBeforePositionRange() {
        return this.beforePositionRange;
    }

    public LRange getAfterPositionRange() {
        return this.afterPositionRange;
    }

    public int hashCode() {
        return (this.diffType.hashCode() * 13 + this.beforePositionRange.hashCode()) * 14 + this.afterPositionRange.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StructuralDiff) {
            StructuralDiff other = (StructuralDiff)obj;
            return this.diffType == other.diffType && this.beforePositionRange == other.beforePositionRange && this.afterPositionRange == other.afterPositionRange;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + String.valueOf((Object)this.diffType) + " ( before= " + String.valueOf(this.beforePositionRange) + ",  after= " + String.valueOf(this.afterPositionRange) + ")";
    }

    public static enum DiffType {
        ADD,
        CHANGE,
        DELETE;

    }
}

