/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class LayerUtils {
    public static final long convertPosition(LayerDim sourceDim, long sourceRefPosition, long sourcePosition, LayerDim targetDim) {
        if (targetDim == sourceDim) {
            return sourcePosition;
        }
        try {
            long id = sourceDim.getPositionId(sourceRefPosition, sourcePosition);
            return targetDim.getPositionById(id);
        }
        catch (PositionOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    public static final long convertColumnPosition(Layer sourceLayer, long sourceColumnPosition, Layer targetLayer) {
        return LayerUtils.convertPosition(sourceLayer.getDim(Orientation.HORIZONTAL), sourceColumnPosition, sourceColumnPosition, targetLayer.getDim(Orientation.HORIZONTAL));
    }

    public static final long convertRowPosition(Layer sourceLayer, long sourceRowPosition, Layer targetLayer) {
        return LayerUtils.convertPosition(sourceLayer.getDim(Orientation.VERTICAL), sourceRowPosition, sourceRowPosition, targetLayer.getDim(Orientation.VERTICAL));
    }
}

