/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import com.ibm.icu.text.DecimalFormat;
import java.util.Objects;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

@NonNullByDefault
public class IntText
implements IObjValueWidget<Integer> {
    private final Text text;
    private @Nullable Integer value;
    private final CopyOnWriteIdentityListSet<IObjValueListener<@Nullable Integer>> valueListeners = new CopyOnWriteIdentityListSet();
    private int increment;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private @Nullable DecimalFormat format;

    public IntText(Composite parent, int flags) {
        this.text = new Text(parent, 0x4004 | flags);
        SWTListener swtListener = new SWTListener();
        this.text.addListener(24, (Listener)swtListener);
        this.text.addListener(1, (Listener)swtListener);
    }

    public Text getControl() {
        return this.text;
    }

    @Override
    public Class<@Nullable Integer> getValueType() {
        return ObjectUtils.Nullable_Integer_TYPE;
    }

    public void setIncrement(int v) {
        this.increment = v;
    }

    public void setMinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public void addValueListener(IObjValueListener<@Nullable Integer> listener) {
        this.valueListeners.add((Object)((IObjValueListener)ObjectUtils.nonNullAssert(listener)));
    }

    @Override
    public void removeValueListener(IObjValueListener<@Nullable Integer> listener) {
        this.valueListeners.remove(listener);
    }

    @Override
    public @Nullable Integer getValue(int idx) {
        return this.value;
    }

    @Override
    public void setValue(int idx, @Nullable Integer value) {
        this.text.setText(this.formatValue(value));
    }

    private void incrementValue(int increment) {
        int newValue;
        Integer oldValue = this.value;
        int n = newValue = oldValue != null ? oldValue + increment : this.min;
        if (newValue < this.min) {
            newValue = this.min;
        } else if (newValue > this.max) {
            newValue = this.max;
        }
        this.text.setText(this.formatValue(newValue));
    }

    protected @Nullable Integer parseValue(String text) {
        try {
            return Integer.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String formatValue(@Nullable Integer value) {
        if (value == null) {
            return "";
        }
        DecimalFormat format = this.format;
        if (format != null) {
            return format.format((long)value.intValue());
        }
        return value.toString();
    }

    private void updateValue(int time) {
        Integer oldValue = this.value;
        Integer newValue = this.parseValue(this.text.getText());
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        this.value = newValue;
        ObjValueEvent<Integer> event = new ObjValueEvent<Integer>(this, time, 0, oldValue, newValue, 0);
        for (IObjValueListener listener : this.valueListeners) {
            event.newValue = newValue;
            listener.valueChanged(event);
        }
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 24: {
                    IntText.this.updateValue(event.time);
                    return;
                }
                case 1: {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            IntText.this.incrementValue(IntText.this.increment);
                            event.doit = false;
                            return;
                        }
                        case 0x1000002: {
                            IntText.this.incrementValue(-IntText.this.increment);
                            event.doit = false;
                            return;
                        }
                        case 0x1000005: {
                            IntText.this.incrementValue(IntText.this.increment * 10);
                            event.doit = false;
                            return;
                        }
                        case 0x1000006: {
                            IntText.this.incrementValue(-IntText.this.increment * 10);
                            event.doit = false;
                            return;
                        }
                    }
                }
            }
        }
    }
}

