/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class ExtensibleTextCellEditor
extends CellEditor {
    protected static final int DEFAULT_STYLE = 4;
    protected Text text;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private FocusGroup focusGroup;

    public ExtensibleTextCellEditor(Composite parent) {
        super(parent);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(Composite parent) {
        Control control = this.createCustomControl(parent);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExtensibleTextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ExtensibleTextCellEditor.this.keyReleaseOccured(e);
                if (ExtensibleTextCellEditor.this.getControl() == null || ExtensibleTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                ExtensibleTextCellEditor.this.checkSelection();
                ExtensibleTextCellEditor.this.checkDeleteable();
                ExtensibleTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ExtensibleTextCellEditor.this.checkSelection();
                ExtensibleTextCellEditor.this.checkDeleteable();
                ExtensibleTextCellEditor.this.checkSelectable();
            }
        });
        this.text.setFont(parent.getFont());
        this.text.setBackground(parent.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        this.text.setLayoutData((Object)new GridData(4, 128, true, false));
        this.focusGroup = new FocusGroup(){

            @Override
            protected void focusLost() {
                ExtensibleTextCellEditor.this.focusLost();
            }
        };
        this.focusGroup.addRecursivly(control);
        return control;
    }

    protected FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected abstract Control createCustomControl(Composite var1);

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof String ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)value);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = new CellEditor.LayoutData();
        layoutData.minimumWidth = 10;
        return layoutData;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExtensibleTextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected void fillToolsMenu(Menu menu) {
    }

    public static abstract class FocusGroup
    implements Listener {
        private final List<Widget> fControls = new ArrayList<Widget>();
        private Widget fWidget;
        private int fIgnore;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    Control control = Display.getCurrent().getFocusControl();
                    this.fWidget = event.widget != control && this.fControls.contains(control) ? control : null;
                    return;
                }
                case 15: {
                    this.fWidget = null;
                    return;
                }
                case 16: {
                    Widget control = this.fWidget;
                    this.fWidget = null;
                    if (this.fIgnore == 0 && event.widget != control) {
                        this.focusLost();
                    }
                    return;
                }
            }
        }

        protected abstract void focusLost();

        public void add(Control control) {
            this.fControls.add((Widget)control);
            control.addListener(26, (Listener)this);
            control.addListener(15, (Listener)this);
            control.addListener(16, (Listener)this);
        }

        public void addRecursivly(Control control) {
            if (control instanceof Composite) {
                Control[] children;
                Control[] controlArray = children = ((Composite)control).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.addRecursivly(child);
                    ++n2;
                }
            } else {
                this.add(control);
            }
        }

        public void discontinueTracking() {
            ++this.fIgnore;
        }

        public void continueTracking() {
            --this.fIgnore;
        }
    }
}

