/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.sections;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class BasicDocContentSections
implements DocContentSections {
    private final String partitioning;
    private final ImList<String> allTypes;
    private final String primaryType;

    protected BasicDocContentSections(String partitioning, ImList<String> allTypes) {
        this.partitioning = partitioning;
        this.allTypes = allTypes;
        this.primaryType = (String)allTypes.getFirst();
    }

    protected BasicDocContentSections(String partitioning, String primaryType) {
        this.partitioning = partitioning;
        this.allTypes = ImCollections.newList((Object)primaryType);
        this.primaryType = primaryType;
    }

    @Override
    public final String getPartitioning() {
        return this.partitioning;
    }

    @Override
    public final ImList<String> getAllTypes() {
        return this.allTypes;
    }

    @Override
    public final String getPrimaryType() {
        return this.primaryType;
    }

    @Override
    public String getType(IDocument document, int offset) {
        try {
            return this.getTypeByPartition(TextUtilities.getPartition((IDocument)document, (String)this.getPartitioning(), (int)offset, (boolean)true).getType());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    @Override
    public abstract String getTypeByPartition(String var1);
}

