/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.dsl.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.ui.settings.JFaceTextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class DslUIPlugin
extends AbstractUIPlugin {
    private static @Nullable DslUIPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private volatile @Nullable JFaceTextStyleManager dslTextStyleManager;

    public static DslUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        DslUIPlugin plugin = DslUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            DslUIPlugin dslUIPlugin = this;
            synchronized (dslUIPlugin) {
                this.started = false;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    DslUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.dsl.ui", "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.dsl/images/obj/Map", "obj_16", "dsl-map.png");
        util.register("org.eclipse.statet.dsl/images/obj/Seq", "obj_16", "dsl-seq.png");
        util.register("org.eclipse.statet.dsl/images/obj/Scalar", "obj_16", "dsl-scalar.png");
        util.register("org.eclipse.statet.dsl/images/obj/Label", "obj_16", "label.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferenceStoreTextStyleManager<TextAttribute> getDslTextStyleManager() {
        JFaceTextStyleManager textStyleManager = this.dslTextStyleManager;
        if (textStyleManager == null) {
            DslUIPlugin dslUIPlugin = this;
            synchronized (dslUIPlugin) {
                textStyleManager = this.dslTextStyleManager;
                if (textStyleManager == null) {
                    if (!this.started) {
                        throw new IllegalStateException("Plug-in is not started.");
                    }
                    textStyleManager = new JFaceTextStyleManager(this.getPreferenceStore(), "org.eclipse.statet.dsl.ui/textstyle/CommonDsl");
                    PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)textStyleManager);
                    this.dslTextStyleManager = textStyleManager;
                }
            }
        }
        return textStyleManager;
    }
}

