/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.doc;

import java.util.EnumMap;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.ecommons.collections.IntMap;
import org.eclipse.statet.ecommons.text.core.treepartitioner.BasicPartitionNodeType;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class WikitextPartitionNodeType
extends BasicPartitionNodeType {
    public static final WikitextPartitionNodeType DEFAULT_ROOT = new WikitextPartitionNodeType();
    public static final EnumMap<DocumentBuilder.BlockType, Block> BLOCK_TYPES = new EnumMap(DocumentBuilder.BlockType.class);
    public static final IntMap<Heading> HEADING_TYPES;

    static {
        DocumentBuilder.BlockType[] blockTypeArray = DocumentBuilder.BlockType.values();
        int n = blockTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentBuilder.BlockType blockType = blockTypeArray[n2];
            BLOCK_TYPES.put(blockType, new Block(blockType));
            ++n2;
        }
        HEADING_TYPES = new IntArrayMap();
        int level = 1;
        while (level <= 6) {
            HEADING_TYPES.put(level, (Object)new Heading(level));
            ++level;
        }
    }

    public String getPartitionType() {
        return "Wikitext.Default";
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DocumentBuilder.BlockType getBlockType() {
        return null;
    }

    public static class Block
    extends WikitextPartitionNodeType {
        private final DocumentBuilder.BlockType blockType;

        public Block(DocumentBuilder.BlockType blockType) {
            this.blockType = blockType;
        }

        @Override
        public DocumentBuilder.BlockType getBlockType() {
            return this.blockType;
        }

        public String toString() {
            return this.getPartitionType() + ":" + String.valueOf(this.blockType);
        }
    }

    public static class Heading
    extends WikitextPartitionNodeType {
        private final int level;

        public Heading(int level) {
            this.level = level;
        }

        public int getHeadingLevel() {
            return this.level;
        }

        public String toString() {
            return this.getPartitionType() + ":HEADING-" + this.level;
        }
    }
}

