/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class StandardEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final long length;
    private final DDMReader reader;
    private long remainingBytes;
    private ByteArrayInputStream currentBuffer;

    StandardEXTDTAReaderInputStream(DDMReader reader, boolean readStatusByte) throws DRDAProtocolException {
        super(false, readStatusByte);
        this.reader = reader;
        this.remainingBytes = readStatusByte ? reader.getDdmLength() - 1L : reader.getDdmLength();
        this.length = this.remainingBytes;
        this.currentBuffer = reader.readLOBInitStream(this.remainingBytes + (long)(readStatusByte ? 1 : 0));
    }

    @Override
    public final int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        return read == 1 ? b[0] : -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int val = this.currentBuffer.read(b, off, len = (int)Math.min(this.remainingBytes, (long)len));
        if (val < 0) {
            this.nextBuffer();
            val = this.currentBuffer.read(b, off, len);
        }
        if (this.readStatusByte && (long)val == this.remainingBytes) {
            if (this.currentBuffer.available() == 0) {
                this.nextBuffer();
            }
            this.checkStatus(this.currentBuffer.read());
            if (this.currentBuffer.read() != -1) {
                throw new IllegalStateException("Remaining bytes in buffer after status byte");
            }
        }
        this.remainingBytes -= (long)val;
        return val;
    }

    @Override
    public final int available() {
        if (this.remainingBytes <= 0L) {
            return 0;
        }
        int inBuffer = this.currentBuffer.available();
        if (this.readStatusByte && (long)inBuffer > this.remainingBytes) {
            --inBuffer;
        }
        return inBuffer;
    }

    final long getLength() {
        return this.length;
    }

    private void nextBuffer() throws IOException {
        long wireBytes = this.readStatusByte ? this.remainingBytes + 1L : this.remainingBytes;
        this.currentBuffer = this.reader.readLOBContinuationStream(wireBytes);
    }

    @Override
    protected void onClientSideStreamingError() {
        this.currentBuffer = null;
        this.remainingBytes = -1L;
    }
}

