/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public abstract class StatementPermission {
    StatementPermission() {
    }

    public abstract void check(LanguageConnectionContext var1, boolean var2, Activation var3) throws StandardException;

    public abstract PermissionsDescriptor getPermissionDescriptor(String var1, DataDictionary var2) throws StandardException;

    public boolean isCorrectPermission(PermissionsDescriptor pd) throws StandardException {
        return false;
    }

    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dd) throws StandardException {
        return null;
    }

    public String getObjectType() {
        return null;
    }

    public void genericCheck(LanguageConnectionContext lcc, boolean forGrant, Activation activation, String privilegeType) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ExecPreparedStatement ps = activation.getPreparedStatement();
        PermissionsDescriptor perm = this.getPermissionDescriptor(lcc.getCurrentUserId(activation), dd);
        if (!this.isCorrectPermission(perm)) {
            perm = this.getPermissionDescriptor("PUBLIC", dd);
        }
        if (this.isCorrectPermission(perm)) {
            return;
        }
        boolean resolved = false;
        String role = lcc.getCurrentRoleId(activation);
        if (role != null) {
            String dbo = dd.getAuthorizationDatabaseOwner();
            RoleGrantDescriptor rd = dd.getRoleGrantDescriptor(role, lcc.getCurrentUserId(activation), dbo);
            if (rd == null) {
                rd = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
            }
            if (rd == null) {
                lcc.setCurrentRole(activation, null);
            } else {
                String r;
                RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
                while (!resolved && (r = rci.next()) != null) {
                    perm = this.getPermissionDescriptor(r, dd);
                    if (!this.isCorrectPermission(perm)) continue;
                    resolved = true;
                }
            }
            if (resolved) {
                DependencyManager dm = dd.getDependencyManager();
                RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
                ContextManager cm = lcc.getContextManager();
                dm.addDependency(ps, rgd, cm);
                dm.addDependency(activation, rgd, cm);
            }
        }
        if (!resolved) {
            PrivilegedSQLObject pso = this.getPrivilegedObject(dd);
            if (pso == null) {
                throw StandardException.newException("4250E", this.getObjectType());
            }
            SchemaDescriptor sd = pso.getSchemaDescriptor();
            if (sd == null) {
                throw StandardException.newException("4250E", "SCHEMA");
            }
            throw StandardException.newException(forGrant ? "42505" : "42504", lcc.getCurrentUserId(activation), privilegeType, this.getObjectType(), sd.getSchemaName(), pso.getName());
        }
    }
}

