/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public final class ConsoleMessageCmdItem
extends MainCmdItem {
    private final String text;

    public ConsoleMessageCmdItem(String text) {
        assert (text != null);
        this.text = text;
    }

    public ConsoleMessageCmdItem(RJIO in) throws IOException, ClassNotFoundException {
        this.text = in.readString();
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeString(this.text);
    }

    @Override
    public byte getCmdType() {
        return 4;
    }

    @Override
    public byte getOp() {
        return 0;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public RjsStatus getStatus() {
        return null;
    }

    @Override
    public String getDataText() {
        return this.text;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof ConsoleMessageCmdItem)) {
            return false;
        }
        ConsoleMessageCmdItem otherItem = (ConsoleMessageCmdItem)other;
        if (this.options != otherItem.options) {
            return false;
        }
        return this.text.equals(otherItem.getDataText());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConsoleMessageCmdItem");
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        sb.append("\n<TEXT>\n");
        sb.append(this.text);
        sb.append("\n</TEXT>");
        return sb.toString();
    }
}

