/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core.variables;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;

public class ResourceVariables {
    public static final String RESOURCE_LOC_VAR_NAME = "resource_loc";
    public static final String RESOURCE_PATH_VAR_NAME = "resource_path";
    public static final String RESOURCE_NAME_VAR_NAME = "resource_name";
    public static final String RESOURCE_ENC_VAR_NAME = "resource_enc";
    public static final String CONTAINER_LOC_VAR_NAME = "container_loc";
    public static final String CONTAINER_PATH_VAR_NAME = "container_path";
    public static final String CONTAINER_NAME_VAR_NAME = "container_name";
    public static final String CONTAINER_ENC_VAR_NAME = "container_enc";
    public static final String PROJECT_LOC_VAR_NAME = "project_loc";
    public static final String PROJECT_PATH_VAR_NAME = "project_path";
    public static final String PROJECT_NAME_VAR_NAME = "project_name";
    public static final String PROJECT_ENC_VAR_NAME = "project_enc";
    public static final String WORKSPACE_LOC = "workspace_loc";
    public static final String FILE_NAME_BASE_VAR_NAME = "file_name_base";
    public static final String FILE_NAME_EXT_VAR_NAME = "file_name_ext";
    public static final ImList<String> SINGLE_RESOURCE_VAR_NAMES = ImCollections.newList((Object[])new String[]{"resource_loc", "resource_path", "resource_name", "resource_enc", "container_loc", "container_path", "container_name", "container_enc", "project_loc", "project_path", "project_name", "project_enc", "file_name_base", "file_name_ext"});
    private static volatile ImList<IDynamicVariable> singleResourceVariables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImList<IDynamicVariable> getSingleResourceVariables() {
        if (singleResourceVariables == null) {
            ImList<String> imList = SINGLE_RESOURCE_VAR_NAMES;
            synchronized (imList) {
                if (singleResourceVariables == null) {
                    singleResourceVariables = ResourceVariables.createSingleResourceVars();
                }
            }
        }
        return singleResourceVariables;
    }

    private static final ImList<IDynamicVariable> createSingleResourceVars() {
        ImList<String> names = SINGLE_RESOURCE_VAR_NAMES;
        Object[] variables = new IDynamicVariable[names.size()];
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        int i = 0;
        while (i < variables.length) {
            String name = (String)names.get(i);
            IDynamicVariable globalVariable = manager.getDynamicVariable(name);
            variables[i] = globalVariable != null ? globalVariable : new DynamicVariable.ResolverVariable(name, null, true, (IDynamicVariableResolver)new ResourceVariableResolver());
            ++i;
        }
        return ImCollections.newList((Object[])variables);
    }

    public static final ImList<IDynamicVariable> createSingleResourceVarDefs(String selectedResourceTerm) {
        ImList<IDynamicVariable> globalVariables = ResourceVariables.getSingleResourceVariables();
        Object[] variables = new IDynamicVariable[globalVariables.size()];
        Matcher selResMatcher = Pattern.compile("selected resource", 16).matcher("");
        String selResReplacement = Matcher.quoteReplacement(selectedResourceTerm);
        int i = 0;
        while (i < variables.length) {
            IDynamicVariable globalVariable = (IDynamicVariable)globalVariables.get(i);
            String description = globalVariable.getDescription();
            if (description != null) {
                description = selResMatcher.reset(description).replaceAll(selResReplacement);
            }
            variables[i] = new DynamicVariable(globalVariable.getName(), description, globalVariable.supportsArgument());
            ++i;
        }
        return ImCollections.newList((Object[])variables);
    }

    private ResourceVariables() {
    }
}

