/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.internal.r.ui.pkgmanager.StatusLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class StatusPage
extends WizardPage {
    public static final String PAGE_NAME = "StatusPage";
    private final boolean allowIgnore;
    private IStatus status;
    private TableViewer childViewer;
    private Button ignoreControl;

    public StatusPage(String title, boolean allowIgnore) {
        super(PAGE_NAME);
        this.allowIgnore = allowIgnore;
        this.status = Status.OK_STATUS;
        this.setTitle(title);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
        Label label = new Label(composite, 0);
        label.setText("&Issues:");
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        Control detail = this.createDetailArea(composite);
        detail.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.allowIgnore) {
            Button button;
            this.ignoreControl = button = new Button(composite, 32);
            button.setText("Ignore shown issues and continue.");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StatusPage.this.updateState();
                }
            });
            button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setStatus(this.status);
    }

    protected Control createDetailArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.childViewer = new TableViewer(composite);
        this.childViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.childViewer.setLabelProvider((IBaseLabelProvider)new StatusLabelProvider());
        this.childViewer.getTable().setToolTipText(null);
        new ColumnViewerToolTipSupport((ColumnViewer)this.childViewer, 2, false){

            protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
                Label label;
                Image image = this.getImage(event);
                String text = this.getText(event);
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)(image != null ? 2 : 1)));
                composite.setBackgroundMode(1);
                Color color = this.getBackgroundColor(event);
                if (color != null) {
                    composite.setBackground(color);
                }
                if (image != null) {
                    label = new Label(composite, 16512);
                    label.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
                    label.setImage(image);
                }
                label = new Label(composite, 0x40004040);
                GridData gd = new GridData(4, 4, true, true);
                gd.widthHint = new PixelConverter((Control)label).convertWidthInCharsToPixels(80);
                label.setLayoutData((Object)gd);
                label.setText(text);
                label.setForeground(this.getForegroundColor(event));
                return composite;
            }
        };
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Table)this.childViewer.getTable(), (int)8);
        gd.widthHint = 100;
        this.childViewer.getControl().setLayoutData((Object)gd);
        return composite;
    }

    public void setStatus(IStatus status) {
        if (status == null) {
            throw new NullPointerException("status");
        }
        this.status = status;
        if (this.isControlCreated()) {
            StatusInfo.applyToStatusLine((DialogPage)this, (IStatus)status);
            this.childViewer.setInput((Object)(status.isMultiStatus() ? status.getChildren() : new Object[]{}));
            if (this.ignoreControl != null) {
                this.ignoreControl.setEnabled(this.status.getSeverity() >= 4);
            }
        }
        this.updateState();
    }

    private void updateState() {
        this.setPageComplete(this.status.getSeverity() < 4 || this.ignoreControl != null && this.ignoreControl.getSelection());
    }
}

